/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.pool.client.secure;

import java.net.SocketException;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentSecurityException;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;

public class SecureClientPoolFactory
extends BaseKeyedPoolableObjectFactory {
    private TSSLTransportFactory.TSSLTransportParameters params;
    private String trustStorePassword;
    private String trustStore;

    public SecureClientPoolFactory(String trustStorePassword, String trustStore) {
        this.trustStorePassword = trustStorePassword;
        this.trustStore = trustStore;
    }

    public ThriftSecureEventTransmissionService.Client makeObject(Object key) throws AgentSecurityException, TTransportException {
        String[] keyElements = key.toString().split(",");
        if (keyElements[2].equals(ReceiverConfiguration.Protocol.TCP.toString())) {
            if (this.params == null) {
                if (this.trustStore == null) {
                    this.trustStore = System.getProperty("javax.net.ssl.trustStore");
                    if (this.trustStore == null) {
                        throw new AgentSecurityException("No trustStore found");
                    }
                }
                if (this.trustStorePassword == null) {
                    this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                    if (this.trustStorePassword == null) {
                        throw new AgentSecurityException("No trustStore password found");
                    }
                }
                this.params = new TSSLTransportFactory.TSSLTransportParameters();
                this.params.setTrustStore(this.trustStore, this.trustStorePassword);
            }
            String[] hostNameAndPort = keyElements[3].split(":");
            TSocket receiverTransport = null;
            try {
                receiverTransport = TSSLTransportFactory.getClientSocket((String)HostAddressFinder.findAddress((String)hostNameAndPort[0]), (int)Integer.parseInt(hostNameAndPort[1]), (int)0, (TSSLTransportFactory.TSSLTransportParameters)this.params);
            }
            catch (SocketException ignored) {
                // empty catch block
            }
            TBinaryProtocol protocol = new TBinaryProtocol(receiverTransport);
            return new ThriftSecureEventTransmissionService.Client((TProtocol)protocol);
        }
        THttpClient client = new THttpClient("https://" + keyElements[3] + "/thriftAuthenticator");
        TCompactProtocol protocol = new TCompactProtocol((TTransport)client);
        ThriftSecureEventTransmissionService.Client authClient = new ThriftSecureEventTransmissionService.Client((TProtocol)protocol);
        client.open();
        return authClient;
    }

    public boolean validateObject(Object key, Object obj) {
        ThriftSecureEventTransmissionService.Client client = (ThriftSecureEventTransmissionService.Client)obj;
        return client.getOutputProtocol().getTransport().isOpen();
    }
}

