/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.publisher.client;

import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.carbon.databridge.agent.thrift.conf.DataPublisherConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.exception.EventPublisherException;
import org.wso2.carbon.databridge.agent.thrift.internal.EventQueue;
import org.wso2.carbon.databridge.agent.thrift.internal.publisher.authenticator.AgentAuthenticator;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;

public abstract class EventPublisher
implements Runnable {
    private static Log log = LogFactory.getLog(EventPublisher.class);
    private EventQueue<Event> eventQueue;
    private GenericKeyedObjectPool transportPool;
    private Semaphore queueSemaphore;
    private int maxMessageBundleSize;
    private DataPublisherConfiguration dataPublisherConfiguration;
    private AgentAuthenticator agentAuthenticator;
    private ThreadPoolExecutor threadPool;

    public EventPublisher(EventQueue<Event> eventQueue, GenericKeyedObjectPool transportPool, Semaphore queueSemaphore, int maxMessageBundleSize, DataPublisherConfiguration dataPublisherConfiguration, AgentAuthenticator agentAuthenticator, ThreadPoolExecutor threadPool) {
        this.eventQueue = eventQueue;
        this.transportPool = transportPool;
        this.queueSemaphore = queueSemaphore;
        this.maxMessageBundleSize = maxMessageBundleSize;
        this.dataPublisherConfiguration = dataPublisherConfiguration;
        this.agentAuthenticator = agentAuthenticator;
        this.threadPool = threadPool;
    }

    @Override
    public void run() {
        block2: {
            Event event;
            ThriftEventBundle eventBundle = null;
            while ((event = this.eventQueue.poll()) != null) {
                this.queueSemaphore.release();
                if (this.getNumberOfEvents(eventBundle = this.convertToEventBundle(eventBundle, event, this.dataPublisherConfiguration.getSessionId())) < this.maxMessageBundleSize) continue;
                this.publishEvent(eventBundle);
                if (this.threadPool.getActiveCount() < this.threadPool.getCorePoolSize()) {
                    eventBundle = null;
                    continue;
                }
                this.threadPool.submit(this);
                break block2;
            }
            if (eventBundle == null) break block2;
            this.publishEvent(eventBundle);
        }
    }

    private void publishEvent(Object eventBundle) {
        Object client = null;
        try {
            client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
            this.setSessionId(eventBundle, this.dataPublisherConfiguration.getSessionId());
            this.publish(client, eventBundle);
        }
        catch (AgentException e) {
            log.error((Object)("Cannot get a client to send events to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
            this.transportPool.clear((Object)this.dataPublisherConfiguration.getPublisherKey());
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            this.setSessionId(eventBundle, this.reconnect(this.getSessionId(eventBundle)));
            this.republish(client, eventBundle);
        }
        catch (UndefinedEventTypeException e) {
            log.error((Object)("Wrongly typed event " + eventBundle + " sent to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
        }
        catch (EventPublisherException e) {
            log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
        }
        try {
            this.transportPool.returnObject((Object)this.dataPublisherConfiguration.getPublisherKey(), client);
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while returning object to connection pool");
            this.transportPool.clear((Object)this.dataPublisherConfiguration.getPublisherKey());
        }
    }

    private void republish(Object client, Object eventBundle) {
        try {
            this.publish(client, eventBundle);
        }
        catch (EventPublisherException e) {
            log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)e);
        }
        catch (SessionTimeoutException e) {
            log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)e);
        }
        catch (UndefinedEventTypeException e) {
            log.error((Object)("Wrongly typed event " + eventBundle.toString() + " sent  to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
        }
    }

    protected abstract int getNumberOfEvents(Object var1);

    protected abstract ThriftEventBundle convertToEventBundle(Object var1, Event var2, String var3);

    protected abstract void setSessionId(Object var1, String var2);

    protected abstract String getSessionId(Object var1);

    abstract void publish(Object var1, Object var2) throws UndefinedEventTypeException, SessionTimeoutException, EventPublisherException;

    public String defineStream(String sessionId, String streamDefinition) throws AgentException, DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, StreamDefinitionException {
        String currentSessionId = sessionId;
        String streamId = null;
        Object client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
        try {
            streamId = this.defineStream(client, currentSessionId, streamDefinition);
            this.transportPool.returnObject((Object)this.dataPublisherConfiguration.getPublisherKey(), client);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            currentSessionId = this.reconnect(currentSessionId);
            this.redefineStream(client, streamDefinition, currentSessionId);
        }
        catch (StreamDefinitionException e) {
            throw new StreamDefinitionException("Invalid type definition for stream " + streamDefinition, (Throwable)e);
        }
        catch (EventPublisherException e) {
            throw new AgentException("Cannot define type " + streamDefinition, e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new DifferentStreamDefinitionAlreadyDefinedException("Same stream id with different definition already defined before sending this event definitions to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)e);
        }
        catch (MalformedStreamDefinitionException e) {
            throw new MalformedStreamDefinitionException("Malformed event definition :" + streamDefinition + " send  to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)e);
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while returning object to connection pool", (Throwable)e);
        }
        return streamId;
    }

    protected abstract String defineStream(Object var1, String var2, String var3) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, EventPublisherException, SessionTimeoutException, StreamDefinitionException;

    private void redefineStream(Object client, String streamDefinition, String currentSessionId) throws DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionException, MalformedStreamDefinitionException {
        try {
            this.defineStream(client, currentSessionId, streamDefinition);
        }
        catch (SessionTimeoutException ex) {
            log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
        }
        catch (EventPublisherException ex) {
            log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException ex) {
            throw new DifferentStreamDefinitionAlreadyDefinedException("Type already defined when send event definitions to" + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)ex);
        }
        catch (StreamDefinitionException ex) {
            throw new StreamDefinitionException("Wrongly defined event definition after reconnection  :" + streamDefinition + " sent to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)ex);
        }
        catch (MalformedStreamDefinitionException ex) {
            throw new MalformedStreamDefinitionException("Malformed event definition after reconnection  :" + streamDefinition + " sent to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)ex);
        }
    }

    public String findStreamId(String sessionId, String name, String version) throws AgentException, StreamDefinitionException, NoStreamDefinitionExistException {
        String currentSessionId = sessionId;
        String streamId = null;
        Object client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
        try {
            streamId = this.findStreamId(client, currentSessionId, name, version);
            this.transportPool.returnObject((Object)this.dataPublisherConfiguration.getPublisherKey(), client);
        }
        catch (NoStreamDefinitionExistException e) {
            throw new NoStreamDefinitionExistException("No stream id found for : " + name + " " + version, (Throwable)e);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            currentSessionId = this.reconnect(currentSessionId);
            try {
                streamId = this.findStreamId(client, currentSessionId, name, version);
            }
            catch (SessionTimeoutException ex) {
                log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            }
            catch (EventPublisherException ex) {
                log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            }
            catch (NoStreamDefinitionExistException ex) {
                throw new NoStreamDefinitionExistException("No stream id found for : " + name + " " + version, (Throwable)ex);
            }
        }
        catch (EventPublisherException e) {
            throw new AgentException("Error when finding event stream definition for : " + name + " " + version, e);
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while returning object to connection pool", (Throwable)e);
        }
        return streamId;
    }

    protected abstract String findStreamId(Object var1, String var2, String var3, String var4) throws NoStreamDefinitionExistException, SessionTimeoutException, EventPublisherException;

    private String reconnect(String currentSessionId) {
        this.attemptReconnection(3, currentSessionId);
        return this.dataPublisherConfiguration.getSessionId();
    }

    public synchronized void attemptReconnection(int reconnectionTime, String sessionId) {
        if (!this.dataPublisherConfiguration.getSessionId().equals(sessionId)) {
            return;
        }
        if (reconnectionTime > 0) {
            try {
                this.dataPublisherConfiguration.setSessionId(this.agentAuthenticator.connect(this.dataPublisherConfiguration));
            }
            catch (AuthenticationException e) {
                log.error((Object)(this.dataPublisherConfiguration.getReceiverConfiguration().getUserName() + " not authorised to access server at " + this.dataPublisherConfiguration.getPublisherKey()));
            }
            catch (TransportException e) {
                this.attemptReconnection(reconnectionTime - 1, sessionId);
            }
            catch (AgentException e) {
                this.attemptReconnection(reconnectionTime - 1, sessionId);
            }
        }
    }

    private Object getClient(String publisherKey) throws AgentException {
        try {
            return this.transportPool.borrowObject((Object)publisherKey);
        }
        catch (Exception e) {
            throw new AgentException("Cannot borrow client for " + publisherKey, e);
        }
    }
}

