/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.conf.DataPublisherConfiguration;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.internal.EventQueue;
import org.wso2.carbon.databridge.agent.thrift.internal.publisher.client.EventPublisher;
import org.wso2.carbon.databridge.agent.thrift.internal.publisher.client.EventPublisherFactory;
import org.wso2.carbon.databridge.agent.thrift.internal.utils.AgentServerURL;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;

public class DataPublisher {
    private static Log log = LogFactory.getLog(DataPublisher.class);
    private Agent agent;
    private DataPublisherConfiguration dataPublisherConfiguration;
    private EventPublisher eventPublisher;
    private EventQueue<Event> eventQueue;
    private Gson gson = new Gson();
    private ThreadPoolExecutor threadPool;

    public DataPublisher(String receiverUrl, String userName, String password) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        this(receiverUrl, userName, password, new Agent());
    }

    public DataPublisher(String authenticationUrl, String receiverUrl, String userName, String password) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        this(authenticationUrl, receiverUrl, userName, password, new Agent());
    }

    public DataPublisher(String receiverUrl, String userName, String password, Agent agent) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        AgentServerURL receiverURL = new AgentServerURL(receiverUrl);
        if (receiverURL.isSecured()) {
            this.start(new ReceiverConfiguration(userName, password, this.findHostAddress(receiverURL.getHost()), receiverURL.getPort(), this.findHostAddress(receiverURL.getHost()), receiverURL.getPort(), receiverURL.isSecured()), agent);
        } else {
            this.start(new ReceiverConfiguration(userName, password, this.findHostAddress(receiverURL.getHost()), receiverURL.getPort(), this.findHostAddress(receiverURL.getHost()), receiverURL.getPort() + 100, receiverURL.isSecured()), agent);
        }
    }

    public DataPublisher(String authenticationUrl, String receiverUrl, String userName, String password, Agent agent) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        AgentServerURL authenticationURL = new AgentServerURL(authenticationUrl);
        if (!authenticationURL.isSecured()) {
            throw new MalformedURLException("Authentication url protocol is not ssl, expected = ssl://<HOST>:<PORT> but actual = " + authenticationUrl);
        }
        AgentServerURL receiverURL = new AgentServerURL(receiverUrl);
        this.start(new ReceiverConfiguration(userName, password, this.findHostAddress(receiverURL.getHost()), receiverURL.getPort(), this.findHostAddress(authenticationURL.getHost()), authenticationURL.getPort(), receiverURL.isSecured()), agent);
    }

    private String findHostAddress(String hostAddress) {
        try {
            return HostAddressFinder.findAddress((String)hostAddress);
        }
        catch (SocketException e) {
            log.warn((Object)("Cannot find the appropriate server host address hence using " + hostAddress + " due to SocketException: " + e.getMessage()));
            return hostAddress;
        }
    }

    public void setAgent(Agent agent) throws AgentException, AuthenticationException, TransportException {
        this.agent.shutdown(this);
        this.start(this.dataPublisherConfiguration.getReceiverConfiguration(), agent);
    }

    public Agent getAgent() {
        return this.agent;
    }

    private void start(ReceiverConfiguration receiverConfiguration, Agent agent) throws AgentException, AuthenticationException, TransportException {
        agent.addDataPublisher(this);
        this.agent = agent;
        this.dataPublisherConfiguration = new DataPublisherConfiguration(receiverConfiguration);
        this.eventQueue = new EventQueue();
        this.threadPool = agent.getThreadPool();
        this.eventPublisher = receiverConfiguration.isDataTransferSecured() ? EventPublisherFactory.getEventPublisher(this.dataPublisherConfiguration, this.eventQueue, agent, agent.getSecureTransportPool()) : EventPublisherFactory.getEventPublisher(this.dataPublisherConfiguration, this.eventQueue, agent, agent.getTransportPool());
        this.dataPublisherConfiguration.setSessionId(agent.getAgentAuthenticator().connect(this.dataPublisherConfiguration));
    }

    public String defineStream(String streamDefinition) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.defineStream(sessionId, streamDefinition);
    }

    public String defineStream(StreamDefinition streamDefinition) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        String streamId = this.eventPublisher.defineStream(sessionId, this.gson.toJson((Object)streamDefinition));
        try {
            Field field = StreamDefinition.class.getDeclaredField("streamId");
            field.setAccessible(true);
            field.set(streamDefinition, streamId);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return streamId;
    }

    public String findStream(String name, String version) throws AgentException, StreamDefinitionException, NoStreamDefinitionExistException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.findStreamId(sessionId, name, version);
    }

    public void publish(Event event) throws AgentException {
        try {
            this.agent.getQueueSemaphore().acquire();
            if (!this.eventQueue.put(event)) {
                try {
                    this.threadPool.submit(this.eventPublisher);
                }
                catch (RejectedExecutionException ignored) {}
            }
        }
        catch (InterruptedException e) {
            throw new AgentException("Cannot add " + event + " to event queue", e);
        }
    }

    public void publish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void publish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void stop() {
        this.agent.getAgentAuthenticator().disconnect(this.dataPublisherConfiguration);
        this.agent.shutdown(this);
    }
}

