/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.dashboard.DashboardContext;
import org.wso2.carbon.dashboard.DashboardDSService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DashboardServiceComponent {
    private static final Log log = LogFactory.getLog(DashboardServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            context.getBundleContext().registerService(DashboardDSService.class.getName(), (Object)new DashboardDSService(), null);
            log.debug((Object)"Dashboard Backend Component bundle is activated ");
        }
        catch (Exception e) {
            log.debug((Object)"Failed to activate Dashboard Backend Component bundle ");
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Dashboard Backend Component bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        DashboardContext.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        DashboardContext.setRegistryService(null);
    }

    protected void setUserRealm(UserRealm userRealm) {
        DashboardContext.setUserRealm(userRealm);
    }

    protected void unsetUserRealm(UserRealm usrRealm) {
        DashboardContext.setUserRealm(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtx) {
        DashboardContext.setConfigContextService(configCtx);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtx) {
        DashboardContext.setConfigContextService(null);
    }
}

