/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dashboard.DashboardContext;
import org.wso2.carbon.dashboard.DashboardException;
import org.wso2.carbon.dashboard.bean.DashboardUtilBean;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DashboardUtilService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DashboardUtilService.class);

    private Boolean isAnonModeActive(String tDomain) {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = DashboardContext.getRegistry(MultitenantUtils.getTenantId((ConfigurationContext)DashboardContext.getConfigContext()));
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.ANON_MODE_ACT)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private Boolean isSessionValid() {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        return !httpSession.isNew();
    }

    private String[] getGadgetUrlSetForUnSignedUser() {
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='" + DashboardConstants.UNSIGNED_USER_GADGET + "' AND " + "P.REG_VALUE='true' AND " + "P.REG_ID=RP.REG_PROPERTY_ID AND " + "PA.REG_PATH_ID=R.REG_PATH_ID";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("query", sql);
            Collection qResults = registry.executeQuery(null, map);
            String[] qPaths = (String[])qResults.getContent();
            ArrayList<String> gadgetUrlsList = new ArrayList<String>();
            for (String qPath : qPaths) {
                if (!registry.resourceExists(qPath)) continue;
                Resource tempRes = registry.get(qPath);
                String gadgetNameTmp = tempRes.getProperty(DashboardConstants.GADGET_NAME);
                String gadgetUrlTmp = tempRes.getProperty(DashboardConstants.GADGET_URL);
                if (!this.isGadgetAutharized("wso2.anonymous.user", gadgetUrlTmp)) continue;
                gadgetUrlsList.add(gadgetNameTmp + "," + gadgetUrlTmp);
            }
            String[] nameUrlPair = new String[gadgetUrlsList.size()];
            gadgetUrlsList.toArray(nameUrlPair);
            return nameUrlPair;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the unsigned_user gadget url set", (Throwable)e);
            return null;
        }
    }

    private boolean isGadgetAutharized(String user, String gadgetUrl) throws UserStoreException {
        if (!gadgetUrl.startsWith("/registry")) {
            return true;
        }
        gadgetUrl = gadgetUrl.split("resource")[1];
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        if (registry == null) {
            registry = (UserRegistry)this.getConfigSystemRegistry();
        }
        return registry.getUserRealm().getAuthorizationManager().isUserAuthorized(user, gadgetUrl, "http://www.wso2.org/projects/registry/actions/get");
    }

    private String getBackendHttpPort() {
        String httpPort = null;
        try {
            int port = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            if (port == -1) {
                port = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            }
            httpPort = Integer.toString(port);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return httpPort;
    }

    public DashboardUtilBean getDashboardUtils(String tDomain) throws DashboardException {
        DashboardUtilBean dashboardUtilBean = new DashboardUtilBean();
        dashboardUtilBean.setAnonModeActive(this.isAnonModeActive(tDomain));
        dashboardUtilBean.setSessionValid(this.isSessionValid());
        dashboardUtilBean.setGadgetUrlSetForUnSignedUser(this.getGadgetUrlSetForUnSignedUser());
        dashboardUtilBean.setBackendHttpPort(this.getBackendHttpPort());
        return dashboardUtilBean;
    }
}

