/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.ui.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.ui.DashboardUiContext;
import org.wso2.carbon.dashboard.ui.servlets.MakeSoapRequestServiceClient;

public class MakeSoapRequestServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(MakeSoapRequestServlet.class);

    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        String endpoint = servletRequest.getParameter("endpoint");
        String payload = servletRequest.getParameter("payload");
        String operation = servletRequest.getParameter("operation");
        if (endpoint == null) {
            servletResponse.getWriter().println("<error><description>An end point URL was not specified</description></error>");
        } else {
            try {
                MakeSoapRequestServiceClient serviceClient = new MakeSoapRequestServiceClient(DashboardUiContext.getConfigContext());
                OMElement response = serviceClient.makeRequest(endpoint, operation, payload);
                servletResponse.getWriter().println(response.toString());
            }
            catch (Exception e) {
                String errorMessage = "An error occurred while relaying a SOAP payload, " + payload + " to end point " + endpoint;
                log.error((Object)errorMessage, (Throwable)e);
                servletResponse.getWriter().println("<error><description>" + errorMessage + "</description></error>");
            }
        }
    }
}

