/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.ui.processors;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.stub.resource.beans.xsd.ContentDownloadBean;
import org.wso2.carbon.dashboard.ui.GadgetResourceServiceClient;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class GadgetContentProcessor {
    private static final Log log = LogFactory.getLog(GadgetContentProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getContent(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws Exception {
        block12: {
            try {
                GadgetResourceServiceClient client = new GadgetResourceServiceClient(config, request.getSession());
                String uri = request.getRequestURI();
                String path = uri.split("registry/resource")[1];
                if (path == null) {
                    String msg = "Could not get the resource content. Path is not specified.";
                    log.error((Object)msg);
                    response.setStatus(400);
                    return;
                }
                String tenantDomain = (String)request.getAttribute("tenantDomain");
                ContentDownloadBean bean = client.getContentDownloadBean(path, tenantDomain);
                if (bean.getContent() == null) {
                    String msg = "The resource content was empty.";
                    log.error((Object)msg);
                    response.setStatus(204);
                    return;
                }
                InputStream contentStream = bean.getContent().getInputStream();
                response.setDateHeader("Last-Modified", bean.getLastUpdatedTime().getTime().getTime());
                if (bean.getMediatype() != null && bean.getMediatype().length() > 0) {
                    response.setContentType(bean.getMediatype());
                } else {
                    response.setContentType("application/download");
                }
                if (contentStream == null) break block12;
                ServletOutputStream servletOutputStream = null;
                try {
                    int byteCount;
                    servletOutputStream = response.getOutputStream();
                    byte[] contentChunk = new byte[1024];
                    while ((byteCount = contentStream.read(contentChunk)) != -1) {
                        servletOutputStream.write(contentChunk, 0, byteCount);
                    }
                    response.setContentLength(byteCount);
                    response.flushBuffer();
                    servletOutputStream.flush();
                }
                finally {
                    contentStream.close();
                    if (servletOutputStream != null) {
                        servletOutputStream.close();
                    }
                }
            }
            catch (RegistryException e) {
                String msg = "Failed to get resource content. " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                response.setStatus(500);
            }
            catch (IOException ex) {
                log.debug((Object)ex);
                if (ex.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) break block12;
                throw ex;
            }
        }
    }
}

