/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.ui;

import java.rmi.RemoteException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.stub.resource.GadgetContentServiceException;
import org.wso2.carbon.dashboard.stub.resource.GadgetContentServiceStub;
import org.wso2.carbon.dashboard.stub.resource.beans.xsd.ContentDownloadBean;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class GadgetResourceServiceClient {
    private GadgetContentServiceStub stub;
    private String epr;
    private static final Log log = LogFactory.getLog(GadgetResourceServiceClient.class);

    public GadgetResourceServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "GadgetContentService";
        try {
            this.stub = new GadgetContentServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ContentDownloadBean getContentDownloadBean(String path, String tenantDomain) throws GadgetContentServiceException, RemoteException {
        ContentDownloadBean bean = this.stub.getContentDownloadBean(path, tenantDomain);
        return bean;
    }
}

