/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.inject.Inject;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

public class AllJsIframeVersioner
implements IframeUriManager.Versioner {
    private final String allJsChecksum;

    @Inject
    public AllJsIframeVersioner(FeatureRegistry registry) {
        StringBuilder jsBuf = new StringBuilder();
        for (FeatureResource resource : registry.getAllFeatures()) {
            jsBuf.append(resource.getContent()).append(resource.getDebugContent());
        }
        this.allJsChecksum = HashUtil.checksum(jsBuf.toString().getBytes());
    }

    public String version(Uri gadgetUri, String container) {
        return this.allJsChecksum;
    }

    public UriStatus validate(Uri gadgetUri, String container, String value) {
        if (value == null || value.length() == 0) {
            return UriStatus.VALID_UNVERSIONED;
        }
        if (value.equals(this.allJsChecksum)) {
            return UriStatus.VALID_VERSIONED;
        }
        return UriStatus.INVALID_VERSION;
    }
}

