/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.InvalidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInvalidationService
implements InvalidationService {
    public static final String CACHE_NAME = "invalidatedUsers";
    private final HttpCache httpCache;
    protected final Cache<String, Long> invalidationEntries;
    private final AtomicLong marker;
    private static final String TOKEN_PREFIX = "INV_TOK:";

    @Inject
    public DefaultInvalidationService(HttpCache httpCache, CacheProvider cacheProvider) {
        this(httpCache, cacheProvider, new AtomicLong(System.currentTimeMillis()));
    }

    DefaultInvalidationService(HttpCache httpCache, CacheProvider cacheProvider, AtomicLong marker) {
        this.httpCache = httpCache;
        this.invalidationEntries = cacheProvider.createCache(CACHE_NAME);
        this.marker = marker;
    }

    @Override
    public void invalidateApplicationResources(Set<Uri> uris, SecurityToken token) {
        for (Uri uri : uris) {
            this.httpCache.removeResponse(new HttpRequest(uri));
        }
    }

    @Override
    public void invalidateUserResources(Set<String> opensocialIds, SecurityToken token) {
        for (String userId : opensocialIds) {
            this.invalidationEntries.addElement(this.getKey(userId, token), this.marker.incrementAndGet());
        }
    }

    @Override
    public boolean isValid(HttpRequest request, HttpResponse response) {
        if (request.getAuthType() == AuthType.NONE) {
            return true;
        }
        String invalidationHeader = response.getHeader("X-Shindig-Invalidation");
        if (invalidationHeader == null) {
            invalidationHeader = "";
        }
        return invalidationHeader.equals(this.getInvalidationMark(request));
    }

    @Override
    public HttpResponse markResponse(HttpRequest request, HttpResponse response) {
        if (request.getAuthType() == AuthType.NONE) {
            return response;
        }
        String mark = this.getInvalidationMark(request);
        if (mark.length() > 0) {
            return new HttpResponseBuilder(response).setHeader("X-Shindig-Invalidation", mark).create();
        }
        return response;
    }

    private String getKey(String userId, SecurityToken token) {
        int colonIndex = userId.lastIndexOf(58);
        if (colonIndex != -1) {
            userId = userId.substring(colonIndex + 1);
        }
        if (!StringUtils.isEmpty((String)token.getAppId())) {
            return TOKEN_PREFIX + token.getAppId() + ':' + userId;
        }
        return TOKEN_PREFIX + token.getAppUrl() + ':' + userId;
    }

    private String getInvalidationMark(HttpRequest request) {
        StringBuilder currentInvalidation = new StringBuilder();
        Long ownerStamp = null;
        if (request.getOAuthArguments().getSignOwner()) {
            String ownerKey = this.getKey(request.getSecurityToken().getOwnerId(), request.getSecurityToken());
            ownerStamp = this.invalidationEntries.getElement(ownerKey);
        }
        Long viewerStamp = null;
        if (request.getOAuthArguments().getSignViewer()) {
            if (ownerStamp != null && request.getSecurityToken().getOwnerId().equals(request.getSecurityToken().getViewerId())) {
                viewerStamp = ownerStamp;
            } else {
                String viewerKey = this.getKey(request.getSecurityToken().getViewerId(), request.getSecurityToken());
                viewerStamp = this.invalidationEntries.getElement(viewerKey);
            }
        }
        if (ownerStamp != null) {
            currentInvalidation.append("o=").append(ownerStamp).append(';');
        }
        if (viewerStamp != null) {
            currentInvalidation.append("v=").append(viewerStamp).append(';');
        }
        return currentInvalidation.toString();
    }
}

