/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.stub.types.bean.Gadget;
import org.wso2.carbon.dashboard.stub.types.bean.Tab;
import org.wso2.carbon.dashboard.ui.DashboardServiceClient;
import org.wso2.carbon.dashboard.ui.DashboardUiContext;
import org.wso2.carbon.dashboard.ui.DashboardUiException;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class DashboardUiUtils {
    private static Log log = LogFactory.getLog(DashboardUiUtils.class);
    public static final String EMPTY_STRING = "";
    public static StringBuffer currentContext = new StringBuffer();

    public static String getHttpServerRoot(String backendUrl, String backendHttpPort) {
        String response = EMPTY_STRING;
        try {
            String hostName = CarbonUtils.getServerConfiguration().getFirstProperty("HostName");
            backendHttpPort = DashboardUiUtils.getBackendPort("http");
            response = backendUrl.split("/carbon/")[0];
            URL newUrl = new URL(response);
            response = EMPTY_STRING.equals(newUrl.getPath()) ? "http://" + newUrl.getHost() + ":" + backendHttpPort : "http://" + newUrl.getHost() + ":" + backendHttpPort + newUrl.getPath();
            if (hostName != null && !hostName.equals(EMPTY_STRING)) {
                response = "http://" + hostName + ":" + backendHttpPort;
            } else if (hostName != null && !hostName.equals(EMPTY_STRING) && !EMPTY_STRING.equals(newUrl.getPath())) {
                response = "http://" + hostName + ":" + backendHttpPort + newUrl.getPath();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return response;
    }

    public static String[] sanitizeUrls(String[] gadgetUrls, String backendUrl, String backendHttpPort) {
        String[] response = new String[]{};
        if (gadgetUrls != null) {
            ArrayList<String> tempUrlHolder = new ArrayList<String>();
            for (int x = 0; x < gadgetUrls.length; ++x) {
                String currentUrl = gadgetUrls[x];
                if ("/".equals(String.valueOf(currentUrl.charAt(0)))) {
                    currentUrl = DashboardUiUtils.getHttpServerRoot(backendUrl, backendHttpPort) + currentUrl;
                }
                tempUrlHolder.add(currentUrl);
            }
            response = new String[tempUrlHolder.size()];
            tempUrlHolder.toArray(response);
        }
        return response;
    }

    public static String getHttpsServerRoot(String backendUrl) {
        String response = EMPTY_STRING;
        response = backendUrl.split("/services/")[0];
        return response;
    }

    public static String getAdminConsoleURL(HttpServletRequest request) {
        if (request.getContextPath().equals("/carbon") || request.getContextPath().equals("//carbon")) {
            return CarbonUIUtil.getAdminConsoleURL((String)"/");
        }
        return CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
    }

    public static String getAdminConsoleURL(String context, String tdomain) {
        if (context.equals("/")) {
            context = EMPTY_STRING;
        }
        return CarbonUIUtil.getAdminConsoleURL((String)("/t/" + tdomain + context));
    }

    public static String getContextWithTenantDomain(String context, String tdomain) {
        if (context.equals("/")) {
            context = "/carbon";
        }
        return "/t/" + tdomain + context;
    }

    public static String getHttpsPort(String backendUrl) {
        try {
            URL newUrl = new URL(backendUrl);
            return Integer.toString(newUrl.getPort());
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public static String getPortalCss(HttpServletRequest request, ServletConfig config, DashboardServiceClient dashboardServiceClient) {
        String loggeduser = (String)request.getSession().getAttribute("logged-user");
        String tenantDomain = EMPTY_STRING;
        if (request.getSession().getAttribute("tenantDomain") != null) {
            tenantDomain = (String)request.getSession().getAttribute("tenantDomain");
        }
        String portalCSSStrippedPath = null;
        String portalCSS = "../dashboard/localstyles/gadget-server.css";
        if (loggeduser != null) {
            portalCSSStrippedPath = dashboardServiceClient.getPortalStylesUrl(loggeduser);
        }
        if (portalCSSStrippedPath != null) {
            String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)request.getSession());
            if (currentContext.toString().contains("localhost")) {
                serverURL = "https://localhost:8443/services/";
            }
            if (serverURL.split(":") == currentContext.toString().split(":")) {
                // empty if block
            }
            String serverRoot = serverURL.substring(0, serverURL.length() - "services/".length());
            if (tenantDomain != null && !EMPTY_STRING.equals(tenantDomain) && !"carbon.super".equals(tenantDomain)) {
                String themeRoot = serverRoot + "t/" + tenantDomain + "/gs/resource" + "/_system/config";
                portalCSS = themeRoot + portalCSSStrippedPath;
            } else {
                String themeRoot = serverRoot + "/gs/resource" + "/_system/config";
                portalCSS = themeRoot + portalCSSStrippedPath;
            }
        }
        return portalCSS;
    }

    public static String getLoginUrl(String toPath, String httpsPort, HttpServletRequest request) {
        String currentUrl = request.getRequestURI();
        if (currentUrl.indexOf("//carbon") > -1) {
            currentUrl = currentUrl.replace("//carbon", "/carbon");
        }
        String pathName = currentUrl + "/" + "../" + toPath;
        String tenantdomainFromReq = (String)request.getAttribute("tenantDomain");
        if (tenantdomainFromReq != null) {
            pathName = "/t/" + tenantdomainFromReq + pathName;
        }
        String retUrl = "https://" + request.getServerName() + ':' + httpsPort + pathName;
        return retUrl;
    }

    public static String[] getGadgetUrlsToLayout(String currentActiveTab, Tab[] tabs) {
        ArrayList<String> urls = new ArrayList<String>();
        if (tabs != null) {
            for (Tab tab : tabs) {
                Gadget[] gadgets;
                if (!tab.getTabId().equals(currentActiveTab) || (gadgets = tab.getGadgets()) == null) continue;
                for (Gadget gadget : gadgets) {
                    urls.add(gadget.getGadgetUrl());
                }
                String[] gadgetUrls = new String[urls.size()];
                return urls.toArray(gadgetUrls);
            }
        }
        return new String[0];
    }

    public static String getGadgetLayout(String currentActiveTab, Tab[] tabs) {
        if (tabs != null) {
            for (Tab tab : tabs) {
                if (!tab.getTabId().equals(currentActiveTab)) continue;
                return tab.getGadgetLayout();
            }
        }
        return EMPTY_STRING;
    }

    public static String getTabTitle(String tabId, Tab[] tabs) {
        if (tabs != null) {
            for (Tab tab : tabs) {
                if (!tab.getTabId().equals(tabId)) continue;
                return tab.getTabName();
            }
        }
        return EMPTY_STRING;
    }

    public static String getTabIdsWithTitles(Tab[] tabs) {
        StringBuilder result = new StringBuilder();
        if (tabs != null) {
            for (Tab tab : tabs) {
                result.append(tab.getTabId() + "-" + tab.getTabName().replaceAll("\n", EMPTY_STRING));
                result.append(",");
            }
            if (result.length() != 0) {
                return result.substring(0, result.length() - 1);
            }
        }
        return EMPTY_STRING;
    }

    public static String getGadgetIdsWithPrefs(String currentActiveTab, Tab[] tabs) {
        StringBuilder result = new StringBuilder();
        if (tabs != null) {
            for (Tab tab : tabs) {
                Gadget[] gadgets;
                if (!tab.getTabId().equals(currentActiveTab) || (gadgets = tab.getGadgets()) == null) continue;
                for (Gadget gadget : gadgets) {
                    result.append(gadget.getGadgetId() + "$" + gadget.getGadgetPrefs());
                    result.append("#");
                }
            }
            if (result.length() != 0) {
                return result.substring(0, result.length() - 1);
            }
        }
        return EMPTY_STRING;
    }

    public static boolean isGadgetServer() {
        return CarbonUtils.getServerConfiguration().getFirstProperty("Name").toLowerCase().replaceAll(" ", EMPTY_STRING).equals("wso2gadgetserver") || CarbonUtils.getServerConfiguration().getFirstProperty("Name").toLowerCase().replaceAll(" ", EMPTY_STRING).equals("wso2stratosgadgetserver") || CarbonUtils.getServerConfiguration().getFirstProperty("Name").toLowerCase().replaceAll(" ", EMPTY_STRING).equals("wso2businessactivitymonitor") || CarbonUtils.getServerConfiguration().getFirstProperty("Name").toLowerCase().replaceAll(" ", EMPTY_STRING).equals("wso2stratosmanager");
    }

    public static String getBackendPort(String transport) {
        try {
            int port = CarbonUtils.getTransportProxyPort((ConfigurationContext)DashboardUiContext.getConfigContext(), (String)transport);
            if (port == -1) {
                port = CarbonUtils.getTransportPort((ConfigurationContext)DashboardUiContext.getConfigContext(), (String)transport);
            }
            String backendPort = Integer.toString(port);
            return backendPort;
        }
        catch (DashboardUiException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }
}

