/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryProvider;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class MountHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ResourceImpl.class);
    private static final String EXECUTE_QUERY_CONNECTION_LIST_KEY = "execute.query.conn.key";
    private static final String CAUSED_BY_MSG = "Caused by: ";
    private String id;
    private String conURL;
    private String mountPoint;
    private String userName;
    private String password;
    private String subPath;
    private String author;
    private String dbConfig;
    private boolean readOnly;
    private boolean cacheEnabled;
    private String registryRoot;
    private boolean remote;
    private String registryType;
    private EmbeddedRegistryService registryService;
    private RegistryProvider registryProvider;
    private boolean isHandlerRegistered = false;
    private ThreadLocal<Boolean> inExecution = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private Boolean isInExecution() {
        return this.inExecution.get();
    }

    private void setInExecution(Boolean input) {
        this.inExecution.set(input);
    }

    private List<String> getQueriedConnectionList() {
        return (List)CurrentSession.getAttribute(EXECUTE_QUERY_CONNECTION_LIST_KEY);
    }

    private void setQueriedConnectionList(List<String> input) {
        CurrentSession.setAttribute(EXECUTE_QUERY_CONNECTION_LIST_KEY, input);
    }

    @Override
    public int hashCode() {
        return this.getEqualsComparator().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MountHandler && ((MountHandler)obj).getEqualsComparator().equals(this.getEqualsComparator());
    }

    private String getEqualsComparator() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("|");
        sb.append(this.id);
        sb.append("|");
        sb.append(this.conURL);
        sb.append("|");
        sb.append(this.mountPoint);
        sb.append("|");
        sb.append(this.userName);
        sb.append("|");
        sb.append(this.password);
        sb.append("|");
        sb.append(this.subPath);
        sb.append("|");
        sb.append(this.author);
        sb.append("|");
        sb.append(this.getDbConfig());
        sb.append("|");
        sb.append(this.getRegistryRoot());
        sb.append("|");
        sb.append(this.getReadOnly());
        sb.append("|");
        sb.append(this.getCacheEnabled());
        sb.append("|");
        sb.append(Boolean.toString(this.remote));
        sb.append("|");
        sb.append(this.registryType);
        return sb.toString();
    }

    private Registry getRegistry(RequestContext requestContext) throws RegistryException {
        RegistryContext baseContext = RegistryContext.getBaseInstance();
        if (!this.isHandlerRegistered && baseContext != null) {
            try {
                UserRegistry systemRegistry = new UserRegistry("wso2.system.user", CurrentSession.getTenantId(), requestContext.getRegistry(), baseContext.getRealmService(), baseContext.getRegistryRoot());
                if (this.subPath != null) {
                    RegistryUtils.addMountEntry((Registry)systemRegistry, RegistryContext.getBaseInstance(), this.mountPoint, this.id, this.subPath, this.author);
                } else {
                    RegistryUtils.addMountEntry((Registry)systemRegistry, RegistryContext.getBaseInstance(), this.mountPoint, this.id, true, this.author);
                }
                this.isHandlerRegistered = true;
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to add mount entry into Registry", (Throwable)((Object)e));
            }
        }
        if (this.remote) {
            BundleContext bundleContext;
            if (this.registryProvider == null && this.registryType != null && (bundleContext = RegistryCoreServiceComponent.getBundleContext()) != null) {
                ServiceTracker tracker = new ServiceTracker(bundleContext, RegistryProvider.class.getName(), null);
                tracker.open();
                ServiceReference[] references = tracker.getServiceReferences();
                if (references != null) {
                    for (ServiceReference reference : references) {
                        if (!this.registryType.equals(reference.getProperty("type"))) continue;
                        this.registryProvider = (RegistryProvider)tracker.getService(reference);
                        break;
                    }
                }
                tracker.close();
            }
            if (this.registryProvider != null) {
                return this.registryProvider.getRegistry(this.conURL, this.userName, this.password);
            }
            RegistryUtils.setTrustStoreSystemProperties();
            try {
                if (baseContext != null) {
                    RemoteRegistry registry = new RemoteRegistry(this.conURL, this.userName, this.password){

                        @Override
                        public RegistryContext getRegistryContext() {
                            RegistryContext context = RegistryContext.getCloneContext();
                            context.setReadOnly(MountHandler.this.readOnly);
                            context.setCacheEnabled(MountHandler.this.cacheEnabled);
                            return context;
                        }
                    };
                    return new UserRegistry(this.userName, CurrentSession.getTenantId(), registry, baseContext.getRealmService(), baseContext.getRegistryRoot());
                }
                return new RemoteRegistry(this.conURL, this.userName, this.password);
            }
            catch (MalformedURLException e) {
                String msg = "Unable to connect to the remote registry";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
        }
        if (this.registryService == null) {
            RegistryContext context = RegistryContext.getCloneContext();
            context.setRegistryRoot(this.registryRoot);
            context.setReadOnly(this.readOnly);
            context.setCacheEnabled(this.cacheEnabled);
            context.selectDBConfig(this.dbConfig);
            this.registryService = context.getEmbeddedRegistryService();
        }
        return this.registryService.getUserRegistry(CurrentSession.getUser(), CurrentSession.getCallerTenantId());
    }

    private void beginNestedOperation(String remotePath, String localPath) {
        if (!this.remote) {
            HashMap<String, String> localPathMap = new HashMap<String, String>();
            localPathMap.put(remotePath, localPath);
            CurrentSession.setLocalPathMap(localPathMap);
            Transaction.pushTransaction();
        }
    }

    private void beginNestedOperation(Map<String, String> localPathMap) {
        if (!this.remote) {
            CurrentSession.setLocalPathMap(localPathMap);
            Transaction.pushTransaction();
        }
    }

    private void endNestedOperation() {
        if (!this.remote) {
            Transaction.popTransaction();
            CurrentSession.removeLocalPathMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.put(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            Resource resource = requestContext.getResource();
            resource.removeProperty("registry.link");
            resource.removeProperty("registry.user");
            resource.removeProperty("registry.mount");
            resource.removeProperty("registry.author");
            resource.removeProperty("registry.realpath");
            if ("application/x-xsd+xml".equals(resource.getMediaType()) || "application/wsdl+xml".equals(resource.getMediaType())) {
                resource.addProperty("registry.remotemount.operation", "true");
            }
            ((ResourceImpl)resource).setPath(actualPath);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                remoteRegistry.put(actualPath, resource);
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            throw new RegistryException("Unable to put resource", e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    @Override
    public boolean resourceExists(RequestContext requestContext) throws RegistryException {
        return this.resourceExists(requestContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourceExists(RequestContext requestContext, boolean verify) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            return super.resourceExists(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        boolean resourceExists = false;
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                Resource resource;
                resourceExists = remoteRegistry.resourceExists(actualPath);
                if (verify && resourceExists && (resource = remoteRegistry.get(actualPath)).getProperty("registry.linkrestoration") != null) {
                    resourceExists = false;
                }
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            log.error((Object)"Unable to test existence of resource", (Throwable)e);
        }
        this.setInExecution(false);
        return resourceExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegistryContext getRegistryContext(RequestContext requestContext) {
        RegistryContext registryContext;
        if (this.isInExecution().booleanValue()) {
            return super.getRegistryContext(requestContext);
        }
        this.setInExecution(true);
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(new HashMap<String, String>());
            try {
                registryContext = remoteRegistry.getRegistryContext();
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the remote registry instance", (Throwable)e);
            return null;
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return registryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        Resource tempResource;
        String actualPath;
        block29: {
            if (this.isInExecution().booleanValue()) {
                return super.get(requestContext);
            }
            this.setInExecution(true);
            String fullPath = requestContext.getResourcePath().getPath();
            actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
            if (this.subPath != null) {
                actualPath = this.subPath + actualPath;
            }
            if (actualPath.length() == 0) {
                actualPath = "/";
            }
            try {
                Registry remoteRegistry = this.getRegistry(requestContext);
                this.beginNestedOperation(actualPath, fullPath);
                boolean resourceExists = false;
                try {
                    resourceExists = remoteRegistry.resourceExists(actualPath);
                }
                finally {
                    this.endNestedOperation();
                }
                if (resourceExists) {
                    this.beginNestedOperation(actualPath, fullPath);
                    try {
                        tempResource = remoteRegistry.get(actualPath);
                        if (!this.remote) {
                            tempResource.getContent();
                        }
                    }
                    finally {
                        this.endNestedOperation();
                    }
                    if (tempResource instanceof Collection) {
                        String[] paths = (String[])tempResource.getContent();
                        HashSet<String> nonLinkPaths = new HashSet<String>();
                        try {
                            this.setInExecution(false);
                            if (paths != null) {
                                for (int i = 0; i < paths.length; ++i) {
                                    paths[i] = this.subPath != null && this.subPath.length() != 0 ? this.mountPoint + paths[i].substring(this.subPath.length()) : this.mountPoint + paths[i];
                                    RequestContext childContext = new RequestContext(requestContext.getRegistry(), requestContext.getRepository(), requestContext.getVersionRepository());
                                    childContext.setResourcePath(new ResourcePath(paths[i]));
                                    if (!this.resourceExists(childContext, false)) continue;
                                    nonLinkPaths.add(paths[i]);
                                }
                            }
                        }
                        finally {
                            this.setInExecution(true);
                        }
                        ((ResourceImpl)tempResource).setContentWithNoUpdate(nonLinkPaths.toArray(new String[nonLinkPaths.size()]));
                    }
                    ((ResourceImpl)tempResource).setPath(fullPath);
                    ((ResourceImpl)tempResource).setAuthorUserName(this.author);
                    ((ResourceImpl)tempResource).setUserName(CurrentSession.getUser());
                    ((ResourceImpl)tempResource).setTenantId(CurrentSession.getCallerTenantId());
                    break block29;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Could not mount remote instance " + this.conURL + ". Resource doesn't exist at " + actualPath + "."));
                }
                this.setInExecution(false);
                throw new ResourceNotFoundException(fullPath);
            }
            catch (ResourceNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                log.debug((Object)("Could not mount remote instance " + this.conURL + " " + e.getMessage()));
                throw new ResourceNotFoundException(fullPath, e);
            }
            finally {
                this.setInExecution(false);
            }
        }
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.link", "true");
        ((ResourceImpl)tempResource).removePropertyWithNoUpdate("registry.nonrecursive");
        ((ResourceImpl)tempResource).removePropertyWithNoUpdate("registry.linkrestoration");
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.mount", "true");
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.author", this.author);
        if (this.remote) {
            ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.user", this.userName);
        } else {
            ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.user", CurrentSession.getUser());
        }
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.realpath", this.conURL + "/resourceContent?path=" + actualPath);
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return tempResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.delete(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (fullPath.equals(this.mountPoint)) {
            requestContext.getRegistry().removeLink(requestContext.getResource().getPath());
            if (registryContext != null) {
                HandlerManager hm = registryContext.getHandlerManager();
                hm.removeHandler(this, "tenant");
            }
        } else {
            String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
            if (this.subPath != null) {
                actualPath = this.subPath + actualPath;
            }
            if (actualPath.length() == 0) {
                actualPath = "/";
            }
            try {
                Registry remoteRegistry = this.getRegistry(requestContext);
                this.beginNestedOperation(actualPath, fullPath);
                try {
                    remoteRegistry.delete(actualPath);
                }
                finally {
                    this.endNestedOperation();
                }
            }
            catch (Exception e) {
                String msg = "Could not delete the remote resource.";
                log.error((Object)msg);
                this.setInExecution(false);
                throw new RegistryException(msg, e);
            }
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComment(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.removeComment(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getCompletePath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                remoteRegistry.removeComment(actualPath);
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            String msg = "Could not remove comment from the remote resource.";
            log.error((Object)msg);
            this.setInExecution(false);
            throw new RegistryException(msg, e);
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTag(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.removeTag(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getCompletePath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                remoteRegistry.removeTag(actualPath, requestContext.getTag());
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            String msg = "Could not remove tag from the remote resource.";
            log.error((Object)msg);
            this.setInExecution(false);
            throw new RegistryException(msg, e);
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rename(RequestContext requestContext) throws RegistryException {
        String newPath;
        if (this.isInExecution().booleanValue()) {
            return super.rename(requestContext);
        }
        this.setInExecution(true);
        String fullResourcePath = requestContext.getSourcePath();
        String fullTargetPath = requestContext.getTargetPath();
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (fullResourcePath.equals(this.mountPoint)) {
            newPath = requestContext.getRepository().rename(new ResourcePath(fullResourcePath), fullTargetPath);
            requestContext.getRegistry().createLink(fullTargetPath, this.id);
            requestContext.getRegistry().removeLink(this.mountPoint);
            if (registryContext != null) {
                HandlerManager hm = registryContext.getHandlerManager();
                hm.removeHandler(this, "tenant");
            }
        } else {
            String actualResourcePath = fullResourcePath.substring(this.mountPoint.length(), fullResourcePath.length());
            String actualTargetPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
            if (this.subPath != null) {
                actualResourcePath = this.subPath + actualResourcePath;
                actualTargetPath = this.subPath + actualTargetPath;
            }
            if (actualResourcePath.length() == 0) {
                actualResourcePath = "/";
            }
            if (actualTargetPath.length() == 0) {
                actualTargetPath = "/";
            }
            try {
                Registry remoteRegistry = this.getRegistry(requestContext);
                HashMap<String, String> pathMap = new HashMap<String, String>();
                pathMap.put(actualResourcePath, fullResourcePath);
                pathMap.put(actualTargetPath, fullTargetPath);
                this.beginNestedOperation(pathMap);
                try {
                    newPath = remoteRegistry.rename(actualResourcePath, actualTargetPath);
                }
                finally {
                    this.endNestedOperation();
                }
            }
            catch (Exception e) {
                String msg = "Could not rename the remote resource.";
                log.error((Object)msg);
                this.setInExecution(false);
                throw new RegistryException(msg, e);
            }
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return newPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String move(RequestContext requestContext) throws RegistryException {
        String fullTargetPath;
        block22: {
            if (this.isInExecution().booleanValue()) {
                return super.move(requestContext);
            }
            this.setInExecution(true);
            String fullResourcePath = requestContext.getSourcePath();
            fullTargetPath = requestContext.getTargetPath();
            RegistryContext registryContext = requestContext.getRegistryContext();
            try {
                if (fullResourcePath.equals(this.mountPoint)) {
                    requestContext.getRepository().move(new ResourcePath(fullResourcePath), fullTargetPath);
                    requestContext.getRegistry().createLink(fullTargetPath, this.id);
                    requestContext.getRegistry().removeLink(this.mountPoint);
                    if (registryContext != null) {
                        HandlerManager hm = registryContext.getHandlerManager();
                        hm.removeHandler(this, "tenant");
                    }
                    break block22;
                }
                if (fullResourcePath.startsWith(this.mountPoint)) {
                    String actualResourcePath = fullResourcePath.substring(this.mountPoint.length(), fullResourcePath.length());
                    if (this.subPath != null) {
                        actualResourcePath = this.subPath + actualResourcePath;
                    }
                    Registry remoteRegistry = this.getRegistry(requestContext);
                    if (fullTargetPath.startsWith(this.mountPoint)) {
                        String actualTargetPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
                        if (this.subPath != null) {
                            actualTargetPath = this.subPath + actualTargetPath;
                        }
                        HashMap<String, String> pathMap = new HashMap<String, String>();
                        pathMap.put(actualResourcePath, fullResourcePath);
                        pathMap.put(actualTargetPath, fullTargetPath);
                        this.beginNestedOperation(pathMap);
                        try {
                            remoteRegistry.move(actualResourcePath, actualTargetPath);
                            break block22;
                        }
                        finally {
                            this.endNestedOperation();
                        }
                    }
                    String actualTargetPath = fullTargetPath;
                    HashMap<String, String> pathMap = new HashMap<String, String>();
                    pathMap.put(actualResourcePath, fullResourcePath);
                    pathMap.put(actualTargetPath, fullTargetPath);
                    StringWriter out = new StringWriter();
                    this.beginNestedOperation(pathMap);
                    try {
                        remoteRegistry.dump(actualResourcePath, out);
                    }
                    finally {
                        this.endNestedOperation();
                    }
                    StringReader input = new StringReader(out.toString());
                    requestContext.getRegistry().restore(actualTargetPath, input);
                    this.beginNestedOperation(pathMap);
                    try {
                        remoteRegistry.delete(actualResourcePath);
                        break block22;
                    }
                    finally {
                        this.endNestedOperation();
                    }
                }
                if (!fullTargetPath.contains(this.mountPoint)) break block22;
                String actualTargetPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
                if (this.subPath != null) {
                    actualTargetPath = this.subPath + actualTargetPath;
                }
                Registry remoteRegistry = this.getRegistry(requestContext);
                String actualResourcePath = fullResourcePath;
                StringWriter out = new StringWriter();
                requestContext.getRegistry().dump(actualResourcePath, out);
                StringReader input = new StringReader(out.toString());
                HashMap<String, String> pathMap = new HashMap<String, String>();
                pathMap.put(actualResourcePath, fullResourcePath);
                pathMap.put(actualTargetPath, fullTargetPath);
                this.beginNestedOperation(pathMap);
                try {
                    remoteRegistry.restore(actualTargetPath, input);
                }
                finally {
                    this.endNestedOperation();
                }
                requestContext.getRegistry().delete(actualResourcePath);
            }
            catch (RuntimeException e) {
                String msg = "Could not move the remote resource " + fullResourcePath + ".";
                log.error((Object)msg);
                this.setInExecution(false);
                throw new RegistryException(msg, e);
            }
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return fullTargetPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String copy(RequestContext requestContext) throws RegistryException {
        String fullTargetPath;
        block18: {
            if (this.isInExecution().booleanValue()) {
                return super.copy(requestContext);
            }
            this.setInExecution(true);
            String fullResourcePath = requestContext.getSourcePath();
            fullTargetPath = requestContext.getTargetPath();
            try {
                if (fullResourcePath.equals(this.mountPoint)) {
                    requestContext.getRegistry().createLink(fullTargetPath, this.id);
                    break block18;
                }
                if (fullResourcePath.startsWith(this.mountPoint)) {
                    String actualResourcePath = fullResourcePath.substring(this.mountPoint.length(), fullResourcePath.length());
                    if (this.subPath != null) {
                        actualResourcePath = this.subPath + actualResourcePath;
                    }
                    Registry remoteRegistry = this.getRegistry(requestContext);
                    if (fullTargetPath.startsWith(this.mountPoint)) {
                        String actualTargetPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
                        if (this.subPath != null) {
                            actualTargetPath = this.subPath + actualTargetPath;
                        }
                        HashMap<String, String> pathMap = new HashMap<String, String>();
                        pathMap.put(actualResourcePath, fullResourcePath);
                        pathMap.put(actualTargetPath, fullTargetPath);
                        this.beginNestedOperation(pathMap);
                        try {
                            remoteRegistry.copy(actualResourcePath, actualTargetPath);
                            break block18;
                        }
                        finally {
                            this.endNestedOperation();
                        }
                    }
                    String actualTargetPath = fullTargetPath;
                    StringWriter out = new StringWriter();
                    HashMap<String, String> pathMap = new HashMap<String, String>();
                    pathMap.put(actualResourcePath, fullResourcePath);
                    pathMap.put(actualTargetPath, fullTargetPath);
                    this.beginNestedOperation(pathMap);
                    try {
                        remoteRegistry.dump(actualResourcePath, out);
                    }
                    finally {
                        this.endNestedOperation();
                    }
                    StringReader input = new StringReader(out.toString());
                    requestContext.getRegistry().restore(actualTargetPath, input);
                    break block18;
                }
                if (!fullTargetPath.contains(this.mountPoint)) break block18;
                String actualTargetPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
                if (this.subPath != null) {
                    actualTargetPath = this.subPath + actualTargetPath;
                }
                Registry remoteRegistry = this.getRegistry(requestContext);
                String actualResourcePath = fullResourcePath;
                StringWriter out = new StringWriter();
                requestContext.getRegistry().dump(actualResourcePath, out);
                StringReader input = new StringReader(out.toString());
                HashMap<String, String> pathMap = new HashMap<String, String>();
                pathMap.put(actualResourcePath, fullResourcePath);
                pathMap.put(actualTargetPath, fullTargetPath);
                this.beginNestedOperation(pathMap);
                try {
                    remoteRegistry.restore(actualTargetPath, input);
                }
                finally {
                    this.endNestedOperation();
                }
            }
            catch (RuntimeException e) {
                String msg = "Could not copy the remote resource " + fullResourcePath + ".";
                log.error((Object)msg);
                this.setInExecution(false);
                throw new RegistryException(msg, e);
            }
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return fullTargetPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAverageRating(RequestContext requestContext) throws RegistryException {
        float rating;
        if (this.isInExecution().booleanValue()) {
            return super.getAverageRating(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                rating = remoteRegistry.getAverageRating(actualPath);
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not get average ratings from" + this.conURL));
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
            this.setInExecution(false);
            return 0.0f;
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return rating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRating(RequestContext requestContext) throws RegistryException {
        int rating;
        block10: {
            if (this.isInExecution().booleanValue()) {
                return super.getRating(requestContext);
            }
            this.setInExecution(true);
            String fullPath = requestContext.getResourcePath().getPath();
            String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
            if (this.subPath != null) {
                actualPath = this.subPath + actualPath;
            }
            if (actualPath.length() == 0) {
                actualPath = "/";
            }
            try {
                Registry remoteRegistry = this.getRegistry(requestContext);
                if (this.remote) {
                    rating = remoteRegistry.getRating(actualPath, this.userName);
                    break block10;
                }
                this.beginNestedOperation(actualPath, fullPath);
                try {
                    rating = remoteRegistry.getRating(actualPath, CurrentSession.getUser());
                }
                finally {
                    this.endNestedOperation();
                }
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not get ratings from " + this.conURL));
                }
                log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
                this.setInExecution(false);
                return 0;
            }
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return rating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rateResource(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.rateResource(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        if (this.remote) {
            CurrentSession.setUser(this.userName);
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                remoteRegistry.rateResource(actualPath, requestContext.getRating());
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            throw new RegistryException("Unable to rate resource", e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment[] getComments(RequestContext requestContext) throws RegistryException {
        Comment[] comments;
        if (this.isInExecution().booleanValue()) {
            return super.getComments(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                comments = remoteRegistry.getComments(actualPath);
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not get comments from" + this.conURL));
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
            this.setInExecution(false);
            return new Comment[1];
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addComment(RequestContext requestContext) throws RegistryException {
        String commentPath;
        if (this.isInExecution().booleanValue()) {
            return super.addComment(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                commentPath = remoteRegistry.addComment(actualPath, requestContext.getComment());
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            String msg = "Could not add comment to the resource in " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            this.setInExecution(false);
            throw new RegistryException(msg, e);
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return commentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag[] getTags(RequestContext requestContext) throws RegistryException {
        Tag[] tags;
        if (this.isInExecution().booleanValue()) {
            return super.getTags(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                tags = remoteRegistry.getTags(actualPath);
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not get tags from" + this.conURL));
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
            this.setInExecution(false);
            return new Tag[1];
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTag(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.applyTag(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                remoteRegistry.applyTag(actualPath, requestContext.getTag());
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            String msg = "Could not apply tag to the resource in " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            throw new RegistryException(msg, e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaggedResourcePath[] getResourcePathsWithTag(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            return super.getResourcePathsWithTag(requestContext);
        }
        this.setInExecution(true);
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(null);
            try {
                TaggedResourcePath[] result = remoteRegistry.getResourcePathsWithTag(requestContext.getTag());
                if (result != null) {
                    for (TaggedResourcePath taggedResourcePath : result) {
                        String path = taggedResourcePath.getResourcePath();
                        if (this.subPath != null && this.subPath.length() != 0 && path.startsWith(this.subPath)) {
                            path = this.mountPoint + path.substring(this.subPath.length());
                        }
                        taggedResourcePath.setResourcePath(path);
                    }
                }
                TaggedResourcePath[] taggedResourcePathArray = result;
                this.endNestedOperation();
                return taggedResourcePathArray;
            }
            catch (Throwable throwable) {
                try {
                    this.endNestedOperation();
                    throw throwable;
                }
                catch (Exception e) {
                    String msg = "Could not get resource paths with tag in " + this.conURL;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)msg);
                    }
                    throw new RegistryException(msg, e);
                }
            }
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection executeQuery(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            return super.executeQuery(requestContext);
        }
        this.setInExecution(true);
        Collection collection = null;
        Resource query = requestContext.getResource();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(requestContext.getQueryParameters());
        if (query != null) {
            paramMap.put("query", query.getContent());
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(null);
            try {
                boolean connectionExists = false;
                List<String> conList = this.getQueriedConnectionList();
                if (conList == null) {
                    conList = new LinkedList<String>();
                }
                for (String con : conList) {
                    if (this.id == null || this.mountPoint == null || !(this.id + this.mountPoint).equals(con)) continue;
                    connectionExists = true;
                    break;
                }
                if (!connectionExists) {
                    conList.add(this.id + this.mountPoint);
                    this.setQueriedConnectionList(conList);
                    collection = remoteRegistry.executeQuery(null, paramMap);
                }
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            String msg = "Could not execute query in remote mount at " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            throw new RegistryException(msg, e);
        }
        finally {
            this.setInExecution(false);
        }
        LinkedList<String> results = new LinkedList<String>();
        if (collection != null) {
            String[] children = collection.getChildren();
            if (children != null) {
                for (String child : children) {
                    if (child == null) continue;
                    if (this.subPath != null && this.subPath.length() != 0 && child.startsWith(this.subPath)) {
                        child = this.mountPoint + child.substring(this.subPath.length());
                    }
                    results.add(child);
                }
            }
            collection.setContent(results.toArray(new String[results.size()]));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAllAssociations(RequestContext requestContext) throws RegistryException {
        Association[] associations;
        if (this.isInExecution().booleanValue()) {
            return super.getAllAssociations(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                associations = remoteRegistry.getAllAssociations(actualPath);
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            String msg = "Could not get associations of " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
            this.setInExecution(false);
            return new Association[1];
        }
        for (Association association : associations) {
            String sourcePath = association.getSourcePath();
            String destinationPath = association.getDestinationPath();
            if (this.subPath != null && this.subPath.length() != 0) {
                association.setSourcePath(this.mountPoint + sourcePath.substring(this.subPath.length()));
                if (!destinationPath.startsWith(this.subPath)) continue;
                association.setDestinationPath(this.mountPoint + destinationPath.substring(this.subPath.length()));
                continue;
            }
            association.setSourcePath(this.mountPoint + sourcePath);
            association.setDestinationPath(destinationPath);
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return associations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAssociations(RequestContext requestContext) throws RegistryException {
        Association[] associations;
        if (this.isInExecution().booleanValue()) {
            return super.getAssociations(requestContext);
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                associations = remoteRegistry.getAssociations(actualPath, requestContext.getAssociationType());
            }
            finally {
                this.endNestedOperation();
            }
        }
        catch (Exception e) {
            String msg = "Could not get associations of " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
            this.setInExecution(false);
            return new Association[1];
        }
        for (Association association : associations) {
            String sourcePath = association.getSourcePath();
            String destinationPath = association.getDestinationPath();
            if (this.subPath != null && this.subPath.length() != 0) {
                association.setSourcePath(this.mountPoint + sourcePath.substring(this.subPath.length()));
                if (!destinationPath.startsWith(this.subPath)) continue;
                association.setDestinationPath(this.mountPoint + destinationPath.substring(this.subPath.length()));
                continue;
            }
            association.setSourcePath(this.mountPoint + sourcePath);
            association.setDestinationPath(destinationPath);
        }
        requestContext.setProcessingComplete(true);
        this.setInExecution(false);
        return associations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAssociation(RequestContext requestContext) throws RegistryException {
        String fullTargetPath;
        if (this.isInExecution().booleanValue()) {
            super.addAssociation(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getSourcePath();
        String targetPath = fullTargetPath = requestContext.getTargetPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (targetPath.startsWith(this.mountPoint)) {
            targetPath = targetPath.substring(this.mountPoint.length());
            if (this.subPath != null) {
                targetPath = this.subPath + targetPath;
            }
        }
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath != null && actualPath.length() == 0) {
            actualPath = "/";
        }
        if (targetPath != null && targetPath.length() == 0) {
            targetPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            HashMap<String, String> pathMap = new HashMap<String, String>();
            pathMap.put(actualPath, fullPath);
            pathMap.put(targetPath, fullTargetPath);
            this.beginNestedOperation(pathMap);
            try {
                remoteRegistry.addAssociation(actualPath, targetPath, requestContext.getAssociationType());
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            String msg = "Could not add associations for " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        String fullTargetPath;
        if (this.isInExecution().booleanValue()) {
            super.removeAssociation(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getSourcePath();
        String targetPath = fullTargetPath = requestContext.getTargetPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (targetPath.startsWith(this.mountPoint)) {
            targetPath = targetPath.substring(this.mountPoint.length());
            if (this.subPath != null) {
                targetPath = this.subPath + targetPath;
            }
        }
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath != null && actualPath.length() == 0) {
            actualPath = "/";
        }
        if (targetPath != null && targetPath.length() == 0) {
            targetPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            HashMap<String, String> pathMap = new HashMap<String, String>();
            pathMap.put(actualPath, fullPath);
            pathMap.put(targetPath, fullTargetPath);
            this.beginNestedOperation(pathMap);
            try {
                remoteRegistry.removeAssociation(actualPath, targetPath, requestContext.getAssociationType());
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            String msg = "Could not remove associations for " + this.conURL;
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
        }
        finally {
            this.setInExecution(false);
        }
        this.setInExecution(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.importResource(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                remoteRegistry.importResource(actualPath, requestContext.getSourceURL(), requestContext.getResource());
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            String msg = "Could not import resource from " + requestContext.getSourceURL();
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            log.debug((Object)CAUSED_BY_MSG, (Throwable)e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.dump(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                MonitoredWriter monitoredWriter = new MonitoredWriter(requestContext.getDumpingWriter());
                try {
                    remoteRegistry.dump(actualPath, monitoredWriter);
                }
                finally {
                    requestContext.setBytesWritten(monitoredWriter.getTotalWritten());
                }
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            throw new RegistryException("Unable to dump content", e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.restore(requestContext);
            return;
        }
        this.setInExecution(true);
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        if (this.subPath != null) {
            actualPath = this.subPath + actualPath;
        }
        if (actualPath.length() == 0) {
            actualPath = "/";
        }
        try {
            Registry remoteRegistry = this.getRegistry(requestContext);
            this.beginNestedOperation(actualPath, fullPath);
            try {
                MonitoredReader monitoredReader = new MonitoredReader(requestContext.getDumpingReader());
                try {
                    remoteRegistry.restore(actualPath, monitoredReader);
                }
                finally {
                    requestContext.setBytesRead(monitoredReader.getTotalRead());
                }
            }
            finally {
                this.endNestedOperation();
            }
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            throw new RegistryException("Unable to restore content", e);
        }
        finally {
            this.setInExecution(false);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConURL(String conURL) {
        if (conURL.endsWith("/")) {
            this.conURL = conURL.substring(0, conURL.lastIndexOf("/") - 1);
        }
        this.conURL = conURL;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public void setUserName(String username) {
        this.userName = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath.equals("/") ? "" : (subPath.length() > 1 && subPath.charAt(subPath.length() - 1) == "/".charAt(0) ? subPath.substring(0, subPath.length() - 1) : subPath);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public String getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(String dbConfig) {
        this.dbConfig = dbConfig;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean getCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getRegistryRoot() {
        return this.registryRoot;
    }

    public void setRegistryRoot(String registryRoot) {
        this.registryRoot = registryRoot;
    }

    private static class MonitoredReader
    extends Reader {
        private Reader reader;
        private long totalRead;

        public MonitoredReader(Reader reader) {
            this.reader = reader;
            this.totalRead = 0L;
        }

        @Override
        public int read(char[] chars, int off, int len) throws IOException {
            int read = this.reader.read(chars, off, len);
            this.totalRead += (long)read;
            return read;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        public long getTotalRead() {
            return this.totalRead;
        }
    }

    private static class MonitoredWriter
    extends Writer {
        private Writer writer;
        private long totalWritten;

        public MonitoredWriter(Writer writer) {
            this.writer = writer;
            this.totalWritten = 0L;
        }

        @Override
        public void write(char[] chars, int off, int len) throws IOException {
            this.totalWritten += (long)(len - off);
            this.writer.write(chars, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        public long getTotalWritten() {
            return this.totalWritten;
        }
    }
}

