/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.dataaccess.DatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.statistics.StatisticsLog;
import org.wso2.carbon.registry.core.statistics.query.DBQueryStatisticsLog;
import org.wso2.carbon.registry.core.statistics.query.StatisticsRecord;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class JDBCDatabaseTransaction
implements DatabaseTransaction {
    private static final Log log = LogFactory.getLog(Transaction.class);
    private static final Log statsLog = StatisticsLog.getLog();
    private static final Log dbQueryLog = DBQueryStatisticsLog.getLog();
    private static ThreadLocal<TransactionEntry> tCurrent = new ThreadLocal<TransactionEntry>(){

        @Override
        protected TransactionEntry initialValue() {
            return new TransactionEntry();
        }
    };
    private static ThreadLocal<Stack<TransactionEntry>> tStackedTransactionalEntryStack = new ThreadLocal<Stack<TransactionEntry>>(){

        @Override
        protected Stack<TransactionEntry> initialValue() {
            Stack<TransactionEntry> StackedTransactionalEntryStack = new Stack<TransactionEntry>();
            StackedTransactionalEntryStack.push(null);
            return StackedTransactionalEntryStack;
        }
    };

    private static TransactionEntry getStackedTransactionalEntry() {
        Stack<TransactionEntry> transactionalEntryStack = tStackedTransactionalEntryStack.get();
        if (transactionalEntryStack == null) {
            tStackedTransactionalEntryStack.remove();
            transactionalEntryStack = tStackedTransactionalEntryStack.get();
        }
        return transactionalEntryStack.peek();
    }

    private static void setStackedTransactionalEntry(TransactionEntry StackedTransactionalEntry) {
        Stack<TransactionEntry> transactionalEntryStack = tStackedTransactionalEntryStack.get();
        if (transactionalEntryStack == null) {
            tStackedTransactionalEntryStack.remove();
            transactionalEntryStack = tStackedTransactionalEntryStack.get();
        }
        transactionalEntryStack.push(StackedTransactionalEntry);
    }

    private static void removeStackedTransactionalEntry() {
        Stack<TransactionEntry> transactionalEntryStack = tStackedTransactionalEntryStack.get();
        if (transactionalEntryStack != null) {
            transactionalEntryStack.pop();
        }
    }

    @Override
    public void pushTransaction() {
        log.trace((Object)"pushing current transaction to stack");
        JDBCDatabaseTransaction.setStackedTransactionalEntry(tCurrent.get());
        tCurrent.set(new TransactionEntry());
    }

    @Override
    public void popTransaction() {
        log.trace((Object)"popping current transaction from stack");
        TransactionEntry transactionEntry = JDBCDatabaseTransaction.getStackedTransactionalEntry();
        if (transactionEntry != null) {
            JDBCDatabaseTransaction.removeStackedTransactionalEntry();
            tCurrent.set(transactionEntry);
        }
    }

    @Override
    public boolean isStarted() {
        if (tCurrent.get() != null) {
            return tCurrent.get().isStarted();
        }
        log.error((Object)"The current transaction entry has not been created.");
        return false;
    }

    @Override
    public void setStarted(boolean started) {
        if (tCurrent.get() != null) {
            tCurrent.get().setStarted(started);
        } else {
            log.error((Object)"The current transaction entry has not been created.");
        }
    }

    public static ManagedRegistryConnection getConnection() {
        if (tCurrent.get() != null) {
            return tCurrent.get().getConnection();
        }
        log.error((Object)"The current transaction entry has not been created.");
        return null;
    }

    public static void setConnection(Connection connection) {
        if (tCurrent.get() != null) {
            if (connection != null) {
                tCurrent.get().setStarted(true);
                tCurrent.get().setConnection(new ManagedRegistryConnection(connection));
            } else {
                tCurrent.get().setConnection(null);
            }
        } else {
            log.error((Object)"The current transaction entry has not been created.");
        }
    }

    public static void removeConnection() {
        if (tCurrent.get() != null) {
            tCurrent.get().setStarted(false);
            tCurrent.get().setConnection(null);
        } else {
            log.error((Object)"The current transaction entry has not been created.");
        }
    }

    @Override
    public void incNestedDepth() {
        if (tCurrent.get() != null) {
            int transactionDepth = tCurrent.get().getNestedDepth();
            if (transactionDepth == 0) {
                tCurrent.get().setStarted(true);
                tCurrent.get().setRollbacked(false);
            }
            tCurrent.get().setNestedDepth(++transactionDepth);
        } else {
            log.error((Object)"The current transaction entry has not been created.");
        }
    }

    @Override
    public void decNestedDepth() {
        if (tCurrent.get() != null) {
            int transactionDepth = tCurrent.get().getNestedDepth();
            tCurrent.get().setNestedDepth(--transactionDepth);
            if (transactionDepth == 0) {
                tCurrent.get().setStarted(false);
            }
        } else {
            log.error((Object)"The current transaction entry has not been created.");
        }
    }

    @Override
    public int getNestedDepth() {
        if (tCurrent.get() != null) {
            return tCurrent.get().getNestedDepth();
        }
        log.error((Object)"The current transaction entry has not been created.");
        return 0;
    }

    @Override
    public boolean isRollbacked() {
        if (tCurrent.get() != null) {
            return tCurrent.get().isRollbacked();
        }
        log.error((Object)"The current transaction entry has not been created.");
        return false;
    }

    @Override
    public void setRollbacked(boolean rollbacked) {
        if (tCurrent.get() != null) {
            tCurrent.get().setRollbacked(rollbacked);
        } else {
            log.error((Object)"The current transaction entry has not been created.");
        }
    }

    public static ManagedRegistryConnection getManagedRegistryConnection(Connection conn) {
        return ManagedRegistryConnection.getManagedRegistryConnection(conn, true);
    }

    public static final class ManagedRegistryConnection
    implements Connection {
        private static final int DEFAULT_CONNECTION_CREATION_WAIT_TIME = 100;
        private Connection connection;
        private static ConnectionStatistics connectionStatistics = null;
        private static ExecutorService executor = null;
        private String uuid = UUIDGenerator.generateUUID();
        private static ThreadLocal<Map<String, ManagedRegistryConnection>> tManagedConnectionMap;
        private static ThreadLocal<Map<String, ManagedRegistryConnection>> tCommittedAndRollbackedConnectionMap;
        private static ThreadLocal<Map<String, ManagedRegistryConnection>> tClosedConnectionMap;
        private static ThreadLocal<Boolean> tRollbackedConnection;

        private static synchronized void initializeStatisticsLogging() {
            if (executor != null) {
                return;
            }
            connectionStatistics = new ConnectionStatistics();
            executor = Executors.newCachedThreadPool();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    executor.shutdownNow();
                }
            });
            final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    scheduler.shutdownNow();
                }
            });
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (connectionStatistics == null) {
                        log.error((Object)"Unable to store connection statistics.");
                    } else {
                        statsLog.debug((Object)("Total Number of Connections Created      : " + connectionStatistics.getConnectionsCreated()));
                        statsLog.debug((Object)("Total Number of Connections Closed       : " + connectionStatistics.getConnectionsClosed()));
                        statsLog.debug((Object)("Total Number of Connections Committed    : " + connectionStatistics.getConnectionsCommitted()));
                        statsLog.debug((Object)("Total Number of Connections Rollbacked   : " + connectionStatistics.getConnectionsRollbacked()));
                        statsLog.debug((Object)("Total Number of Statements Prepared      : " + connectionStatistics.getStatementsPrepared()));
                        statsLog.debug((Object)("Total Number of Statements Closed        : " + connectionStatistics.getStatementsClosed()));
                        StringBuffer sb = new StringBuffer("");
                        int count = 0;
                        try {
                            for (ConnectionCreatorStack connectionCreatorStack : connectionStatistics.getConnectionCreatorStacks()) {
                                sb.append("\nTransaction ").append(++count);
                                java.util.Date currentTime = new java.util.Date();
                                long activeFor = currentTime.getTime() - connectionCreatorStack.getCreatedTime().getTime();
                                sb.append(" (Active For ").append(activeFor).append("ms) : ");
                                int temp = 0;
                                for (StackTraceElement stackTraceElement : connectionCreatorStack.getStackTraceElements()) {
                                    if (temp++ < 3) continue;
                                    sb.append("\n\t").append(stackTraceElement.getClassName());
                                    sb.append(".").append(stackTraceElement.getMethodName());
                                    sb.append("(").append(stackTraceElement.getFileName());
                                    sb.append(":").append(stackTraceElement.getLineNumber());
                                    sb.append(")");
                                }
                            }
                        }
                        catch (Exception e) {
                            statsLog.debug((Object)"An error occurred while determining active transactions.", (Throwable)e);
                        }
                        statsLog.debug((Object)("Total Number of Active Transactions      : " + count + sb.toString()));
                    }
                }
            };
            scheduler.scheduleAtFixedRate(runnable, 60L, 60L, TimeUnit.SECONDS);
        }

        public ManagedRegistryConnection(Connection connection) {
            this.connection = connection instanceof ManagedRegistryConnection ? ((ManagedRegistryConnection)connection).getConnection() : connection;
            log.trace((Object)"Saving managed registry connection to map.");
            tManagedConnectionMap.get().put(this.getConnectionId(), this);
            if (tClosedConnectionMap.get().get(this.getConnectionId()) != null) {
                tClosedConnectionMap.get().put(this.getConnectionId(), null);
            }
            if (tCommittedAndRollbackedConnectionMap.get().get(this.getConnectionId()) != null) {
                tCommittedAndRollbackedConnectionMap.get().put(this.getConnectionId(), null);
            }
            if (statsLog.isDebugEnabled()) {
                final StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (connectionStatistics == null) {
                            log.error((Object)"Unable to store connection statistics.");
                        } else {
                            connectionStatistics.incrementConnectionsCreated();
                            connectionStatistics.setConnectionCreatorStack(ManagedRegistryConnection.this.uuid, new ConnectionCreatorStack(stackTraceElements, new java.util.Date()));
                        }
                    }
                };
                if (executor != null) {
                    executor.execute(runnable);
                } else {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                    executor.execute(runnable);
                }
            }
        }

        private String getConnectionId() {
            return RegistryUtils.getConnectionId(this.connection);
        }

        public static ManagedRegistryConnection getManagedRegistryConnection(Connection connection, boolean reinstate) {
            if (tManagedConnectionMap != null && tManagedConnectionMap.get() != null) {
                ManagedRegistryConnection mrc = tManagedConnectionMap.get().get(RegistryUtils.getConnectionId(connection));
                if (mrc != null && reinstate) {
                    if (tClosedConnectionMap != null && tClosedConnectionMap.get() != null && tClosedConnectionMap.get().get(RegistryUtils.getConnectionId(connection)) != null) {
                        tClosedConnectionMap.get().put(RegistryUtils.getConnectionId(connection), null);
                    }
                    if (tCommittedAndRollbackedConnectionMap != null && tCommittedAndRollbackedConnectionMap.get() != null && tCommittedAndRollbackedConnectionMap.get().get(RegistryUtils.getConnectionId(connection)) != null) {
                        tCommittedAndRollbackedConnectionMap.get().put(RegistryUtils.getConnectionId(connection), null);
                    }
                }
                return mrc;
            }
            return null;
        }

        private int getConnectionCount(Map<String, ManagedRegistryConnection> connections) {
            int count = 0;
            for (Map.Entry<String, ManagedRegistryConnection> e : connections.entrySet()) {
                if (e.getValue() == null) continue;
                ++count;
            }
            return count;
        }

        @Override
        public void commit() throws SQLException {
            if (statsLog.isDebugEnabled()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (connectionStatistics == null) {
                            log.error((Object)"Unable to store connection statistics.");
                        } else {
                            connectionStatistics.incrementConnectionsCommitted();
                        }
                    }
                };
                if (executor != null) {
                    executor.execute(runnable);
                } else {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                    executor.execute(runnable);
                }
            }
            if (tRollbackedConnection.get().booleanValue()) {
                log.trace((Object)"Rolling back the transaction(s).");
                this.rollback();
            } else if (tManagedConnectionMap.get().size() == 1) {
                this.connection.commit();
                log.trace((Object)"Committed all transactions.");
            } else if (tCommittedAndRollbackedConnectionMap.get().get(this.getConnectionId()) == null && tManagedConnectionMap.get().size() == this.getConnectionCount(tCommittedAndRollbackedConnectionMap.get()) + 1) {
                Map<String, ManagedRegistryConnection> connections = tCommittedAndRollbackedConnectionMap.get();
                for (Map.Entry<String, ManagedRegistryConnection> e : connections.entrySet()) {
                    if (e.getValue() == null) continue;
                    e.getValue().getConnection().commit();
                    connections.put(e.getKey(), null);
                }
                tCommittedAndRollbackedConnectionMap.set(new LinkedHashMap());
                this.connection.commit();
                log.trace((Object)"Committed all transactions.");
            } else {
                if (tManagedConnectionMap.get().size() < this.getConnectionCount(tCommittedAndRollbackedConnectionMap.get())) {
                    throw new SQLException("Total number of available connections are less than the total number of committed connections");
                }
                tCommittedAndRollbackedConnectionMap.get().put(this.getConnectionId(), this);
            }
        }

        @Override
        public void rollback() throws SQLException {
            if (statsLog.isDebugEnabled()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (connectionStatistics == null) {
                            log.error((Object)"Unable to store connection statistics.");
                        } else {
                            connectionStatistics.incrementConnectionsRollbacked();
                        }
                    }
                };
                if (executor != null) {
                    executor.execute(runnable);
                } else {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                    executor.execute(runnable);
                }
            }
            tRollbackedConnection.set(true);
            if (tManagedConnectionMap.get().size() == 1) {
                this.connection.rollback();
                tRollbackedConnection.set(false);
                log.trace((Object)"Rolled back all transactions.");
            } else if (tCommittedAndRollbackedConnectionMap.get().get(this.getConnectionId()) == null && tManagedConnectionMap.get().size() == this.getConnectionCount(tCommittedAndRollbackedConnectionMap.get()) + 1) {
                Map<String, ManagedRegistryConnection> connections = tCommittedAndRollbackedConnectionMap.get();
                for (Map.Entry<String, ManagedRegistryConnection> e : connections.entrySet()) {
                    if (e.getValue() == null) continue;
                    e.getValue().getConnection().rollback();
                }
                tCommittedAndRollbackedConnectionMap.set(new LinkedHashMap());
                this.connection.rollback();
                tRollbackedConnection.set(false);
                log.trace((Object)"Rolled back all transactions.");
            } else {
                if (tManagedConnectionMap.get().size() < this.getConnectionCount(tCommittedAndRollbackedConnectionMap.get())) {
                    throw new SQLException("Total number of available connections are less than the total number of rollbacked or committed connections");
                }
                tCommittedAndRollbackedConnectionMap.get().put(this.getConnectionId(), this);
            }
        }

        @Override
        public void close() throws SQLException {
            if (statsLog.isDebugEnabled()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (connectionStatistics == null) {
                            log.error((Object)"Unable to store connection statistics.");
                        } else {
                            connectionStatistics.incrementConnectionsClosed();
                            while (!connectionStatistics.isConnectionCreatorStackFound(ManagedRegistryConnection.this.uuid)) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            connectionStatistics.removeConnectionCreatorStack(ManagedRegistryConnection.this.uuid);
                        }
                    }
                };
                if (executor != null) {
                    executor.execute(runnable);
                } else {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                    executor.execute(runnable);
                }
            }
            if (tManagedConnectionMap.get().size() == 1) {
                this.connection.close();
                tManagedConnectionMap.set(new LinkedHashMap());
                log.trace((Object)"Closed all transactions.");
            } else if (tClosedConnectionMap.get().get(this.getConnectionId()) == null && tManagedConnectionMap.get().size() == this.getConnectionCount(tClosedConnectionMap.get()) + 1) {
                Map<String, ManagedRegistryConnection> connections = tClosedConnectionMap.get();
                for (Map.Entry<String, ManagedRegistryConnection> e : connections.entrySet()) {
                    if (e.getValue() == null) continue;
                    e.getValue().getConnection().close();
                }
                tClosedConnectionMap.set(new LinkedHashMap());
                this.connection.close();
                tManagedConnectionMap.set(new LinkedHashMap());
                log.trace((Object)"Closed all transactions.");
            } else {
                if (tManagedConnectionMap.get().size() < this.getConnectionCount(tClosedConnectionMap.get())) {
                    throw new SQLException("Total number of available connections are less than the total number of closed connections");
                }
                tClosedConnectionMap.get().put(this.getConnectionId(), this);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            if (tManagedConnectionMap.get().size() == 1) {
                return this.connection.isClosed();
            }
            return tClosedConnectionMap.get().get(this.getConnectionId()) != null || this.connection.isClosed();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            if (tManagedConnectionMap.get().size() != 1) {
                throw new UnsupportedOperationException("Rollback to Save Point is not supported for operations involving multiple connections.");
            }
            this.connection.rollback(savepoint);
        }

        @Override
        public Blob createBlob() throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Clob createClob() throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public NClob createNClob() throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Properties getClientInfo() {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public String getClientInfo(String name) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public boolean isValid(int timeout) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setClientInfo(Properties properties) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setClientInfo(String name, String value) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public boolean isWrapperFor(Class<?> i) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public <T> T unwrap(Class<T> i) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String s) throws SQLException {
            if (statsLog.isDebugEnabled() || dbQueryLog.isDebugEnabled()) {
                if (executor == null) {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                }
                return new MonitoredPreparedStatement(this.connection.prepareStatement(s), connectionStatistics, executor);
            }
            return this.connection.prepareStatement(s);
        }

        @Override
        public CallableStatement prepareCall(String s) throws SQLException {
            return this.connection.prepareCall(s);
        }

        @Override
        public String nativeSQL(String s) throws SQLException {
            return this.connection.nativeSQL(s);
        }

        @Override
        public void setAutoCommit(boolean b) throws SQLException {
            this.connection.setAutoCommit(b);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.connection.getAutoCommit();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.connection.getMetaData();
        }

        @Override
        public void setReadOnly(boolean b) throws SQLException {
            this.connection.setReadOnly(b);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.connection.isReadOnly();
        }

        @Override
        public void setCatalog(String s) throws SQLException {
            this.connection.setCatalog(s);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.connection.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int i) throws SQLException {
            this.connection.setTransactionIsolation(i);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.connection.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.connection.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.connection.clearWarnings();
        }

        @Override
        public Statement createStatement(int i, int i1) throws SQLException {
            return this.connection.createStatement(i, i1);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int i, int i1) throws SQLException {
            if (statsLog.isDebugEnabled() || dbQueryLog.isDebugEnabled()) {
                if (executor == null) {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                }
                return new MonitoredPreparedStatement(this.connection.prepareStatement(s, i, i1), connectionStatistics, executor);
            }
            return this.connection.prepareStatement(s, i, i1);
        }

        @Override
        public CallableStatement prepareCall(String s, int i, int i1) throws SQLException {
            return this.connection.prepareCall(s, i, i1);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.connection.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> stringClassMap) throws SQLException {
            this.connection.setTypeMap(stringClassMap);
        }

        @Override
        public void setHoldability(int i) throws SQLException {
            this.connection.setHoldability(i);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.connection.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.connection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String s) throws SQLException {
            return this.connection.setSavepoint(s);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.connection.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int i, int i1, int i2) throws SQLException {
            return this.connection.createStatement(i, i1, i2);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int i, int i1, int i2) throws SQLException {
            if (statsLog.isDebugEnabled() || dbQueryLog.isDebugEnabled()) {
                if (executor == null) {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                }
                return new MonitoredPreparedStatement(this.connection.prepareStatement(s, i, i1, i2), connectionStatistics, executor);
            }
            return this.connection.prepareStatement(s, i, i1, i2);
        }

        @Override
        public CallableStatement prepareCall(String s, int i, int i1, int i2) throws SQLException {
            return this.connection.prepareCall(s, i, i1, i2);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int i) throws SQLException {
            if (statsLog.isDebugEnabled() || dbQueryLog.isDebugEnabled()) {
                if (executor == null) {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                }
                return new MonitoredPreparedStatement(this.connection.prepareStatement(s, i), connectionStatistics, executor);
            }
            return this.connection.prepareStatement(s, i);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int[] integers) throws SQLException {
            if (statsLog.isDebugEnabled() || dbQueryLog.isDebugEnabled()) {
                if (executor == null) {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                }
                return new MonitoredPreparedStatement(this.connection.prepareStatement(s, integers), connectionStatistics, executor);
            }
            return this.connection.prepareStatement(s, integers);
        }

        @Override
        public PreparedStatement prepareStatement(String s, String[] strings) throws SQLException {
            if (statsLog.isDebugEnabled() || dbQueryLog.isDebugEnabled()) {
                if (executor == null) {
                    ManagedRegistryConnection.initializeStatisticsLogging();
                }
                return new MonitoredPreparedStatement(this.connection.prepareStatement(s, strings), connectionStatistics, executor);
            }
            return this.connection.prepareStatement(s, strings);
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        static {
            if (statsLog.isDebugEnabled()) {
                ManagedRegistryConnection.initializeStatisticsLogging();
            }
            tManagedConnectionMap = new ThreadLocal<Map<String, ManagedRegistryConnection>>(){

                @Override
                protected Map<String, ManagedRegistryConnection> initialValue() {
                    return new LinkedHashMap<String, ManagedRegistryConnection>();
                }
            };
            tCommittedAndRollbackedConnectionMap = new ThreadLocal<Map<String, ManagedRegistryConnection>>(){

                @Override
                protected Map<String, ManagedRegistryConnection> initialValue() {
                    return new LinkedHashMap<String, ManagedRegistryConnection>();
                }
            };
            tClosedConnectionMap = new ThreadLocal<Map<String, ManagedRegistryConnection>>(){

                @Override
                protected Map<String, ManagedRegistryConnection> initialValue() {
                    return new LinkedHashMap<String, ManagedRegistryConnection>();
                }
            };
            tRollbackedConnection = new ThreadLocal<Boolean>(){

                @Override
                protected Boolean initialValue() {
                    return false;
                }
            };
        }
    }

    private static class MonitoredPreparedStatement
    implements PreparedStatement {
        private PreparedStatement preparedStatement;
        private ConnectionStatistics connectionStatistics = null;
        private ExecutorService executor = null;

        public MonitoredPreparedStatement(PreparedStatement preparedStatement, ConnectionStatistics connectionStatistics, ExecutorService executor) {
            this.preparedStatement = preparedStatement;
            this.connectionStatistics = connectionStatistics;
            this.executor = executor;
            this.recordStatementPrepared();
        }

        private void recordStatementPrepared() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MonitoredPreparedStatement.this.connectionStatistics == null) {
                        log.error((Object)"Unable to store connection statistics.");
                    } else {
                        MonitoredPreparedStatement.this.connectionStatistics.incrementStatementsPrepared();
                    }
                }
            };
            if (this.executor != null) {
                this.executor.execute(runnable);
            }
        }

        private void recordStatementClosed() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MonitoredPreparedStatement.this.connectionStatistics == null) {
                        log.error((Object)"Unable to store connection statistics.");
                    } else {
                        MonitoredPreparedStatement.this.connectionStatistics.incrementStatementsClosed();
                    }
                }
            };
            if (this.executor != null) {
                this.executor.execute(runnable);
            }
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            if (dbQueryLog.isDebugEnabled()) {
                this.recordStatistics(this.preparedStatement.toString());
            }
            return this.preparedStatement.executeQuery();
        }

        @Override
        public int executeUpdate() throws SQLException {
            if (dbQueryLog.isDebugEnabled()) {
                this.recordStatistics(this.preparedStatement.toString());
            }
            return this.preparedStatement.executeUpdate();
        }

        private void recordStatistics(String statement) {
            String type = this.getOperationType(statement);
            StatisticsRecord statisticsRecord = DBQueryStatisticsLog.getStatisticsRecord();
            for (String record : this.getTableNames(statement)) {
                statisticsRecord.addRecord(record + " (" + type + ")");
                if (!Boolean.toString(true).equals(System.getProperty("carbon.registry.statistics.output.queries.executed"))) continue;
                statisticsRecord.addQuery(statement);
            }
        }

        private String[] getTableNames(final String statement) {
            List<String> names = Arrays.asList("REG_CLUSTER_LOCK", "REG_LOG", "REG_PATH", "REG_CONTENT", "REG_CONTENT_HISTORY", "REG_RESOURCE", "REG_RESOURCE_HISTORY", "REG_COMMENT", "REG_RESOURCE_COMMENT", "REG_RATING", "REG_RESOURCE_RATING", "REG_TAG", "REG_RESOURCE_TAG", "REG_PROPERTY", "REG_RESOURCE_PROPERTY", "REG_ASSOCIATION", "REG_SNAPSHOT");
            LinkedList<String> namesOnStatement = new LinkedList<String>();
            for (String name : names) {
                if (!statement.contains(name)) continue;
                namesOnStatement.add(name);
            }
            Collections.sort(namesOnStatement, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.valueOf(statement.indexOf(o1)).compareTo(statement.indexOf(o2));
                }
            });
            return namesOnStatement.toArray(new String[namesOnStatement.size()]);
        }

        private String getOperationType(String statement) {
            if (statement.contains("SELECT")) {
                return "R";
            }
            if (statement.contains("INSERT") || statement.contains("UPDATE") || statement.contains("DELETE")) {
                return "W";
            }
            return "";
        }

        @Override
        public void setNull(int i, int i1) throws SQLException {
            this.preparedStatement.setNull(i, i1);
        }

        @Override
        public void setBoolean(int i, boolean b) throws SQLException {
            this.preparedStatement.setBoolean(i, b);
        }

        @Override
        public void setByte(int i, byte b) throws SQLException {
            this.preparedStatement.setByte(i, b);
        }

        @Override
        public void setShort(int i, short s) throws SQLException {
            this.preparedStatement.setShort(i, s);
        }

        @Override
        public void setInt(int i, int i1) throws SQLException {
            this.preparedStatement.setInt(i, i1);
        }

        @Override
        public void setLong(int i, long l) throws SQLException {
            this.preparedStatement.setLong(i, l);
        }

        @Override
        public void setFloat(int i, float v) throws SQLException {
            this.preparedStatement.setFloat(i, v);
        }

        @Override
        public void setDouble(int i, double v) throws SQLException {
            this.preparedStatement.setDouble(i, v);
        }

        @Override
        public void setBigDecimal(int i, BigDecimal bigDecimal) throws SQLException {
            this.preparedStatement.setBigDecimal(i, bigDecimal);
        }

        @Override
        public void setString(int i, String s) throws SQLException {
            this.preparedStatement.setString(i, s);
        }

        @Override
        public void setBytes(int i, byte[] bytes) throws SQLException {
            this.preparedStatement.setBytes(i, bytes);
        }

        @Override
        public void setDate(int i, Date date) throws SQLException {
            this.preparedStatement.setDate(i, date);
        }

        @Override
        public void setTime(int i, Time time) throws SQLException {
            this.preparedStatement.setTime(i, time);
        }

        @Override
        public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
            this.preparedStatement.setTimestamp(i, timestamp);
        }

        @Override
        public void setAsciiStream(int i, InputStream inputStream, int i1) throws SQLException {
            this.preparedStatement.setAsciiStream(i, inputStream, i1);
        }

        @Override
        public void setUnicodeStream(int i, InputStream inputStream, int i1) throws SQLException {
            this.preparedStatement.setUnicodeStream(i, inputStream, i1);
        }

        @Override
        public void setBinaryStream(int i, InputStream inputStream, int i1) throws SQLException {
            this.preparedStatement.setBinaryStream(i, inputStream, i1);
        }

        @Override
        public void clearParameters() throws SQLException {
            this.preparedStatement.clearParameters();
        }

        @Override
        public void setObject(int i, Object o, int i1, int i2) throws SQLException {
            this.preparedStatement.setObject(i, o, i1, i2);
        }

        @Override
        public void setObject(int i, Object o, int i1) throws SQLException {
            this.preparedStatement.setObject(i, o, i1);
        }

        @Override
        public void setObject(int i, Object o) throws SQLException {
            this.preparedStatement.setObject(i, o);
        }

        @Override
        public boolean execute() throws SQLException {
            return this.preparedStatement.execute();
        }

        @Override
        public void addBatch() throws SQLException {
            this.preparedStatement.addBatch();
        }

        @Override
        public void setCharacterStream(int i, Reader reader, int i1) throws SQLException {
            this.preparedStatement.setCharacterStream(i, reader, i1);
        }

        @Override
        public void setRef(int i, Ref ref) throws SQLException {
            this.preparedStatement.setRef(i, ref);
        }

        @Override
        public void setBlob(int i, Blob blob) throws SQLException {
            this.preparedStatement.setBlob(i, blob);
        }

        @Override
        public void setClob(int i, Clob clob) throws SQLException {
            this.preparedStatement.setClob(i, clob);
        }

        @Override
        public void setArray(int i, Array array) throws SQLException {
            this.preparedStatement.setArray(i, array);
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this.preparedStatement.getMetaData();
        }

        @Override
        public void setDate(int i, Date date, Calendar calendar) throws SQLException {
            this.preparedStatement.setDate(i, date, calendar);
        }

        @Override
        public void setTime(int i, Time time, Calendar calendar) throws SQLException {
            this.preparedStatement.setTime(i, time, calendar);
        }

        @Override
        public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
            this.preparedStatement.setTimestamp(i, timestamp, calendar);
        }

        @Override
        public void setNull(int i, int i1, String s) throws SQLException {
            this.preparedStatement.setNull(i, i1, s);
        }

        @Override
        public void setURL(int i, URL url) throws SQLException {
            this.preparedStatement.setURL(i, url);
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.preparedStatement.getParameterMetaData();
        }

        @Override
        public ResultSet executeQuery(String s) throws SQLException {
            return this.preparedStatement.executeQuery(s);
        }

        @Override
        public int executeUpdate(String s) throws SQLException {
            return this.preparedStatement.executeUpdate(s);
        }

        @Override
        public void close() throws SQLException {
            this.recordStatementClosed();
            this.preparedStatement.close();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.preparedStatement.getMaxFieldSize();
        }

        @Override
        public void setMaxFieldSize(int i) throws SQLException {
            this.preparedStatement.setMaxFieldSize(i);
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.preparedStatement.getMaxRows();
        }

        @Override
        public void setMaxRows(int i) throws SQLException {
            this.preparedStatement.setMaxRows(i);
        }

        @Override
        public void setEscapeProcessing(boolean b) throws SQLException {
            this.preparedStatement.setEscapeProcessing(b);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.preparedStatement.getQueryTimeout();
        }

        @Override
        public void setQueryTimeout(int i) throws SQLException {
            this.preparedStatement.setQueryTimeout(i);
        }

        @Override
        public void cancel() throws SQLException {
            this.preparedStatement.cancel();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.preparedStatement.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.preparedStatement.clearWarnings();
        }

        @Override
        public void setCursorName(String s) throws SQLException {
            this.preparedStatement.setCursorName(s);
        }

        @Override
        public boolean execute(String s) throws SQLException {
            return this.preparedStatement.execute(s);
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.preparedStatement.getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.preparedStatement.getUpdateCount();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.preparedStatement.getMoreResults();
        }

        @Override
        public void setFetchDirection(int i) throws SQLException {
            this.preparedStatement.setFetchDirection(i);
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.preparedStatement.getFetchDirection();
        }

        @Override
        public void setFetchSize(int i) throws SQLException {
            this.preparedStatement.setFetchSize(i);
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.preparedStatement.getFetchSize();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.preparedStatement.getResultSetConcurrency();
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.preparedStatement.getResultSetType();
        }

        @Override
        public void addBatch(String s) throws SQLException {
            this.preparedStatement.addBatch(s);
        }

        @Override
        public void clearBatch() throws SQLException {
            this.preparedStatement.clearBatch();
        }

        @Override
        public int[] executeBatch() throws SQLException {
            return this.preparedStatement.executeBatch();
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.preparedStatement.getConnection();
        }

        @Override
        public boolean getMoreResults(int i) throws SQLException {
            return this.preparedStatement.getMoreResults(i);
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.preparedStatement.getGeneratedKeys();
        }

        @Override
        public int executeUpdate(String s, int i) throws SQLException {
            return this.preparedStatement.executeUpdate(s, i);
        }

        @Override
        public int executeUpdate(String s, int[] integers) throws SQLException {
            return this.preparedStatement.executeUpdate(s, integers);
        }

        @Override
        public int executeUpdate(String s, String[] strings) throws SQLException {
            return this.preparedStatement.executeUpdate(s, strings);
        }

        @Override
        public boolean execute(String s, int i) throws SQLException {
            return this.preparedStatement.execute(s, i);
        }

        @Override
        public boolean execute(String s, int[] integers) throws SQLException {
            return this.preparedStatement.execute(s, integers);
        }

        @Override
        public boolean execute(String s, String[] strings) throws SQLException {
            return this.preparedStatement.execute(s, strings);
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.preparedStatement.getResultSetHoldability();
        }

        @Override
        public void setNClob(int i, Reader reader) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setClob(int i, Reader reader) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setBlob(int i, InputStream x) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setNClob(int i, Reader reader, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setClob(int i, Reader reader, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setBlob(int i, InputStream x, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setNCharacterStream(int i, Reader reader) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setCharacterStream(int i, Reader reader) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setAsciiStream(int i, InputStream x) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setBinaryStream(int i, InputStream x) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setNCharacterStream(int i, Reader reader, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setCharacterStream(int i, Reader reader, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setAsciiStream(int i, InputStream x, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setBinaryStream(int i, InputStream x, long l) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setNClob(int i, NClob nClob) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setNString(int i, String string) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setSQLXML(int i, SQLXML sqlxml) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setRowId(int i, RowId rowId) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public boolean isPoolable() throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public void setPoolable(boolean b) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public boolean isClosed() throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public boolean isWrapperFor(Class<?> c) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public <T> T unwrap(Class<T> c) throws SQLException {
            throw new UnsupportedOperationException("This method is not supported");
        }
    }

    private static class ConnectionStatistics {
        private long connectionsCreated = 0L;
        private long connectionsClosed = 0L;
        private long connectionsCommitted = 0L;
        private long connectionsRollbacked = 0L;
        private long statementsPrepared = 0L;
        private long statementsClosed = 0L;
        private Map<String, ConnectionCreatorStack> connectionCreatorStacks = new LinkedHashMap<String, ConnectionCreatorStack>();

        private ConnectionStatistics() {
        }

        public synchronized void setConnectionCreatorStack(String uuid, ConnectionCreatorStack connectionCreatorStack) {
            this.connectionCreatorStacks.put(uuid, connectionCreatorStack);
        }

        public synchronized boolean isConnectionCreatorStackFound(String uuid) {
            return this.connectionCreatorStacks.get(uuid) != null;
        }

        public synchronized void removeConnectionCreatorStack(String uuid) {
            this.connectionCreatorStacks.remove(uuid);
        }

        public Collection<ConnectionCreatorStack> getConnectionCreatorStacks() {
            return this.connectionCreatorStacks.values();
        }

        public long getConnectionsCreated() {
            return this.connectionsCreated;
        }

        public long getConnectionsClosed() {
            return this.connectionsClosed;
        }

        public long getConnectionsCommitted() {
            return this.connectionsCommitted;
        }

        public long getConnectionsRollbacked() {
            return this.connectionsRollbacked;
        }

        public long getStatementsPrepared() {
            return this.statementsPrepared;
        }

        public long getStatementsClosed() {
            return this.statementsClosed;
        }

        public synchronized void incrementConnectionsCreated() {
            if (this.connectionsCreated != Long.MAX_VALUE) {
                ++this.connectionsCreated;
            }
        }

        public synchronized void incrementConnectionsClosed() {
            if (this.connectionsClosed != Long.MAX_VALUE) {
                ++this.connectionsClosed;
            }
        }

        public synchronized void incrementConnectionsCommitted() {
            if (this.connectionsCommitted != Long.MAX_VALUE) {
                ++this.connectionsCommitted;
            }
        }

        public synchronized void incrementConnectionsRollbacked() {
            if (this.connectionsRollbacked != Long.MAX_VALUE) {
                ++this.connectionsRollbacked;
            }
        }

        public synchronized void incrementStatementsPrepared() {
            if (this.statementsPrepared != Long.MAX_VALUE) {
                ++this.statementsPrepared;
            }
        }

        public synchronized void incrementStatementsClosed() {
            if (this.statementsClosed != Long.MAX_VALUE) {
                ++this.statementsClosed;
            }
        }
    }

    private static class ConnectionCreatorStack {
        private List<StackTraceElement> stackTraceElements;
        private java.util.Date createdTime;

        public ConnectionCreatorStack(StackTraceElement[] stackTraceElements, java.util.Date createdTime) {
            if (stackTraceElements != null) {
                this.stackTraceElements = Arrays.asList(stackTraceElements);
            }
            this.createdTime = createdTime;
        }

        public StackTraceElement[] getStackTraceElements() {
            if (this.stackTraceElements == null) {
                return new StackTraceElement[0];
            }
            return this.stackTraceElements.toArray(new StackTraceElement[this.stackTraceElements.size()]);
        }

        public java.util.Date getCreatedTime() {
            return this.createdTime;
        }
    }

    private static class TransactionEntry {
        private boolean started;
        private ManagedRegistryConnection connection;
        private int nestedDepth;
        private boolean rollbacked;

        private TransactionEntry() {
        }

        public boolean isStarted() {
            return this.started;
        }

        public void setStarted(boolean started) {
            this.started = started;
        }

        public ManagedRegistryConnection getConnection() {
            return this.connection;
        }

        public void setConnection(ManagedRegistryConnection connection) {
            this.connection = connection;
        }

        public int getNestedDepth() {
            return this.nestedDepth;
        }

        public void setNestedDepth(int nestedDepth) {
            this.nestedDepth = nestedDepth;
        }

        public boolean isRollbacked() {
            return this.rollbacked;
        }

        public void setRollbacked(boolean rollbacked) {
            this.rollbacked = rollbacked;
        }
    }
}

