/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.stub.DashboardServiceStub;
import org.wso2.carbon.dashboard.stub.types.bean.DashboardContentBean;
import org.wso2.carbon.ui.CarbonSSOSessionManager;

public class DashboardServiceClient {
    private static final Log log = LogFactory.getLog(DashboardServiceClient.class);
    DashboardServiceStub stub;

    public DashboardServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "DashboardService";
        this.stub = new DashboardServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String getTabLayout(String userId, String dashboardName) {
        try {
            return this.stub.getTabLayout(userId, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getGadgetLayout(String loggeduser, String currentActiveTab, String dashboardName) {
        try {
            return this.stub.getGadgetLayout(loggeduser, currentActiveTab, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Boolean addGadgetToUser(String loggeduser, String currentActiveTab, String gadgetUrl, String dashboardName, String gadgetGroup) {
        try {
            return this.stub.addGadgetToUser(loggeduser, currentActiveTab, gadgetUrl, dashboardName, gadgetGroup);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public String[] getGadgetUrlsToLayout(String loggeduser, String currentActiveTab, String dashboardName, String backendURL) {
        try {
            return this.stub.getGadgetUrlsToLayout(loggeduser, currentActiveTab, dashboardName, backendURL);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getTabTitle(String loggeduser, String tabId, String dashboardName) {
        try {
            return this.stub.getTabTitle(loggeduser, tabId, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Boolean isReadOnlyMode(String userId) {
        try {
            return this.stub.isReadOnlyMode(userId);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return true;
        }
    }

    public Integer addNewTab(String userId, String tabTitle, String dashboardName) {
        try {
            return this.stub.addNewTab(userId, tabTitle, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getGadgetPrefs(String userId, String gadgetId, String prefId, String dashboardName) {
        try {
            return this.stub.getGadgetPrefs(userId, gadgetId, prefId, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Boolean removeGadget(String userId, String tabId, String gadgetId, String dashboardName) {
        try {
            return this.stub.removeGadget(userId, tabId, gadgetId, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean removeTab(String userId, String tabId, String dashboardName) {
        try {
            return this.stub.removeTab(userId, tabId, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean setGadgetLayout(String userId, String tabId, String newLayout, String dashboardName) {
        try {
            return this.stub.setGadgetLayout(userId, tabId, newLayout, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean setGadgetPrefs(String userId, String gadgetId, String prefId, String value, String dashboardName) {
        try {
            return this.stub.setGadgetPrefs(userId, gadgetId, prefId, value, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public String getBackendHttpPort() {
        try {
            return this.stub.getBackendHttpPort();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Boolean isSelfRegistrationEnabled() {
        try {
            return this.stub.isSelfRegistrationEnabled();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean isExternalGadgetAdditionEnabled() {
        try {
            return this.stub.isExternalGadgetAdditionEnabled();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public String[] getDefaultGadgetUrlSet(String userId) {
        try {
            return this.stub.getDefaultGadgetUrlSet(userId);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Integer duplicateTab(String userId, String dashboardName, String sourceTabId, String newTabName) {
        try {
            return this.stub.duplicateTab(userId, dashboardName, sourceTabId, newTabName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return 0;
        }
    }

    public Boolean copyGadget(String userId, String tab, String dashboardName, String sourceGadgetId, String grp) {
        try {
            return this.stub.copyGadget(userId, dashboardName, sourceGadgetId, tab, grp);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean moveGadgetToTab(String userId, String dashboardName, String sourceGadgetId, String tab) {
        try {
            return this.stub.moveGadgetToTab(userId, dashboardName, sourceGadgetId, tab);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean isSessionValid() {
        try {
            return this.stub.isSessionValid();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public Boolean isSessionValid(HttpSession httpSession) {
        try {
            return this.stub.isSessionValid() && !httpSession.isNew() && CarbonSSOSessionManager.getInstance().isSessionValid(httpSession.getId());
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public String getPortalStylesUrl(String user) {
        try {
            return this.stub.getPortalStylesUrl(user);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String populateDefaultThreeColumnLayout(String userId, String tabId) {
        try {
            return this.stub.populateDefaultThreeColumnLayout(userId, tabId);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean populateCustomLayouts(String userId, String tabId, String layout, String dashboardName) {
        try {
            return this.stub.populateCustomLayouts(userId, tabId, layout, dashboardName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            return false;
        }
    }

    public DashboardContentBean getDashboardContentBean(String userId, String dashboardName, String tDomain, String backendServerURL) {
        try {
            return this.stub.getDashboardContent(userId, dashboardName, tDomain, backendServerURL);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getDashboardContentBeanAsJson(String userId, String dashboardName, String tDomain, String backendServerURL) {
        try {
            return this.stub.getDashboardContentAsJson(userId, dashboardName, tDomain, backendServerURL);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getTabContentBeanAsJson(String userId, String dashboardName, String tDomain, String backendServerURL, String currentTab) {
        try {
            return this.stub.getTabContentAsJson(userId, dashboardName, tDomain, backendServerURL, currentTab);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getTabLayoutWithNames(String userId, String dashboardName) {
        try {
            return this.stub.getTabLayoutWithNames(userId, dashboardName);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean populateDashboardTab(String tabId) {
        try {
            return this.stub.populateDashboardTab(tabId);
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }
}

