/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SQLQueryHandler
extends Handler {
    private static final Log log = LogFactory.getLog(SQLQueryHandler.class);

    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        String queryPath = requestContext.getResourcePath().getPath();
        Resource resource = requestContext.getRepository().get(queryPath);
        Object content = resource.getContent();
        if (content instanceof byte[]) {
            resource.setContent(RegistryUtils.decodeBytes((byte[])content));
        }
        requestContext.setProcessingComplete(true);
        return resource;
    }

    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        if (!RegistryUtils.hasAdminAuthorizations(CurrentSession.getUser(), CurrentSession.getUserRealm())) {
            String msg = "User " + CurrentSession.getUser() + " does not have necessary authorizations to add or modify queries.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        Resource resource = requestContext.getResource();
        Object content = resource.getContent();
        if (content instanceof String) {
            String textContent = (String)content;
            resource.setContent(RegistryUtils.encodeString(textContent));
        }
        String queryPath = requestContext.getResourcePath().getPath();
        requestContext.getRepository().put(queryPath, resource);
        requestContext.setProcessingComplete(true);
    }
}

