/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RemoteRegistryService
implements RegistryService {
    private static final Log log = LogFactory.getLog(RemoteRegistryService.class);
    private Registry registry;
    private RealmService realmService;
    private String chroot;
    private String url;

    public RemoteRegistryService(String registryURL, String username, String password) throws RegistryException {
        this(registryURL, username, password, null);
    }

    public RemoteRegistryService(String registryURL, String username, String password, String chroot) throws RegistryException {
        this(registryURL, username, password, null, chroot, false);
    }

    public RemoteRegistryService(String registryURL, String username, String password, RealmService realmService, String chroot) throws RegistryException {
        this(registryURL, username, password, realmService, chroot, true);
    }

    public RemoteRegistryService(String registryURL, String username, String password, RealmService realmService, String chroot, boolean populateConfiguration) throws RegistryException {
        try {
            RegistryContext.getBaseInstance(realmService, populateConfiguration);
            this.url = registryURL;
            this.realmService = realmService;
            this.chroot = chroot;
            this.registry = new RemoteRegistry(this.url, username, password);
            this.registry.get("/");
            if (realmService != null) {
                RegistryUtils.getBootstrapRealm(realmService);
            }
            UserRegistry systemRegistry = this.getSystemRegistry();
            RegistryUtils.addMountCollection(systemRegistry);
        }
        catch (MalformedURLException e) {
            log.fatal((Object)"Registry URL is malformed, Registry configuration must be invalid", (Throwable)e);
            throw new RegistryException("URL is malformed", e);
        }
        catch (Exception e) {
            log.fatal((Object)"Error initializing the remote registry, Registry configuration must be invalid", (Throwable)e);
            throw new RegistryException("Error initializing the remote registry", e);
        }
    }

    @Override
    public UserRegistry getUserRegistry() throws RegistryException {
        return this.getUserRegistry("wso2.anonymous.user", -1234);
    }

    @Override
    public UserRegistry getSystemRegistry() throws RegistryException {
        return this.getSystemRegistry(-1234);
    }

    @Override
    public UserRegistry getSystemRegistry(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, null);
    }

    @Override
    public UserRegistry getSystemRegistry(int tenantId, String chroot) throws RegistryException {
        String username = "wso2.system.user";
        return this.getUserRegistry(username, tenantId, chroot);
    }

    @Override
    public UserRegistry getUserRegistry(String username, String password) throws RegistryException {
        return this.getUserRegistry(username, password, -1234);
    }

    @Override
    public UserRegistry getUserRegistry(String username, String password, int tenantId) throws RegistryException {
        return this.getUserRegistry(username, password, tenantId, null);
    }

    @Override
    public UserRegistry getUserRegistry(String username, String password, int tenantId, String chroot) throws RegistryException {
        try {
            RemoteRegistry userRemote = new RemoteRegistry(this.url, username, password);
            return new UserRegistry(username, tenantId, userRemote, this.realmService, RegistryUtils.concatenateChroot(this.chroot, chroot));
        }
        catch (MalformedURLException e) {
            log.fatal((Object)"Registry URL is malformed, Registry configuration must be invalid", (Throwable)e);
            throw new RegistryException("URL is malformed");
        }
        catch (Exception e) {
            log.fatal((Object)"Error initializing the remote registry, User credentials must be invalid", (Throwable)e);
            throw new RegistryException("Error initializing the remote registry");
        }
    }

    @Override
    public UserRegistry getUserRegistry(String userName) throws RegistryException {
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            userName = MultitenantUtils.getTenantAwareUsername((String)userName);
            int tenantId = -1234;
            if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                if (this.realmService == null) {
                    String msg = "Unable to obtain an instance of a UserRegistry. The realm service is not available.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            }
            return this.getUserRegistry(userName, tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Failed in retrieving the tenant id for the user " + userName;
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
    }

    @Override
    public UserRegistry getUserRegistry(String userName, int tenantId) throws RegistryException {
        return this.getUserRegistry(userName, tenantId, null);
    }

    @Override
    public UserRegistry getUserRegistry(String userName, int tenantId, String chroot) throws RegistryException {
        return new UserRegistry(userName, tenantId, this.registry, this.realmService, RegistryUtils.concatenateChroot(this.chroot, chroot));
    }

    @Override
    public UserRealm getUserRealm(int tenantId) throws RegistryException {
        if (this.realmService == null) {
            String msg = "Unable to obtain an instance of a UserRealm. The realm service is not available.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        this.realmService.getBootstrapRealmConfiguration();
        UserRegistry anonymousUserRegistry = new UserRegistry("wso2.anonymous.user", tenantId, this.registry, this.realmService, null);
        return anonymousUserRegistry.getUserRealm();
    }

    @Override
    public UserRegistry getRegistry(String userName, int tenantId, String chroot) throws RegistryException {
        return this.getUserRegistry(userName, tenantId, chroot);
    }

    @Override
    public UserRegistry getRegistry(String userName, String password, int tenantId, String chroot) throws RegistryException {
        return this.getUserRegistry(userName, password, tenantId, chroot);
    }

    @Override
    public UserRegistry getRegistry() throws RegistryException {
        return this.getRegistry("wso2.anonymous.user");
    }

    @Override
    public UserRegistry getRegistry(String userName) throws RegistryException {
        return this.getRegistry(userName, -1234);
    }

    @Override
    public UserRegistry getRegistry(String userName, int tenantId) throws RegistryException {
        return this.getRegistry(userName, tenantId, null);
    }

    @Override
    public UserRegistry getRegistry(String userName, String password) throws RegistryException {
        return this.getRegistry(userName, password, -1234);
    }

    @Override
    public UserRegistry getRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getRegistry(userName, password, tenantId, null);
    }

    @Override
    public UserRegistry getLocalRepository() throws RegistryException {
        return this.getLocalRepository(-1234);
    }

    @Override
    public UserRegistry getLocalRepository(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, "/_system/local");
    }

    @Override
    public UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, "/_system/config");
    }

    @Override
    public UserRegistry getConfigSystemRegistry() throws RegistryException {
        return this.getConfigSystemRegistry(-1234);
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName, int tenantId) throws RegistryException {
        return this.getRegistry(userName, tenantId, "/_system/config");
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getRegistry(userName, password, tenantId, "/_system/config");
    }

    @Override
    public UserRegistry getConfigUserRegistry() throws RegistryException {
        return this.getConfigUserRegistry("wso2.anonymous.user");
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName) throws RegistryException {
        return this.getConfigUserRegistry(userName, -1234);
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName, String password) throws RegistryException {
        return this.getConfigUserRegistry(userName, password, -1234);
    }

    @Override
    public UserRegistry getGovernanceSystemRegistry(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, "/_system/governance");
    }

    @Override
    public UserRegistry getGovernanceSystemRegistry() throws RegistryException {
        return this.getGovernanceSystemRegistry(-1234);
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName, int tenantId) throws RegistryException {
        return this.getRegistry(userName, tenantId, "/_system/governance");
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getRegistry(userName, password, tenantId, "/_system/governance");
    }

    @Override
    public UserRegistry getGovernanceUserRegistry() throws RegistryException {
        return this.getGovernanceUserRegistry("wso2.anonymous.user");
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName) throws RegistryException {
        return this.getGovernanceUserRegistry(userName, -1234);
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName, String password) throws RegistryException {
        return this.getGovernanceUserRegistry(userName, password, -1234);
    }
}

