/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;

public class LinkSpec {
    private final Uri base;
    private final String rel;
    private final Uri href;

    public LinkSpec(Element element, Uri base) throws SpecParserException {
        this.base = base;
        this.rel = XmlUtil.getAttribute(element, "rel");
        if (this.rel == null) {
            throw new SpecParserException("Link/@rel is required!");
        }
        this.href = XmlUtil.getUriAttribute(element, "href");
        if (this.href == null) {
            throw new SpecParserException("Link/@href is required!");
        }
    }

    private LinkSpec(LinkSpec rhs, Substitutions substitutions) {
        this.rel = substitutions.substituteString(rhs.rel);
        this.base = rhs.base;
        this.href = this.base.resolve(substitutions.substituteUri(rhs.href));
    }

    public String getRel() {
        return this.rel;
    }

    public Uri getHref() {
        return this.href;
    }

    public LinkSpec substitute(Substitutions substitutions) {
        return new LinkSpec(this, substitutions);
    }

    public String toString() {
        return "<Link rel='" + this.rel + "' href='" + this.href.toString() + "'/>";
    }
}

