/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterUris;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;

public class SanitizingProxyingLinkRewriter
extends ProxyingLinkRewriter {
    private final String expectedMime;

    public SanitizingProxyingLinkRewriter(ContentRewriterUris rewriterUris, Uri gadgetUri, ContentRewriterFeature rewriterFeature, String container, String expectedMime, boolean debug, boolean nocache) {
        super(rewriterUris, gadgetUri, rewriterFeature, container, debug, nocache);
        this.expectedMime = expectedMime;
    }

    public String rewrite(String link, Uri context) {
        try {
            Uri.parse(link);
        }
        catch (RuntimeException re) {
            return "about:blank";
        }
        String rewritten = super.rewrite(link, context);
        rewritten = rewritten + "&sanitize=1";
        rewritten = rewritten + "&rewriteMime=" + this.expectedMime;
        return rewritten;
    }
}

