/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth.testing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.SimpleOAuthValidator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.OAuthUtil;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.AccessorInfo;

public class FakeOAuthServiceProvider
implements HttpFetcher {
    public static final String BODY_ECHO_HEADER = "X-Echoed-Body";
    public static final String RAW_BODY_ECHO_HEADER = "X-Echoed-Raw-Body";
    public static final String AUTHZ_ECHO_HEADER = "X-Echoed-Authz";
    public static final String SP_HOST = "http://www.example.com";
    public static final String REQUEST_TOKEN_URL = "http://www.example.com/request?param=foo";
    public static final String ACCESS_TOKEN_URL = "http://www.example.com/access";
    public static final String APPROVAL_URL = "http://www.example.com/authorize";
    public static final String RESOURCE_URL = "http://www.example.com/data";
    public static final String NOT_FOUND_URL = "http://www.example.com/404";
    public static final String ERROR_400 = "http://www.example.com/400";
    public static final String ECHO_URL = "http://www.example.com/echo";
    public static final String CONSUMER_KEY = "consumer";
    public static final String CONSUMER_SECRET = "secret";
    public static final int TOKEN_EXPIRATION_SECONDS = 60;
    public static final String PRIVATE_KEY_TEXT = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALRiMLAh9iimur8VA7qVvdqxevEuUkW4K+2KdMXmnQbG9Aa7k7eBjK1S+0LYmVjPKlJGNXHDGuy5Fw/d7rjVJ0BLB+ubPK8iA/Tw3hLQgXMRRGRXXCn8ikfuQfjUS1uZSatdLB81mydBETlJhI6GH4twrbDJCR2Bwy/XWXgqgGRzAgMBAAECgYBYWVtleUzavkbrPjy0T5FMou8HX9u2AC2ry8vD/l7cqedtwMPp9k7TubgNFo+NGvKsl2ynyprOZR1xjQ7WgrgVB+mmuScOM/5HVceFuGRDhYTCObE+y1kxRloNYXnx3ei1zbeYLPCHdhxRYW7T0qcynNmwrn05/KO2RLjgQNalsQJBANeA3Q4Nugqy4QBUCEC09SqylT2K9FrrItqL2QKc9v0ZzO2uwllCbg0dwpVuYPYXYvikNHHg+aCWF+VXsb9rpPsCQQDWR9TT4ORdzoj+NccnqkMsDmzt0EfNaAOwHOmVJ2RVBspPcxt5iN4HI7HNeG6U5YsFBb+/GZbgfBT3kpNGWPTpAkBI+gFhjfJvRw38n3g/+UeAkwMI2TJQS4n8+hid0uus3/zOjDySH3XHCUnocn1xOJAyZODBo47E+67R4jV1/gzbAkEAklJaspRPXP877NssM5nAZMU0/O/NGCZ+3jPgDUno6WbJn5cqm8MqWhW1xGkImgRk+fkDBquiq4gPiT898jusgQJAd5Zrr6Q8AO/0isr/3aa6O6NLQxISLKcPDk2NOccAfS/xOtfOz4sJYM3+Bs4Io9+dZGSDCA54Lw03eHTNQghS0A==";
    public static final String CERTIFICATE_TEXT = "-----BEGIN CERTIFICATE-----\nMIIBpjCCAQ+gAwIBAgIBATANBgkqhkiG9w0BAQUFADAZMRcwFQYDVQQDDA5UZXN0\nIFByaW5jaXBhbDAeFw03MDAxMDEwODAwMDBaFw0zODEyMzEwODAwMDBaMBkxFzAV\nBgNVBAMMDlRlc3QgUHJpbmNpcGFsMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQC0YjCwIfYoprq/FQO6lb3asXrxLlJFuCvtinTF5p0GxvQGu5O3gYytUvtC2JlY\nzypSRjVxwxrsuRcP3e641SdASwfrmzyvIgP08N4S0IFzEURkV1wp/IpH7kH41Etb\nmUmrXSwfNZsnQRE5SYSOhh+LcK2wyQkdgcMv11l4KoBkcwIDAQABMA0GCSqGSIb3\nDQEBBQUAA4GBAGZLPEuJ5SiJ2ryq+CmEGOXfvlTtEL2nuGtr9PewxkgnOjZpUy+d\n4TvuXJbNQc8f4AMWL/tO9w0Fk80rWKp9ea8/df4qMq5qlFWlx6yOLQxumNOmECKb\nWpkUQDIDJEoFUzKMVuJf4KO/FJ345+BNLGgbJ6WujreoM1X/gYfdnJ/J\n-----END CERTIFICATE-----";
    private final HashMap<String, TokenState> tokenState;
    private final OAuthConsumer signedFetchConsumer;
    private final OAuthConsumer oauthConsumer;
    private final TimeSource clock;
    private boolean unauthorized = false;
    private boolean throttled = false;
    private boolean vagueErrors = false;
    private boolean reportExpirationTimes = true;
    private boolean sessionExtension = false;
    private boolean rejectExtraParams = false;
    private boolean returnAccessTokenData = false;
    private int requestTokenCount = 0;
    private int accessTokenCount = 0;
    private int resourceAccessCount = 0;
    private Set<AccessorInfo.OAuthParamLocation> validParamLocations;
    private boolean returnNull;
    private GadgetException gadgetException;
    private RuntimeException runtimeException;
    private boolean checkTrustedParams;
    private int trustedParamCount;

    public FakeOAuthServiceProvider(TimeSource clock) {
        this.clock = clock;
        OAuthServiceProvider provider = new OAuthServiceProvider(REQUEST_TOKEN_URL, APPROVAL_URL, ACCESS_TOKEN_URL);
        this.signedFetchConsumer = new OAuthConsumer(null, null, null, null);
        this.signedFetchConsumer.setProperty("RSA-SHA1.X509Certificate", CERTIFICATE_TEXT);
        this.oauthConsumer = new OAuthConsumer(null, CONSUMER_KEY, CONSUMER_SECRET, provider);
        this.tokenState = Maps.newHashMap();
        this.validParamLocations = Sets.newHashSet();
        this.validParamLocations.add(AccessorInfo.OAuthParamLocation.URI_QUERY);
    }

    public void setVagueErrors(boolean vagueErrors) {
        this.vagueErrors = vagueErrors;
    }

    public void setSessionExtension(boolean sessionExtension) {
        this.sessionExtension = sessionExtension;
    }

    public void setReportExpirationTimes(boolean reportExpirationTimes) {
        this.reportExpirationTimes = reportExpirationTimes;
    }

    public void setRejectExtraParams(boolean rejectExtraParams) {
        this.rejectExtraParams = rejectExtraParams;
    }

    public void setReturnAccessTokenData(boolean returnAccessTokenData) {
        this.returnAccessTokenData = returnAccessTokenData;
    }

    public void addParamLocation(AccessorInfo.OAuthParamLocation paramLocation) {
        this.validParamLocations.add(paramLocation);
    }

    public void removeParamLocation(AccessorInfo.OAuthParamLocation paramLocation) {
        this.validParamLocations.remove((Object)paramLocation);
    }

    public void setParamLocation(AccessorInfo.OAuthParamLocation paramLocation) {
        this.validParamLocations.clear();
        this.validParamLocations.add(paramLocation);
    }

    public HttpResponse fetch(HttpRequest request) throws GadgetException {
        if (this.returnNull) {
            return null;
        }
        if (this.gadgetException != null) {
            throw this.gadgetException;
        }
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        if (request.getFollowRedirects()) {
            throw new RuntimeException("Not supposed to follow OAuth redirects");
        }
        String url = request.getUri().toString();
        try {
            if (url.startsWith(REQUEST_TOKEN_URL)) {
                ++this.requestTokenCount;
                return this.handleRequestTokenUrl(request);
            }
            if (url.startsWith(ACCESS_TOKEN_URL)) {
                ++this.accessTokenCount;
                return this.handleAccessTokenUrl(request);
            }
            if (url.startsWith(RESOURCE_URL)) {
                ++this.resourceAccessCount;
                return this.handleResourceUrl(request);
            }
            if (url.startsWith(NOT_FOUND_URL)) {
                return this.handleNotFoundUrl(request);
            }
            if (url.startsWith(ERROR_400)) {
                return this.handleError400Url(request);
            }
            if (url.startsWith(ECHO_URL)) {
                return this.handleEchoUrl(request);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem with request for URL " + url, e);
        }
        throw new RuntimeException("Unexpected request for " + url);
    }

    private HttpResponse handleRequestTokenUrl(HttpRequest request) throws Exception {
        String extra;
        MessageInfo info = this.parseMessage(request);
        String requestConsumer = info.message.getParameter("oauth_consumer_key");
        if (!CONSUMER_KEY.equals(requestConsumer)) {
            return this.makeOAuthProblemReport("consumer_key_unknown", "invalid consumer: " + requestConsumer, 403);
        }
        OAuthConsumer consumer = this.oauthConsumer;
        if (this.throttled) {
            return this.makeOAuthProblemReport("consumer_key_refused", "exceeded quota exhausted", 403);
        }
        if (this.unauthorized) {
            return this.makeOAuthProblemReport("permission_denied", "user refused access", 400);
        }
        if (this.rejectExtraParams && (extra = this.hasExtraParams(info.message)) != null) {
            return this.makeOAuthProblemReport("parameter_rejected", extra, 400);
        }
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        this.validateMessage(accessor, info, true);
        String requestToken = Crypto.getRandomString(16);
        String requestTokenSecret = Crypto.getRandomString(16);
        String callbackUrl = info.message.getParameter("oauth_callback");
        this.tokenState.put(requestToken, new TokenState(requestTokenSecret, accessor.consumer, callbackUrl));
        List<OAuth.Parameter> responseParams = OAuth.newList("oauth_token", requestToken, "oauth_token_secret", requestTokenSecret);
        if (callbackUrl != null) {
            responseParams.add(new OAuth.Parameter("oauth_callback_confirmed", "true"));
        }
        return new HttpResponse(OAuth.formEncode(responseParams));
    }

    private String hasExtraParams(OAuthMessage message) {
        for (Map.Entry<String, String> param : OAuthUtil.getParameters(message)) {
            if (param.getKey().startsWith("oauth") || param.getKey().equals("param")) continue;
            return param.getKey();
        }
        return null;
    }

    private HttpResponse makeOAuthProblemReport(String code, String text, int rc) throws IOException {
        if (this.vagueErrors) {
            return new HttpResponseBuilder().setHttpStatusCode(rc).setResponseString("some vague error").create();
        }
        OAuthMessage msg = new OAuthMessage(null, null, null);
        msg.addParameter("oauth_problem", code);
        msg.addParameter("oauth_problem_advice", text);
        return new HttpResponseBuilder().setHttpStatusCode(rc).addHeader("WWW-Authenticate", msg.getAuthorizationHeader("realm")).create();
    }

    private MessageInfo parseMessage(HttpRequest request) {
        String aznHeader;
        MessageInfo info = new MessageInfo();
        info.request = request;
        String method = request.getMethod();
        ParsedUrl parsed = new ParsedUrl(request.getUri().toString());
        ArrayList params = Lists.newArrayList();
        params.addAll(parsed.getParsedQuery());
        if (!this.validParamLocations.contains((Object)AccessorInfo.OAuthParamLocation.URI_QUERY)) {
            for (OAuth.Parameter p : params) {
                if (!p.getKey().contains("oauth_")) continue;
                throw new RuntimeException("Found unexpected query param " + p.getKey());
            }
        }
        if (this.validParamLocations.contains((Object)AccessorInfo.OAuthParamLocation.AUTH_HEADER) && (aznHeader = request.getHeader("Authorization")) != null) {
            info.aznHeader = aznHeader;
            for (OAuth.Parameter p : OAuthMessage.decodeAuthorization(aznHeader)) {
                if (p.getKey().equalsIgnoreCase("realm")) continue;
                params.add(p);
            }
        }
        info.body = request.getPostBodyAsString();
        try {
            info.rawBody = IOUtils.toByteArray((InputStream)request.getPostBody());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read post body bytes", e);
        }
        if (OAuth.isFormEncoded(request.getHeader("Content-Type"))) {
            params.addAll(OAuth.decodeForm(request.getPostBodyAsString()));
            if (!this.validParamLocations.contains((Object)AccessorInfo.OAuthParamLocation.POST_BODY) && info.body.contains("oauth_")) {
                throw new RuntimeException("Found unexpected post body data" + info.body);
            }
        }
        info.message = new OAuthMessage(method, parsed.getLocation(), params);
        if (this.checkTrustedParams) {
            if (!"foo".equals(OAuthUtil.getParameter(info.message, "oauth_magic"))) {
                throw new RuntimeException("no oauth_trusted=foo parameter");
            }
            if (!"bar".equals(OAuthUtil.getParameter(info.message, "opensocial_magic"))) {
                throw new RuntimeException("no opensocial_trusted=foo parameter");
            }
            if (!"quux".equals(OAuthUtil.getParameter(info.message, "xoauth_magic"))) {
                throw new RuntimeException("no xoauth_magic=quux parameter");
            }
            this.trustedParamCount += 3;
        }
        return info;
    }

    public String browserVisit(String url) throws Exception {
        ParsedUrl parsed = new ParsedUrl(url);
        String requestToken = parsed.getQueryParam("oauth_token");
        TokenState state = this.tokenState.get(requestToken);
        state.approveToken();
        state.setUserData(parsed.getQueryParam("user_data"));
        if (state.callbackUrl != null) {
            UriBuilder callback = UriBuilder.parse(state.callbackUrl);
            callback.addQueryParameter("oauth_verifier", state.verifier);
            return callback.toString();
        }
        return null;
    }

    public TokenPair getPreapprovedToken(String userData) {
        String requestToken = Crypto.getRandomString(16);
        String requestTokenSecret = Crypto.getRandomString(16);
        TokenState state = new TokenState(requestTokenSecret, this.oauthConsumer, null);
        state.approveToken();
        state.setUserData(userData);
        this.tokenState.put(requestToken, state);
        return new TokenPair(requestToken, requestTokenSecret);
    }

    public void revokeAllAccessTokens() throws Exception {
        for (TokenState state : this.tokenState.values()) {
            state.revokeToken();
        }
    }

    public void changeAllSessionHandles() throws Exception {
        for (TokenState state : this.tokenState.values()) {
            state.sessionHandle = null;
        }
    }

    private HttpResponse handleAccessTokenUrl(HttpRequest request) throws Exception {
        String accessTokenSecret;
        String extra;
        MessageInfo info = this.parseMessage(request);
        String requestToken = info.message.getParameter("oauth_token");
        TokenState state = this.tokenState.get(requestToken);
        if (this.throttled) {
            return this.makeOAuthProblemReport("consumer_key_refused", "exceeded quota", 403);
        }
        if (this.unauthorized) {
            return this.makeOAuthProblemReport("permission_denied", "user refused access", 401);
        }
        if (state == null) {
            return this.makeOAuthProblemReport("token_rejected", "Unknown request token", 401);
        }
        if (this.rejectExtraParams && (extra = this.hasExtraParams(info.message)) != null) {
            return this.makeOAuthProblemReport("parameter_rejected", extra, 400);
        }
        OAuthAccessor accessor = new OAuthAccessor(this.oauthConsumer);
        accessor.requestToken = requestToken;
        accessor.tokenSecret = state.tokenSecret;
        this.validateMessage(accessor, info, true);
        if (state.getState() == State.APPROVED_UNCLAIMED) {
            String sentVerifier = info.message.getParameter("oauth_verifier");
            if (state.verifier != null && !state.verifier.equals(sentVerifier)) {
                return this.makeOAuthProblemReport("bad_verifier", "wrong oauth verifier", 401);
            }
            state.claimToken();
        } else if (state.getState() == State.APPROVED) {
            String sentHandle = info.message.getParameter("oauth_session_handle");
            if (sentHandle == null) {
                return this.makeOAuthProblemReport("parameter_absent", "no oauth_session_handle", 400);
            }
            if (!sentHandle.equals(state.sessionHandle)) {
                return this.makeOAuthProblemReport("token_invalid", "token not valid", 401);
            }
            state.renewToken();
        } else {
            if (state.getState() == State.REVOKED) {
                return this.makeOAuthProblemReport("token_revoked", "Revoked access token can't be renewed", 401);
            }
            throw new Exception("Token in weird state " + (Object)((Object)state.getState()));
        }
        String accessToken = Crypto.getRandomString(16);
        state.tokenSecret = accessTokenSecret = Crypto.getRandomString(16);
        this.tokenState.put(accessToken, state);
        this.tokenState.remove(requestToken);
        List<OAuth.Parameter> params = OAuth.newList("oauth_token", accessToken, "oauth_token_secret", accessTokenSecret);
        if (this.sessionExtension) {
            params.add(new OAuth.Parameter("oauth_session_handle", state.sessionHandle));
            if (this.reportExpirationTimes) {
                params.add(new OAuth.Parameter("oauth_expires_in", "60"));
            }
        }
        if (this.returnAccessTokenData) {
            params.add(new OAuth.Parameter("userid", "userid value"));
            params.add(new OAuth.Parameter("xoauth_stuff", "xoauth_stuff value"));
            params.add(new OAuth.Parameter("oauth_stuff", "oauth_stuff value"));
        }
        return new HttpResponse(OAuth.formEncode(params));
    }

    private HttpResponse handleResourceUrl(HttpRequest request) throws Exception {
        OAuthConsumer consumer;
        MessageInfo info = this.parseMessage(request);
        String consumerId = info.message.getParameter("oauth_consumer_key");
        if (CONSUMER_KEY.equals(consumerId)) {
            consumer = this.oauthConsumer;
        } else if ("signedfetch".equals(consumerId)) {
            consumer = this.signedFetchConsumer;
        } else if ("container.com".equals(consumerId)) {
            consumer = this.signedFetchConsumer;
        } else {
            return this.makeOAuthProblemReport("parameter_missing", "oauth_consumer_key not found", 400);
        }
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        String responseBody = null;
        if (this.throttled) {
            return this.makeOAuthProblemReport("consumer_key_refused", "exceeded quota", 403);
        }
        if (this.unauthorized) {
            return this.makeOAuthProblemReport("permission_denied", "user refused access", 401);
        }
        if (consumer == this.oauthConsumer) {
            long expiration;
            String accessToken = info.message.getParameter("oauth_token");
            TokenState state = this.tokenState.get(accessToken);
            if (state == null) {
                return this.makeOAuthProblemReport("token_rejected", "Access token unknown", 401);
            }
            accessor.accessToken = accessToken;
            accessor.tokenSecret = state.getSecret();
            this.validateMessage(accessor, info, false);
            if (state.getState() != State.APPROVED) {
                return this.makeOAuthProblemReport("token_revoked", "User revoked permissions", 401);
            }
            if (this.sessionExtension && (expiration = state.issued + 60000L) < this.clock.currentTimeMillis()) {
                return this.makeOAuthProblemReport("access_token_expired", "token needs to be refreshed", 401);
            }
            responseBody = "User data is " + state.getUserData();
        } else {
            this.validateMessage(accessor, info, false);
            responseBody = request.getUri().getQuery();
        }
        HttpResponseBuilder resp = new HttpResponseBuilder().setHttpStatusCode(200).setResponseString(responseBody);
        if (info.aznHeader != null) {
            resp.setHeader(AUTHZ_ECHO_HEADER, info.aznHeader);
        }
        if (info.body != null) {
            resp.setHeader(BODY_ECHO_HEADER, info.body);
        }
        if (info.rawBody != null) {
            resp.setHeader(RAW_BODY_ECHO_HEADER, new String(Base64.encodeBase64((byte[])info.rawBody)));
        }
        return resp.create();
    }

    private void validateMessage(OAuthAccessor accessor, MessageInfo info, boolean tokenEndpoint) throws OAuthException, IOException, URISyntaxException {
        info.message.validateMessage(accessor, new FakeTimeOAuthValidator());
        String bodyHash = info.message.getParameter("oauth_body_hash");
        if (tokenEndpoint && bodyHash != null) {
            throw new RuntimeException("Can't have body hash on token endpoints");
        }
        OAuthUtil.SignatureType sigType = OAuthUtil.getSignatureType(tokenEndpoint, info.request.getHeader("Content-Type"));
        switch (sigType) {
            case URL_ONLY: {
                break;
            }
            case URL_AND_FORM_PARAMS: {
                if (bodyHash == null) break;
                throw new RuntimeException("Can't have body hash in form-encoded request");
            }
            case URL_AND_BODY_HASH: {
                byte[] expected;
                if (bodyHash == null) {
                    throw new RuntimeException("Requiring oauth_body_hash parameter");
                }
                byte[] received = Base64.decodeBase64((byte[])CharsetUtil.getUtf8Bytes(bodyHash));
                if (Arrays.equals(received, expected = DigestUtils.sha((byte[])info.rawBody))) break;
                throw new RuntimeException("oauth_body_hash mismatch");
            }
        }
    }

    private HttpResponse handleNotFoundUrl(HttpRequest request) throws Exception {
        return new HttpResponseBuilder().setHttpStatusCode(404).setResponseString("not found").create();
    }

    private HttpResponse handleError400Url(HttpRequest request) throws Exception {
        return new HttpResponseBuilder().setHttpStatusCode(400).setResponseString("bad request").create();
    }

    private HttpResponse handleEchoUrl(HttpRequest request) throws Exception {
        String query = request.getUri().getQuery();
        if (query.contains("add_oauth_token")) {
            query = query + "&oauth_token=abc";
        }
        return new HttpResponseBuilder().setHttpStatusCode(200).setResponseString(query).create();
    }

    public void setConsumersThrottled(boolean throttled) {
        this.throttled = throttled;
    }

    public void setConsumerUnauthorized(boolean unauthorized) {
        this.unauthorized = unauthorized;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    public int getRequestTokenCount() {
        return this.requestTokenCount;
    }

    public int getAccessTokenCount() {
        return this.accessTokenCount;
    }

    public int getResourceAccessCount() {
        return this.resourceAccessCount;
    }

    public void setThrow(GadgetException gadgetException) {
        this.gadgetException = gadgetException;
    }

    public void setThrow(RuntimeException runtimeException) {
        this.runtimeException = runtimeException;
    }

    public void setCheckTrustedParams(boolean checkTrustedParams) {
        this.checkTrustedParams = checkTrustedParams;
    }

    public int getTrustedParamCount() {
        return this.trustedParamCount;
    }

    private class FakeTimeOAuthValidator
    extends SimpleOAuthValidator {
        private FakeTimeOAuthValidator() {
        }

        protected long currentTimeMsec() {
            return FakeOAuthServiceProvider.this.clock.currentTimeMillis();
        }
    }

    public static class TokenPair {
        public final String token;
        public final String secret;

        public TokenPair(String token, String secret) {
            this.token = token;
            this.secret = secret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParsedUrl {
        String location = null;
        String query = null;
        List<OAuth.Parameter> decodedQuery = null;

        public ParsedUrl(String url) {
            int queryIndex = url.indexOf(63);
            if (queryIndex != -1) {
                this.query = url.substring(queryIndex + 1, url.length());
                this.location = url.substring(0, queryIndex);
            } else {
                this.location = url;
            }
        }

        public String getLocation() {
            return this.location;
        }

        public String getRawQuery() {
            return this.query;
        }

        public List<OAuth.Parameter> getParsedQuery() {
            if (this.decodedQuery == null) {
                this.decodedQuery = this.query != null ? OAuth.decodeForm(this.query) : Lists.newArrayList();
            }
            return this.decodedQuery;
        }

        public String getQueryParam(String name) {
            for (OAuth.Parameter p : this.getParsedQuery()) {
                if (!p.getKey().equals(name)) continue;
                return p.getValue();
            }
            return null;
        }
    }

    private static class MessageInfo {
        public OAuthMessage message;
        public String aznHeader;
        public String body;
        public byte[] rawBody;
        public HttpRequest request;

        private MessageInfo() {
        }
    }

    private class TokenState {
        String tokenSecret;
        OAuthConsumer consumer;
        State state;
        String userData;
        String sessionHandle;
        long issued;
        String callbackUrl;
        String verifier;

        public TokenState(String tokenSecret, OAuthConsumer consumer, String callbackUrl) {
            this.tokenSecret = tokenSecret;
            this.consumer = consumer;
            this.state = State.PENDING;
            this.userData = null;
            this.callbackUrl = callbackUrl;
        }

        public void approveToken() {
            this.state = State.APPROVED_UNCLAIMED;
            this.issued = FakeOAuthServiceProvider.this.clock.currentTimeMillis();
            if (this.callbackUrl != null) {
                this.verifier = Crypto.getRandomString(8);
            }
        }

        public void claimToken() {
            this.state = State.APPROVED;
            this.sessionHandle = Crypto.getRandomString(8);
        }

        public void renewToken() {
            this.issued = FakeOAuthServiceProvider.this.clock.currentTimeMillis();
        }

        public void revokeToken() {
            this.state = State.REVOKED;
        }

        public State getState() {
            return this.state;
        }

        public String getSecret() {
            return this.tokenSecret;
        }

        public void setUserData(String userData) {
            this.userData = userData;
        }

        public String getUserData() {
            return this.userData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        PENDING,
        APPROVED_UNCLAIMED,
        APPROVED,
        REVOKED;

    }
}

