/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.oauth.OAuthArguments;

public class OAuthGadgetContext
extends GadgetContext {
    private final SecurityToken securityToken;
    private final String container;
    private final Uri appUrl;
    private final boolean bypassSpecCache;

    public OAuthGadgetContext(SecurityToken securityToken, OAuthArguments arguments) {
        this.securityToken = securityToken;
        this.container = securityToken.getContainer();
        this.appUrl = Uri.parse(securityToken.getAppUrl());
        this.bypassSpecCache = arguments.getBypassSpecCache();
    }

    public String getContainer() {
        return this.container;
    }

    public SecurityToken getToken() {
        return this.securityToken;
    }

    public Uri getUrl() {
        return this.appUrl;
    }

    public boolean getIgnoreCache() {
        return this.bypassSpecCache;
    }
}

