/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class OAuthClientState {
    private static final int CLIENT_STATE_MAX_AGE_SECS = 3600;
    private static final String REQ_TOKEN_KEY = "r";
    private static final String REQ_TOKEN_SECRET_KEY = "rs";
    private static final String ACCESS_TOKEN_KEY = "a";
    private static final String ACCESS_TOKEN_SECRET_KEY = "as";
    private static final String OWNER_KEY = "o";
    private static final String SESSION_HANDLE_KEY = "sh";
    private static final String ACCESS_TOKEN_EXPIRATION_KEY = "e";
    private final Map<String, String> state;
    private final BlobCrypter crypter;

    public OAuthClientState(BlobCrypter crypter) {
        this.state = Maps.newHashMap();
        this.crypter = crypter;
    }

    public OAuthClientState(BlobCrypter crypter, String stateBlob) {
        this.crypter = crypter;
        Map<Object, Object> state = null;
        if (stateBlob != null) {
            try {
                state = crypter.unwrap(stateBlob, 3600);
            }
            catch (BlobCrypterException e) {
                // empty catch block
            }
        }
        if (state == null) {
            state = Maps.newHashMap();
        }
        this.state = state;
    }

    public boolean isEmpty() {
        return this.state.isEmpty() || this.state.size() == 1 && this.state.containsKey("t");
    }

    public String getEncryptedState() throws BlobCrypterException {
        return this.crypter.wrap(this.state);
    }

    public String getRequestToken() {
        return this.state.get(REQ_TOKEN_KEY);
    }

    public void setRequestToken(String requestToken) {
        this.setNullCheck(REQ_TOKEN_KEY, requestToken);
    }

    public String getRequestTokenSecret() {
        return this.state.get(REQ_TOKEN_SECRET_KEY);
    }

    public void setRequestTokenSecret(String requestTokenSecret) {
        this.setNullCheck(REQ_TOKEN_SECRET_KEY, requestTokenSecret);
    }

    public String getAccessToken() {
        return this.state.get(ACCESS_TOKEN_KEY);
    }

    public void setAccessToken(String accessToken) {
        this.setNullCheck(ACCESS_TOKEN_KEY, accessToken);
    }

    public String getAccessTokenSecret() {
        return this.state.get(ACCESS_TOKEN_SECRET_KEY);
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.setNullCheck(ACCESS_TOKEN_SECRET_KEY, accessTokenSecret);
    }

    public String getSessionHandle() {
        return this.state.get(SESSION_HANDLE_KEY);
    }

    public void setSessionHandle(String sessionHandle) {
        this.setNullCheck(SESSION_HANDLE_KEY, sessionHandle);
    }

    public long getTokenExpireMillis() {
        String expiration = this.state.get(ACCESS_TOKEN_EXPIRATION_KEY);
        if (expiration == null) {
            return 0L;
        }
        return Long.parseLong(expiration);
    }

    public void setTokenExpireMillis(long expirationMillis) {
        this.setNullCheck(ACCESS_TOKEN_EXPIRATION_KEY, Long.toString(expirationMillis));
    }

    public String getOwner() {
        return this.state.get(OWNER_KEY);
    }

    public void setOwner(String owner) {
        this.setNullCheck(OWNER_KEY, owner);
    }

    private void setNullCheck(String key, String value) {
        if (value == null) {
            this.state.remove(key);
        } else {
            this.state.put(key, value);
        }
    }
}

