/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.util.TimeSource;

public class HttpUtil {
    private static int defaultTtl = 31536000;
    private static TimeSource timeSource;

    public static void setTimeSource(TimeSource timeSource) {
        HttpUtil.timeSource = timeSource;
    }

    public static void setCachingHeaders(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, defaultTtl, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, boolean noProxy) {
        HttpUtil.setCachingHeaders(response, defaultTtl, noProxy);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl) {
        HttpUtil.setCachingHeaders(response, ttl, false);
    }

    public static void setNoCache(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, 0, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl, boolean noProxy) {
        response.setDateHeader("Expires", timeSource.currentTimeMillis() + 1000L * (long)ttl);
        if (ttl == 0) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
        } else if (noProxy) {
            response.setHeader("Cache-Control", "private,max-age=" + Integer.toString(ttl));
        } else {
            response.setHeader("Cache-Control", "public,max-age=" + Integer.toString(ttl));
        }
    }

    public static int getDefaultTtl() {
        return defaultTtl;
    }

    public static void setDefaultTtl(int defaultTtl) {
    }

    static {
        HttpUtil.setTimeSource(new TimeSource());
    }
}

