/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.themepopulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.themepopulator.ThemePopulatorContext;
import org.wso2.carbon.dashboard.themepopulator.ThemePopulatorException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

public class ThemePopulator {
    private static final Log log = LogFactory.getLog(ThemePopulator.class);
    public static final String SYSTEM_DEFAULT_THEMES_PATH = "/repository/gadget-server/themes";

    public static void populateThemes(int tenantId) {
        try {
            Registry registry;
            String themesDiskRoot = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "gs-themes";
            try {
                registry = ThemePopulatorContext.getRegistry(tenantId);
            }
            catch (Throwable e) {
                throw new ThemePopulatorException("Exception occoured : " + e);
            }
            if (!registry.resourceExists(SYSTEM_DEFAULT_THEMES_PATH)) {
                File gadgetsDir = new File(themesDiskRoot);
                if (gadgetsDir.exists()) {
                    ThemePopulator.beginFileTansfer(gadgetsDir, tenantId);
                    log.info((Object)"Successfully added default Themes to Registry.");
                } else {
                    log.info((Object)("Couldn't find contents at '" + themesDiskRoot + "'. Giving up."));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to activate Theme Populator for Gadget Server bundle ", (Throwable)e);
        }
    }

    public static void beginFileTansfer(File rootDirectory, int tenantId) throws RegistryException {
        try {
            String rootPath = rootDirectory.getAbsolutePath();
            Registry registry = ThemePopulatorContext.getRegistry(tenantId);
            Collection defaultGadgetCollection = registry.newCollection();
            AuthorizationManager authorizationManager = ThemePopulatorContext.getUserRealm().getAuthorizationManager();
            authorizationManager.authorizeRole("wso2.anonymous.role", "/_system/config/repository/gadget-server/themes", "http://www.wso2.org/projects/registry/actions/get");
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!transactionStarted) {
                    registry.beginTransaction();
                }
                registry.put(SYSTEM_DEFAULT_THEMES_PATH, (Resource)defaultGadgetCollection);
                ThemePopulator.transferDirectoryContentToRegistry(rootDirectory, registry, rootPath, tenantId);
                if (!transactionStarted) {
                    registry.commitTransaction();
                }
            }
            catch (Exception e) {
                if (!transactionStarted) {
                    registry.rollbackTransaction();
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (ThemePopulatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void transferDirectoryContentToRegistry(File rootDirectory, Registry registry, String rootPath, int tenantId) throws FileNotFoundException {
        try {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isFile()) {
                    String directoryRegistryPath = SYSTEM_DEFAULT_THEMES_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    Collection newCollection = registry.newCollection();
                    registry.put(directoryRegistryPath, (Resource)newCollection);
                    ThemePopulator.transferDirectoryContentToRegistry(file, registry, rootPath, tenantId);
                    continue;
                }
                if (file.getName().equals("theme-conf.xml")) {
                    if (!file.exists()) continue;
                    FileReader themeConfigXmlReader = new FileReader(file);
                    String confRegistryPath = SYSTEM_DEFAULT_THEMES_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    registry.restore(confRegistryPath, (Reader)themeConfigXmlReader);
                    continue;
                }
                ThemePopulator.addToRegistry(rootPath, file, tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void addToRegistry(String rootPath, File file, int tenantId) {
        try {
            Registry registry = ThemePopulatorContext.getRegistry(tenantId);
            String fileRegistryPath = SYSTEM_DEFAULT_THEMES_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
            Resource fileResource = registry.newResource();
            fileResource.setMediaType(new MimetypesFileTypeMap().getContentType(file));
            fileResource.setContentStream((InputStream)new FileInputStream(file));
            registry.put(fileRegistryPath, fileResource);
        }
        catch (ThemePopulatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

