/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.appdata.AppDataManager;
import org.wso2.carbon.registry.social.impl.appdata.AppDataManagerImpl;

@Singleton
public class GSAppDataService
implements AppDataService {
    private AppDataManager manager = new AppDataManagerImpl();

    @Inject
    public GSAppDataService() {
    }

    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken securityToken) throws ProtocolException {
        String[] userIdArray = new String[userIds.size()];
        int index = 0;
        for (UserId id : userIds) {
            if (id == null) continue;
            userIdArray[index++] = id.getUserId(securityToken);
        }
        String groupIdString = groupId.getType().name();
        Map resultMap = null;
        try {
            resultMap = this.manager.getPersonData(userIdArray, groupIdString, appId, fields);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance((Object)new DataCollection(resultMap));
    }

    public Future<Void> deletePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, SecurityToken securityToken) throws ProtocolException {
        String userIdString = userId.getUserId(securityToken);
        String groupIdString = groupId.getType().name();
        try {
            this.manager.deletePersonData(userIdString, groupIdString, appId, fields);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    public Future<Void> updatePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, Map<String, String> values, SecurityToken securityToken) throws ProtocolException {
        String userIdString = userId.getUserId(securityToken);
        String groupIdString = groupId.getType().name();
        try {
            this.manager.updatePersonData(userIdString, groupIdString, appId, fields, values);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }
}

