/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social;

import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dashboard.social.GadgetServerSocialDataMgtServiceContext;
import org.wso2.carbon.dashboard.social.common.PrivacyFieldDTO;
import org.wso2.carbon.dashboard.social.common.utils.SocialUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class GadgetServerSocialDataMgtService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(GadgetServerSocialDataMgtService.class);

    public Boolean updateUserProfile(String userId, String profileName, PrivacyFieldDTO[] profileData) {
        Boolean response = false;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            Registry registry = GadgetServerSocialDataMgtServiceContext.getRegistry();
            String profileDataPath = SocialUtils.USER_DASHBOARD_REGISTRY_ROOT + userId + "/gadget-server/profiles/" + profileName + "/";
            for (PrivacyFieldDTO pair : profileData) {
                Resource profileDataResource;
                String fullProfileDataPath = profileDataPath + pair.getFieldName();
                try {
                    profileDataResource = registry.get(fullProfileDataPath);
                }
                catch (RegistryException e) {
                    profileDataResource = registry.newCollection();
                }
                profileDataResource.setProperty("visibility", pair.getVisibilityValue());
                registry.put(fullProfileDataPath, profileDataResource);
            }
            response = true;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to update profile for user " + userId));
        }
        return response;
    }

    public PrivacyFieldDTO[] getUserProfile(String userId, String profileName, String[] claimValues) {
        PrivacyFieldDTO[] profileData = new PrivacyFieldDTO[claimValues.length];
        try {
            if (profileName == null) {
                profileName = "default";
            }
            Registry registry = GadgetServerSocialDataMgtServiceContext.getRegistry();
            String profileDataPath = SocialUtils.USER_DASHBOARD_REGISTRY_ROOT + userId + "/gadget-server/profiles/" + profileName + "/";
            String fullProfileDataPath = "";
            for (int i = 0; i < claimValues.length; ++i) {
                fullProfileDataPath = profileDataPath + claimValues[i];
                if (registry.resourceExists(fullProfileDataPath)) {
                    Resource profileDataResource = registry.get(fullProfileDataPath);
                    profileData[i] = new PrivacyFieldDTO();
                    profileData[i].setFieldName(claimValues[i]);
                    if (profileDataResource.getProperty("visibility") != null) {
                        profileData[i].setVisibilityValue(profileDataResource.getProperty("visibility"));
                        continue;
                    }
                    profileData[i].setVisibilityValue("none");
                    continue;
                }
                profileData[i] = new PrivacyFieldDTO();
                profileData[i].setFieldName(claimValues[i]);
                profileData[i].setVisibilityValue("none");
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to retrieve profile for user " + userId));
        }
        return profileData;
    }

    public String getUserProfileImage(String userId) {
        Object profileImage = null;
        try {
            Registry registry = GadgetServerSocialDataMgtServiceContext.getRegistry();
            String profileImagePath = "/users/" + userId + "/gadget-server/profiles/default/profileimage";
            String defaultImagePath = "/users/profileimage.jpg";
            if (registry.resourceExists(profileImagePath)) {
                Resource imageResource = registry.get(profileImagePath);
                return Base64.encode((byte[])((byte[])imageResource.getContent()));
            }
            return null;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to retrieve profile image for user " + userId));
            return null;
        }
    }

    public boolean saveUserProfileImage(String userId, String profileImage, String mediaType) {
        boolean result = false;
        String profileImagePath = "/users/" + userId + "/gadget-server/profiles/default/profileimage";
        try {
            Registry registry = GadgetServerSocialDataMgtServiceContext.getRegistry();
            Resource profileImageRes = registry.resourceExists(profileImagePath) ? registry.get(profileImagePath) : registry.newResource();
            byte[] imgData = Base64.decode((String)profileImage);
            profileImageRes.setContent((Object)imgData);
            profileImageRes.setMediaType(mediaType);
            registry.put(profileImagePath, profileImageRes);
            result = true;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to save profile image for user " + userId));
        }
        return result;
    }

    public boolean isProfileImageExists(String userId) {
        boolean result = false;
        String profileImagePath = "/users/" + userId + "/gadget-server/profiles/default/profileimage";
        try {
            Registry registry = GadgetServerSocialDataMgtServiceContext.getRegistry();
            result = registry.resourceExists(profileImagePath);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to save profile image for user " + userId));
        }
        return result;
    }
}

