/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.ui.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.service.RealmService;

public class SocialComponent {
    private static Log log = LogFactory.getLog(SocialComponent.class);
    private static RealmService realmService = null;
    private static RegistryService registryService = null;

    protected void activate(ComponentContext context) {
        log.debug((Object)"Social Impl bundle is activated ");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Social Impl bundle is deactivated ");
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        SocialComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        SocialComponent.realmService = null;
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        SocialComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        SocialComponent.registryService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static Registry getRegistry() throws RegistryException {
        return SocialComponent.getRegistryService().getRegistry();
    }

    public static UserStoreManager getUserStoreManager() throws RegistryException, UserStoreException {
        return SocialComponent.getRegistryService().getUserRealm(0).getUserStoreManager();
    }

    public static ClaimManager getClaimManager() throws RegistryException, UserStoreException {
        return SocialComponent.getRegistryService().getUserRealm(0).getClaimManager();
    }
}

