/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.appdata;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.appdata.AppDataManager;
import org.wso2.carbon.registry.social.impl.internal.SocialDSComponent;
import org.wso2.carbon.registry.social.impl.people.relationship.RelationshipManagerImpl;

public class AppDataManagerImpl
implements AppDataManager {
    private static Log log = LogFactory.getLog(AppDataManagerImpl.class);
    private Registry registry;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public Registry getRegistry() throws RegistryException {
        if (this.registry != null) {
            return this.registry;
        }
        return SocialDSComponent.getRegistry();
    }

    public Map<String, Map<String, String>> getPersonData(String[] userIds, String groupId, String appId, Set<String> fields) throws SocialDataException {
        ArrayList<String> userIdsToFetch = new ArrayList<String>();
        if ("friends".equals(groupId)) {
            for (String id : userIds) {
                String[] friendsList;
                for (String friend : friendsList = new RelationshipManagerImpl().getRelationshipList(id)) {
                    userIdsToFetch.add(friend);
                }
            }
            userIds = new String[userIdsToFetch.size()];
            userIds = userIdsToFetch.toArray(userIds);
        }
        HashMap<String, Map<String, String>> personDataMap = new HashMap<String, Map<String, String>>();
        for (String id : userIds) {
            try {
                Map<String, String> data = this.getAppData(id, appId, fields);
                if (data == null) {
                    return new HashMap<String, Map<String, String>>();
                }
                personDataMap.put(id, data);
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialDataException("Error while retrieving app data with id " + appId + " for user " + id, (Throwable)e);
            }
        }
        return personDataMap;
    }

    public void deletePersonData(String userId, String groupId, String appId, Set<String> fields) throws SocialDataException {
        try {
            this.registry = this.getRegistry();
            String appDataResourcePath = "/appData/" + appId + "/" + userId;
            if (this.registry.resourceExists(appDataResourcePath)) {
                Resource appDataResource = this.registry.get(appDataResourcePath);
                for (String key : fields) {
                    appDataResource.removeProperty(key);
                }
                this.registry.put(appDataResourcePath, appDataResource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while deleting app data with id " + appId + " for user " + userId, (Throwable)e);
        }
    }

    public void updatePersonData(String userId, String groupId, String appId, Set<String> fields, Map<String, String> values) throws SocialDataException {
        TreeSet<String> fieldsToDelete = new TreeSet<String>();
        for (String field : fields) {
            if (values.containsKey(field)) continue;
            fieldsToDelete.add(field);
        }
        ArrayList<String> userIdsToFetch = new ArrayList<String>();
        if ("friends".equals(groupId)) {
            String[] friendsList;
            for (String friend : friendsList = new RelationshipManagerImpl().getRelationshipList(userId)) {
                userIdsToFetch.add(friend);
            }
        } else {
            userIdsToFetch.add(userId);
        }
        for (String id : userIdsToFetch) {
            this.savePersonAppData(userId, appId, values, true);
            this.deletePersonData(userId, groupId, appId, fieldsToDelete);
        }
    }

    public void savePersonData(String userId, String appId, Map<String, String> values) throws SocialDataException {
        this.savePersonAppData(userId, appId, values, false);
    }

    private Resource getAppDataAddedRegistryResource(Resource appDataResource, Map<String, String> values, boolean isUpdate) {
        for (Map.Entry<String, String> e : values.entrySet()) {
            if (e.getValue() == null) continue;
            String oldValue = appDataResource.getProperty(e.getKey());
            if (oldValue != null) {
                appDataResource.editPropertyValue(e.getKey(), oldValue, e.getValue());
                continue;
            }
            appDataResource.addProperty(e.getKey(), e.getValue());
        }
        return appDataResource;
    }

    private void savePersonAppData(String userId, String appId, Map<String, String> values, boolean isUpdate) throws SocialDataException {
        try {
            this.registry = this.getRegistry();
            String appDataResourcePath = "/appData/" + appId + "/" + userId;
            Object appDataResource = this.registry.resourceExists(appDataResourcePath) ? this.registry.get(appDataResourcePath) : this.registry.newCollection();
            appDataResource = this.getAppDataAddedRegistryResource((Resource)appDataResource, values, isUpdate);
            this.registry.put(appDataResourcePath, (Resource)appDataResource);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving app data with id " + appId + " for user " + userId, (Throwable)e);
        }
    }

    private Map<String, String> getAppData(String userId, String appId, Set<String> fields) throws RegistryException {
        HashMap<String, String> appDataMap = new HashMap<String, String>();
        String appDataPath = "/appData/" + appId + "/" + userId;
        this.registry = this.getRegistry();
        if (this.registry.resourceExists(appDataPath)) {
            Resource appDataResource = this.registry.get(appDataPath);
            if (fields != null && fields.size() > 0) {
                for (String key : fields) {
                    String value = appDataResource.getProperty(key);
                    if (value == null) continue;
                    appDataMap.put(key, value);
                }
            } else {
                Properties props = appDataResource.getProperties();
                Enumeration<Object> propKeys = props.keys();
                while (propKeys.hasMoreElements()) {
                    String key = propKeys.nextElement().toString();
                    String propValue = props.get(key).toString();
                    appDataMap.put(key, propValue.substring(1, propValue.length() - 1));
                }
            }
        } else {
            return null;
        }
        return appDataMap;
    }
}

