/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.activityStream;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.activityStream.ActivityEntry;
import org.wso2.carbon.registry.social.api.activityStream.ActivityObject;
import org.wso2.carbon.registry.social.api.activityStream.ActivityStreamManager;
import org.wso2.carbon.registry.social.api.activityStream.MediaLink;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.impl.activityStream.ActivityEntryImpl;
import org.wso2.carbon.registry.social.impl.activityStream.ActivityObjectImpl;
import org.wso2.carbon.registry.social.impl.activityStream.MediaLinkImpl;
import org.wso2.carbon.registry.social.impl.internal.SocialDSComponent;
import org.wso2.carbon.registry.social.impl.people.relationship.RelationshipManagerImpl;
import org.wso2.carbon.registry.social.impl.utils.FilterOptionsImpl;

public class ActivityStreamManagerImpl
implements ActivityStreamManager {
    private static Log log = LogFactory.getLog(ActivityStreamManagerImpl.class);
    private Registry registry = null;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public Registry getRegistry() throws RegistryException {
        if (this.registry != null) {
            return this.registry;
        }
        return SocialDSComponent.getRegistry();
    }

    public void saveActivity(String userId, ActivityEntry activityEntry) throws SocialDataException {
        try {
            this.saveActivity(userId, activityEntry, false);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving activity for person " + userId + " with activityId " + activityEntry.getId(), (Throwable)e);
        }
    }

    public void deleteActivity(String userId, String activityId, String appId) throws SocialDataException {
        String activityResourcePath = "/users/" + userId + "/activities/" + appId + "/" + activityId;
        try {
            this.registry = this.getRegistry();
            if (!this.registry.resourceExists(activityResourcePath)) {
                throw new SocialDataException("Activity with specified activityId " + activityId + " doesn't exist");
            }
            this.registry.delete(activityResourcePath);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while deleting activity for person " + userId + " for activityId " + activityId, (Throwable)e);
        }
    }

    public ActivityEntry[] getActivityEntries(String[] userIds, String groupId, String appId, Set<String> fields, FilterOptions options) throws SocialDataException {
        String[] userIdArray;
        RelationshipManagerImpl relationshipManager = new RelationshipManagerImpl();
        ArrayList<ActivityEntry> activityList = new ArrayList<ActivityEntry>();
        ArrayList<String> userIdsToFetch = new ArrayList<String>();
        if (groupId.equals("self")) {
            userIdArray = userIds;
        } else if (groupId.equals("friends")) {
            for (String id : userIds) {
                if (relationshipManager.getRelationshipList(id) == null) continue;
                for (String friend : relationshipManager.getRelationshipList(id)) {
                    userIdsToFetch.add(friend);
                }
            }
            userIdArray = new String[userIdsToFetch.size()];
            userIdArray = userIdsToFetch.toArray(userIdArray);
        } else if (groupId.equals("all")) {
            for (String id : userIds) {
                if (relationshipManager.getRelationshipList(id) != null) {
                    for (String friend : relationshipManager.getRelationshipList(id)) {
                        userIdsToFetch.add(friend);
                    }
                }
                userIdsToFetch.add(id);
            }
            userIdArray = new String[userIdsToFetch.size()];
            userIdArray = userIdsToFetch.toArray(userIdArray);
        } else {
            return new ActivityEntryImpl[0];
        }
        for (String userId : userIdArray) {
            try {
                String[] activityResourcePaths;
                this.registry = this.getRegistry();
                String resourcePath = "/users/" + userId + "/activities/" + appId;
                if (options == null) {
                    options = new FilterOptionsImpl();
                    options.setMax(0);
                    options.setFirst(0);
                }
                if (!this.registry.resourceExists(resourcePath)) continue;
                int max = options.getMax() == 0 ? 20 : options.getMax();
                Collection activityCollection = this.registry.get(resourcePath, options.getFirst(), max);
                for (String path : activityResourcePaths = activityCollection.getChildren()) {
                    String activityId = path.substring(path.lastIndexOf("/") + 1);
                    if (activityId.equalsIgnoreCase("nextActivityId") || this.getUserActivity(userId, appId, activityId) == null) continue;
                    activityList.add(this.getUserActivity(userId, appId, activityId));
                }
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialDataException("Error while retrieving activities for user " + userId, (Throwable)e);
            }
        }
        ActivityEntryImpl[] activityEntries = new ActivityEntryImpl[activityList.size()];
        return activityList.toArray(activityEntries);
    }

    public ActivityEntry[] getActivityEntries(String userId, String groupId, String appId, Set<String> fields, FilterOptions options, String[] activityIds) throws SocialDataException {
        if (activityIds == null) {
            throw new SocialDataException("Invalid activity ids");
        }
        if (activityIds.length <= 0) {
            this.getActivityEntries(new String[]{userId}, groupId, appId, fields, options);
        }
        ActivityEntry[] activityEntries = new ActivityEntryImpl[activityIds.length];
        for (int index = 0; index < activityIds.length; ++index) {
            activityEntries[index] = this.getActivityEntry(userId, groupId, appId, fields, activityIds[index]);
        }
        return activityEntries;
    }

    public ActivityEntry getActivityEntry(String userId, String groupId, String appId, Set<String> fields, String activityId) throws SocialDataException {
        ActivityEntry userActivityEntry = null;
        if (userId == null || userId.trim().equals("") || appId == null || appId.trim().equals("") || activityId == null || activityId.trim().equals("")) {
            throw new SocialDataException("Invalid parameters provided. One or more of the parameter is either null or empty");
        }
        try {
            this.registry = this.getRegistry();
            if (groupId == null || groupId.equals("self")) {
                userActivityEntry = this.getUserActivity(userId, appId, activityId);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving activity of user " + userId + " with activityId " + activityId, (Throwable)e);
        }
        return userActivityEntry;
    }

    private ActivityEntry getUserActivity(String userId, String appId, String activityId) throws RegistryException {
        ActivityEntry userActivityEntry;
        this.registry = this.getRegistry();
        String selfActivityResourcePath = "/users/" + userId + "/activities/" + appId + "/" + activityId;
        if (this.registry.resourceExists(selfActivityResourcePath)) {
            String providerResourcePath;
            String targetResourcePath;
            String objectResourcePath;
            String generatorResourcePath;
            String actorResourcePath;
            Resource selfActivityResource = this.registry.get(selfActivityResourcePath);
            userActivityEntry = this.getPropertyAddedActivityEntry(selfActivityResource);
            String mediaLinkResourcePath = selfActivityResourcePath + "/mediaLink";
            if (this.registry.resourceExists(mediaLinkResourcePath)) {
                Resource mediaResource = this.registry.get(mediaLinkResourcePath);
                userActivityEntry.setIcon(this.getPropertyAddedMediaLink(mediaResource));
            }
            if (this.registry.resourceExists(actorResourcePath = selfActivityResourcePath + "/actor")) {
                Resource actorResource = this.registry.get(actorResourcePath);
                String actorMediaResourcePath = actorResourcePath + "/mediaLink";
                ActivityObjectImpl ackObj = new ActivityObjectImpl();
                if (this.registry.resourceExists(actorMediaResourcePath)) {
                    Resource actorMediaResource = this.registry.get(actorMediaResourcePath);
                    ackObj.setImage(this.getPropertyAddedMediaLink(actorMediaResource));
                }
                ackObj = this.getPropertyAddedActivityObject(actorResource);
                userActivityEntry.setActor((ActivityObject)ackObj);
            }
            if (this.registry.resourceExists(generatorResourcePath = selfActivityResourcePath + "/generator")) {
                Resource generatorResource = this.registry.get(generatorResourcePath);
                String generatorMediaResourcePath = generatorResourcePath + "/mediaLink";
                ActivityObjectImpl ackGenObj = new ActivityObjectImpl();
                if (this.registry.resourceExists(generatorMediaResourcePath)) {
                    Resource generatorMediaResource = this.registry.get(generatorMediaResourcePath);
                    ackGenObj.setImage(this.getPropertyAddedMediaLink(generatorMediaResource));
                }
                ackGenObj = this.getPropertyAddedActivityObject(generatorResource);
                userActivityEntry.setGenerator((ActivityObject)ackGenObj);
            }
            if (this.registry.resourceExists(objectResourcePath = selfActivityResourcePath + "/object")) {
                Resource objectResource = this.registry.get(objectResourcePath);
                String objectMediaResourcePath = objectResourcePath + "/mediaLink";
                ActivityObjectImpl ackObObj = new ActivityObjectImpl();
                if (this.registry.resourceExists(objectMediaResourcePath)) {
                    Resource objectMediaResource = this.registry.get(objectMediaResourcePath);
                    ackObObj.setImage(this.getPropertyAddedMediaLink(objectMediaResource));
                }
                ackObObj = this.getPropertyAddedActivityObject(objectResource);
                userActivityEntry.setObject((ActivityObject)ackObObj);
            }
            if (this.registry.resourceExists(targetResourcePath = selfActivityResourcePath + "/object")) {
                Resource targetResource = this.registry.get(targetResourcePath);
                String targetMediaResourcePath = targetResourcePath + "/mediaLink";
                ActivityObjectImpl acktargetObj = new ActivityObjectImpl();
                if (this.registry.resourceExists(targetMediaResourcePath)) {
                    Resource targetMediaResource = this.registry.get(targetMediaResourcePath);
                    acktargetObj.setImage(this.getPropertyAddedMediaLink(targetMediaResource));
                }
                acktargetObj = this.getPropertyAddedActivityObject(targetResource);
                userActivityEntry.setTarget((ActivityObject)acktargetObj);
            }
            if (this.registry.resourceExists(providerResourcePath = selfActivityResourcePath + "/object")) {
                Resource providerResource = this.registry.get(providerResourcePath);
                String providerMediaResourcePath = providerResourcePath + "/mediaLink";
                ActivityObjectImpl ackproviderObj = new ActivityObjectImpl();
                if (this.registry.resourceExists(providerMediaResourcePath)) {
                    Resource providerMediaResource = this.registry.get(providerMediaResourcePath);
                    ackproviderObj.setImage(this.getPropertyAddedMediaLink(providerMediaResource));
                }
                ackproviderObj = this.getPropertyAddedActivityObject(providerResource);
                userActivityEntry.setTarget((ActivityObject)ackproviderObj);
            }
        } else {
            log.error((Object)("No activity found with id " + activityId));
            return null;
        }
        return userActivityEntry;
    }

    public void deleteActivityEntries(String userId, String groupId, String appId, Set<String> activityIds) throws SocialDataException {
        for (String activityId : activityIds) {
            this.deleteActivity(userId, activityId, appId);
        }
    }

    public void updateActivityEntry(String userId, ActivityEntry activityEntry) throws SocialDataException {
        try {
            this.saveActivity(userId, activityEntry, true);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException((Throwable)e);
        }
    }

    public void createActivityEntry(String userId, String groupId, String appId, Set<String> fields, ActivityEntry activityEntry) throws SocialDataException {
        if (activityEntry == null) {
            String errorMsg = "Cannot create activity. Passed Activity argument is null";
            log.error((Object)errorMsg);
            throw new SocialDataException(errorMsg);
        }
        if (activityEntry.getPublished() == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            activityEntry.setPublished(dateFormat.format(date));
        }
        ActivityObjectImpl generator = new ActivityObjectImpl();
        generator.setDisplayName(appId);
        activityEntry.setGenerator((ActivityObject)generator);
        ActivityObjectImpl actor = new ActivityObjectImpl();
        actor.setDisplayName(userId);
        activityEntry.setActor((ActivityObject)actor);
        this.saveActivity(userId, activityEntry);
    }

    private void saveActivity(String userId, ActivityEntry activityEntry, boolean isUpdate) throws RegistryException {
        HashMap<String, String> pathVals;
        int nextActivityId;
        Resource nextActivityIdResource;
        this.registry = this.getRegistry();
        String nextActivityPath = "/users/" + userId + "/activities/" + activityEntry.getGenerator().getDisplayName() + "/nextActivityId";
        if (activityEntry.getId() == null) {
            if (this.registry.resourceExists(nextActivityPath)) {
                nextActivityIdResource = this.registry.get(nextActivityPath);
                nextActivityId = nextActivityIdResource.getProperty("nextActivityId") != null ? Integer.valueOf(nextActivityIdResource.getProperty("nextActivityId")) : 0;
            } else {
                nextActivityId = 0;
                nextActivityIdResource = this.registry.newCollection();
            }
            nextActivityIdResource.setProperty("nextActivityId", nextActivityId + 1 + "");
            this.registry.put(nextActivityPath, nextActivityIdResource);
            activityEntry.setId(nextActivityId + "");
        } else {
            boolean isIntegerId;
            nextActivityIdResource = null;
            nextActivityId = -1;
            if (this.registry.resourceExists(nextActivityPath) && (nextActivityIdResource = this.registry.get(nextActivityPath)).getProperty("nextActivityId") != null) {
                nextActivityId = Integer.valueOf(nextActivityIdResource.getProperty("nextActivityId"));
            }
            String userActivityId = activityEntry.getId();
            int userActivityIdInteger = 0;
            try {
                userActivityIdInteger = Integer.parseInt(userActivityId);
                isIntegerId = true;
            }
            catch (NumberFormatException e) {
                isIntegerId = false;
            }
            if (nextActivityId > 0 && isIntegerId && nextActivityIdResource != null && nextActivityId == userActivityIdInteger) {
                activityEntry.setId(nextActivityId + "");
                nextActivityIdResource.setProperty("nextActivityId", nextActivityId + 1 + "");
                this.registry.put(nextActivityPath, nextActivityIdResource);
            }
        }
        String newActivityPath = "/users/" + userId + "/activities/" + activityEntry.getGenerator().getDisplayName() + "/" + activityEntry.getId();
        Object newActivityResource = this.registry.resourceExists(newActivityPath) ? this.registry.get(newActivityPath) : this.registry.newCollection();
        newActivityResource = this.saveActivityEntryResourceProperties(activityEntry, (Resource)newActivityResource, isUpdate);
        this.registry.put(newActivityPath, (Resource)newActivityResource);
        if (activityEntry.getIcon() != null) {
            String resourcePath = newActivityPath + "/mediaLink";
            Object mediaResource = this.registry.resourceExists(resourcePath) ? this.registry.get(resourcePath) : this.registry.newCollection();
            this.saveMediaLinkResourceProperties(activityEntry.getIcon(), (Resource)mediaResource, isUpdate);
            this.registry.put(resourcePath, (Resource)mediaResource);
        }
        if (activityEntry.getActor() != null) {
            pathVals = new HashMap<String, String>();
            pathVals.put("activityPath", newActivityPath);
            pathVals.put("registryObjectPath", "/actor");
            this.saveActivityObjectResourceProperties(activityEntry.getActor(), pathVals, isUpdate);
        }
        if (activityEntry.getGenerator() != null) {
            pathVals = new HashMap();
            pathVals.put("activityPath", newActivityPath);
            pathVals.put("registryObjectPath", "/generator");
            this.saveActivityObjectResourceProperties(activityEntry.getGenerator(), pathVals, isUpdate);
        }
        if (activityEntry.getObject() != null) {
            pathVals = new HashMap();
            pathVals.put("activityPath", newActivityPath);
            pathVals.put("registryObjectPath", "/object");
            this.saveActivityObjectResourceProperties(activityEntry.getObject(), pathVals, isUpdate);
        }
        if (activityEntry.getTarget() != null) {
            pathVals = new HashMap();
            pathVals.put("activityPath", newActivityPath);
            pathVals.put("registryObjectPath", "/generator");
            this.saveActivityObjectResourceProperties(activityEntry.getTarget(), pathVals, isUpdate);
        }
        if (activityEntry.getProvider() != null) {
            pathVals = new HashMap();
            pathVals.put("activityPath", newActivityPath);
            pathVals.put("registryObjectPath", "/generator");
            this.saveActivityObjectResourceProperties(activityEntry.getProvider(), pathVals, isUpdate);
        }
    }

    private ActivityEntry getPropertyAddedActivityEntry(Resource activityResource) {
        Date updateDate;
        SimpleDateFormat dateFormat;
        ActivityEntryImpl activityEntry = new ActivityEntryImpl();
        String value = activityResource.getProperty("id");
        if (value != null) {
            activityEntry.setId(value);
        }
        if ((value = activityResource.getProperty("url")) != null) {
            activityEntry.setUrl(value);
        }
        if ((value = activityResource.getProperty("verb")) != null) {
            activityEntry.setVerb(value);
        }
        if ((value = activityResource.getProperty("title")) != null) {
            activityEntry.setTitle(value);
        }
        if ((value = activityResource.getProperty("published")) != null) {
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            updateDate = new Date(value);
            activityEntry.setPublished(dateFormat.format(updateDate));
        }
        if ((value = activityResource.getProperty("content")) != null) {
            activityEntry.setContent(value);
        }
        if ((value = activityResource.getProperty("updated")) != null) {
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            updateDate = new Date(value);
            activityEntry.setUpdated(dateFormat.format(updateDate));
        }
        return activityEntry;
    }

    private Resource saveActivityEntryResourceProperties(ActivityEntry userActivity, Resource activityResource, boolean isUpdate) {
        if (userActivity == null || activityResource == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (userActivity.getId() != null) {
            properties.put("id", userActivity.getId());
        }
        if (userActivity.getContent() != null) {
            properties.put("content", userActivity.getContent());
        }
        if (userActivity.getPublished() != null) {
            properties.put("published", userActivity.getPublished());
        }
        if (userActivity.getTitle() != null) {
            properties.put("title", userActivity.getTitle());
        }
        if (userActivity.getUpdated() != null) {
            properties.put("updated", userActivity.getUpdated());
        }
        if (userActivity.getUrl() != null) {
            properties.put("url", userActivity.getUrl());
        }
        if (userActivity.getVerb() != null) {
            properties.put("verb", userActivity.getVerb());
        }
        this.attachPropertyToResource(activityResource, properties, isUpdate);
        return activityResource;
    }

    private void attachPropertyToResource(Resource activityResource, Map<String, String> properties, boolean isUpdate) {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (e.getValue() == null) continue;
            if (isUpdate) {
                String oldValue = activityResource.getProperty(e.getKey());
                activityResource.editPropertyValue(e.getKey(), oldValue, e.getValue());
                continue;
            }
            activityResource.addProperty(e.getKey(), e.getValue());
        }
    }

    private ActivityObject getPropertyAddedActivityObject(Resource objResource) {
        ActivityObjectImpl actObject = new ActivityObjectImpl();
        if (objResource == null) {
            return null;
        }
        String value = objResource.getProperty("content");
        if (value != null) {
            actObject.setContent(value);
        }
        if ((value = objResource.getProperty("displayName")) != null) {
            actObject.setDisplayName(value);
        }
        if ((value = objResource.getProperty("id")) != null) {
            actObject.setId(value);
        }
        if ((value = objResource.getProperty("url")) != null) {
            actObject.setUrl(value);
        }
        if ((value = objResource.getProperty("summary")) != null) {
            actObject.setSummary(value);
        }
        if ((value = objResource.getProperty("updated")) != null) {
            actObject.setUpdated(value);
        }
        if ((value = objResource.getProperty("objectType")) != null) {
            actObject.setObjectType(value);
        }
        if ((value = objResource.getProperty("published")) != null) {
            actObject.setPublished(value);
        }
        return actObject;
    }

    private MediaLink getPropertyAddedMediaLink(Resource mediaLinkResource) {
        MediaLinkImpl mLink = new MediaLinkImpl();
        if (mediaLinkResource == null) {
            return null;
        }
        String value = mediaLinkResource.getProperty("url");
        if (value != null) {
            mLink.setUrl(value);
        }
        if ((value = mediaLinkResource.getProperty("duration")) != null) {
            mLink.setDuration(Integer.valueOf(value));
        }
        if ((value = mediaLinkResource.getProperty("height")) != null) {
            mLink.setHeight(Integer.valueOf(value));
        }
        if ((value = mediaLinkResource.getProperty("width")) != null) {
            mLink.setWidth(Integer.valueOf(value));
        }
        return mLink;
    }

    public ActivityEntry[] getSortedActivityEntries(String[] userIds, String groupId, String appId, Set<String> fields, FilterOptions options) throws SocialDataException {
        ActivityEntry[] activities = this.getActivityEntries(userIds, groupId, appId, fields, options);
        Arrays.sort(activities, new ActivityEntryComparator());
        return activities;
    }

    private Resource saveMediaLinkResourceProperties(MediaLink activityMediaLink, Resource mediaItemResource, boolean isUpdate) {
        if (mediaItemResource == null || activityMediaLink == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (activityMediaLink.getUrl() != null) {
            properties.put("mimeType", activityMediaLink.getUrl());
        }
        if (activityMediaLink.getWidth() != null) {
            properties.put("type", activityMediaLink.getWidth().toString());
        }
        if (activityMediaLink.getHeight() != null) {
            properties.put("thumbnailUrl", activityMediaLink.getHeight().toString());
        }
        if (activityMediaLink.getDuration() != null) {
            properties.put("url", activityMediaLink.getDuration().toString());
        }
        this.attachPropertyToResource(mediaItemResource, properties, isUpdate);
        return mediaItemResource;
    }

    private void saveActivityObjectResourceProperties(ActivityObject actObject, HashMap<String, String> pathVals, boolean isUpdate) {
        String activityPath = pathVals.get("activityPath");
        String registryObjectPath = pathVals.get("registryObjectPath");
        String registryMediaPath = "/mediaLink";
        String resourceObjectPath = activityPath + registryObjectPath;
        try {
            Object objectResource = this.registry.resourceExists(resourceObjectPath) ? this.registry.get(resourceObjectPath) : this.registry.newCollection();
            this.saveActivityObjectProperties(actObject, (Resource)objectResource, isUpdate);
            this.registry.put(resourceObjectPath, (Resource)objectResource);
            if (actObject.getImage() != null) {
                String resourceActorMediaPath = resourceObjectPath + registryMediaPath;
                Object objectMediaResource = this.registry.resourceExists(resourceActorMediaPath) ? this.registry.get(resourceActorMediaPath) : this.registry.newCollection();
                this.saveMediaLinkResourceProperties(actObject.getImage(), (Resource)objectMediaResource, isUpdate);
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Exception occured in registry" + e.getMessage()));
        }
    }

    private Resource saveActivityObjectProperties(ActivityObject activityObject, Resource mediaItemResource, boolean isUpdate) {
        if (mediaItemResource == null || activityObject == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (activityObject.getUrl() != null) {
            properties.put("url", activityObject.getUrl());
        }
        if (activityObject.getDisplayName() != null) {
            properties.put("displayName", activityObject.getDisplayName());
        }
        if (activityObject.getId() != null) {
            properties.put("id", activityObject.getId());
        }
        if (activityObject.getContent() != null) {
            properties.put("content", activityObject.getContent());
        }
        if (activityObject.getObjectType() != null) {
            properties.put("objectType", activityObject.getObjectType());
        }
        if (activityObject.getPublished() != null) {
            properties.put("published", activityObject.getPublished());
        }
        if (activityObject.getSummary() != null) {
            properties.put("summary", activityObject.getSummary());
        }
        if (activityObject.getUpdated() != null) {
            properties.put("updated", activityObject.getUpdated());
        }
        this.attachPropertyToResource(mediaItemResource, properties, isUpdate);
        return mediaItemResource;
    }

    static class ActivityEntryComparator
    implements Comparator<ActivityEntry>,
    Serializable {
        ActivityEntryComparator() {
        }

        @Override
        public int compare(ActivityEntry activity1, ActivityEntry activity2) {
            if (activity1.getPublished() == null && activity2.getPublished() == null) {
                return 0;
            }
            if (activity1.getPublished() == null) {
                return -1;
            }
            if (activity2.getPublished() == null) {
                return 1;
            }
            return activity1.getPublished().compareTo(activity2.getPublished());
        }
    }
}

