/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.people.userprofile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.people.PersonManager;
import org.wso2.carbon.registry.social.api.people.userprofile.Person;
import org.wso2.carbon.registry.social.api.people.userprofile.model.Address;
import org.wso2.carbon.registry.social.api.people.userprofile.model.GroupId;
import org.wso2.carbon.registry.social.api.people.userprofile.model.ListField;
import org.wso2.carbon.registry.social.api.people.userprofile.model.LookingFor;
import org.wso2.carbon.registry.social.api.people.userprofile.model.Organization;
import org.wso2.carbon.registry.social.api.people.userprofile.model.Url;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.impl.internal.SocialDSComponent;
import org.wso2.carbon.registry.social.impl.people.relationship.RelationshipManagerImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.PersonImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.impl.AddressImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.impl.ListFieldImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.impl.NameImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.impl.OrganizationImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.impl.UrlImpl;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;

public class PersonManagerImpl
implements PersonManager {
    private static Log log = LogFactory.getLog(PersonManagerImpl.class);
    private UserStoreManager userStoreManager = null;
    private ClaimManager claimManager = null;

    public void setUserStoreManager(UserStoreManager userStoreManager) {
        this.userStoreManager = userStoreManager;
    }

    public UserStoreManager getUserStoreManager() throws RegistryException, UserStoreException {
        if (this.userStoreManager != null) {
            return this.userStoreManager;
        }
        return SocialDSComponent.getUserStoreManager();
    }

    public void setClaimManager(ClaimManager claimManager) {
        this.claimManager = claimManager;
    }

    public ClaimManager getClaimManager() throws RegistryException, UserStoreException {
        if (this.claimManager != null) {
            return this.claimManager;
        }
        return SocialDSComponent.getClaimManager();
    }

    public boolean savePerson(String userId, Person person) throws SocialDataException {
        try {
            this.userStoreManager = this.getUserStoreManager();
            if (!this.userStoreManager.isExistingUser(userId)) {
                // empty if block
            }
            this.userStoreManager.setUserClaimValues(userId, this.retrieveClaimValues(person), null);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving person with id " + userId, (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving person with id " + userId, (Throwable)e);
        }
        return true;
    }

    public void saveUserClaims(String userId, Map<String, String> claims) throws SocialDataException {
        try {
            this.userStoreManager = this.getUserStoreManager();
            if (!this.userStoreManager.isExistingUser(userId)) {
                throw new SocialDataException("No user existing with id " + userId);
            }
            this.userStoreManager.setUserClaimValues(userId, claims, null);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving person with id " + userId, (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving person with id " + userId, (Throwable)e);
        }
    }

    public boolean updatePerson(String userId, Person person) throws SocialDataException {
        return this.savePerson(userId, person);
    }

    public boolean removePerson(String userId) throws SocialDataException {
        try {
            this.userStoreManager = this.getUserStoreManager();
            this.userStoreManager.deleteUser(userId);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while removing person with id " + userId, (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while removing person with id " + userId, (Throwable)e);
        }
        return true;
    }

    public Person getPerson(String userId) throws SocialDataException {
        Person personObj;
        try {
            this.userStoreManager = this.getUserStoreManager();
            this.claimManager = this.getClaimManager();
            if (!this.userStoreManager.isExistingUser(userId)) {
                log.error((Object)("No user found for the id " + userId));
                return null;
            }
            String[] claims = this.claimManager.getAllClaimUris();
            Map userClaims = this.userStoreManager.getUserClaimValues(userId, claims, null);
            personObj = this.getPersonWithClaims(userClaims, userId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving data for person " + userId, (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving data for person " + userId, (Throwable)e);
        }
        return personObj;
    }

    public Person[] getPeople(String[] userIds, String groupId, FilterOptions filterOptions, String[] fields) throws SocialDataException {
        ArrayList<Object> userIdsToFetch = new ArrayList();
        if (groupId.equalsIgnoreCase("self")) {
            userIdsToFetch = new ArrayList<String>(Arrays.asList(userIds));
        } else if (groupId.equalsIgnoreCase("friends")) {
            RelationshipManagerImpl relationshipManager = new RelationshipManagerImpl();
            for (String string : userIds) {
                for (String id : relationshipManager.getRelationshipList(string)) {
                    userIdsToFetch.add(id);
                }
            }
        } else if (groupId.equalsIgnoreCase(GroupId.Type.all.toString())) {
            try {
                this.userStoreManager = this.getUserStoreManager();
                String[] userList = this.userStoreManager.listUsers("*", 20);
                userIdsToFetch = new ArrayList<String>(Arrays.asList(userList));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialDataException("Error while retrieving user list", (Throwable)e);
            }
        }
        Person[] peopleArray = new Person[userIdsToFetch.size()];
        int index = 0;
        for (String string : userIdsToFetch) {
            peopleArray[index++] = this.getPerson(string, fields);
        }
        return peopleArray;
    }

    public Person getPerson(String userId, String[] fields) throws SocialDataException {
        Person personObj;
        try {
            this.userStoreManager = this.getUserStoreManager();
            if (!this.userStoreManager.isExistingUser(userId)) {
                return null;
            }
            String[] socialFields = this.getPersonSocialFields(fields);
            Map userClaims = this.userStoreManager.getUserClaimValues(userId, socialFields, null);
            personObj = this.getPersonWithClaims(userClaims, userId);
            if (personObj != null && personObj.getDisplayName() == null) {
                personObj.setDisplayName(userId);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving data for person " + userId, (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving data for person " + userId, (Throwable)e);
        }
        return personObj;
    }

    private Map<String, String> retrieveClaimValues(Person person) {
        HashMap<String, String> claimValues = new HashMap<String, String>();
        if (person.getDisplayName() != null) {
            claimValues.put("http://wso2.org/claims/displayname", person.getDisplayName());
        }
        if (person.getName() != null && person.getName().getGivenName() != null) {
            claimValues.put("http://wso2.org/claims/givenname", person.getName().getGivenName());
        }
        if (person.getName() != null && person.getName().getFamilyName() != null) {
            claimValues.put("http://wso2.org/claims/lastname", person.getName().getFamilyName());
        }
        if (person.getNickname() != null) {
            claimValues.put("http://wso2.org/claims/nickname", person.getNickname());
        }
        if (person.getOrganizations() != null && person.getOrganizations().get(0) != null && ((Organization)person.getOrganizations().get(0)).getName() != null) {
            claimValues.put("http://wso2.org/claims/organization", ((Organization)person.getOrganizations().get(0)).getName());
        }
        if (person.getAddresses() != null && person.getAddresses().get(0) != null) {
            if (((Address)person.getAddresses().get(0)).getStreetAddress() != null) {
                claimValues.put("http://wso2.org/claims/streetaddress", ((Address)person.getAddresses().get(0)).getStreetAddress());
            }
            if (((Address)person.getAddresses().get(0)).getRegion() != null) {
                claimValues.put("http://wso2.org/claims/region", ((Address)person.getAddresses().get(0)).getRegion());
            }
            if (((Address)person.getAddresses().get(0)).getCountry() != null) {
                claimValues.put("http://wso2.org/claims/country", ((Address)person.getAddresses().get(0)).getCountry());
            }
            if (((Address)person.getAddresses().get(0)).getLatitude() != null) {
                claimValues.put("http://wso2.org/claims/latitude", ((Address)person.getAddresses().get(0)).getLatitude().toString());
            }
            if (((Address)person.getAddresses().get(0)).getLongitude() != null) {
                claimValues.put("http://wso2.org/claims/longitude", ((Address)person.getAddresses().get(0)).getLongitude().toString());
            }
            if (((Address)person.getAddresses().get(0)).getPostalCode() != null) {
                claimValues.put("http://wso2.org/claims/postalcode", ((Address)person.getAddresses().get(0)).getPostalCode());
            }
        }
        if (person.getEmails() != null && person.getEmails().get(0) != null && ((ListField)person.getEmails().get(0)).getValue() != null) {
            claimValues.put("http://wso2.org/claims/emailaddress", ((ListField)person.getEmails().get(0)).getValue());
        }
        if (person.getPhoneNumbers() != null && person.getPhoneNumbers().get(0) != null && ((ListField)person.getPhoneNumbers().get(0)).getValue() != null) {
            claimValues.put("http://wso2.org/claims/telephone", ((ListField)person.getPhoneNumbers().get(0)).getValue());
        }
        if (person.getIms() != null && person.getIms().get(0) != null && ((ListField)person.getIms().get(0)).getValue() != null) {
            claimValues.put("http://wso2.org/claims/im", ((ListField)person.getIms().get(0)).getValue());
        }
        if (person.getUrls() != null && person.getUrls().get(0) != null && ((Url)person.getUrls().get(0)).getValue() != null) {
            claimValues.put("http://wso2.org/claims/url", ((Url)person.getUrls().get(0)).getValue());
        }
        if (person.getAboutMe() != null) {
            claimValues.put("http://wso2.org/claims/aboutme", person.getAboutMe());
        }
        if (person.getBirthday() != null && person.getBirthday().getTime() > 0L) {
            claimValues.put("http://wso2.org/claims/birthday", person.getBirthday().getTime() + "");
        }
        if (person.getRelationshipStatus() != null) {
            claimValues.put("http://wso2.org/claims/relationshipstatus", person.getRelationshipStatus());
        }
        if (person.getReligion() != null) {
            claimValues.put("http://wso2.org/claims/religion", person.getReligion());
        }
        if (person.getEthnicity() != null) {
            claimValues.put("http://wso2.org/claims/ethnicity", person.getEthnicity());
        }
        if (person.getGender() != null && person.getGender().name() != null) {
            claimValues.put("http://wso2.org/claims/gender", person.getGender().name());
        }
        if (person.getPoliticalViews() != null) {
            claimValues.put("http://wso2.org/claims/politicalviews", person.getPoliticalViews());
        }
        if (person.getInterests() != null && person.getInterests().get(0) != null) {
            claimValues.put("http://wso2.org/claims/interests", (String)person.getInterests().get(0));
        }
        if (person.getBooks() != null && person.getBooks().get(0) != null) {
            claimValues.put("http://wso2.org/claims/books", (String)person.getBooks().get(0));
        }
        if (person.getJobInterests() != null) {
            claimValues.put("http://wso2.org/claims/jobInterests", person.getJobInterests());
        }
        if (person.getLanguagesSpoken() != null && person.getLanguagesSpoken().get(0) != null) {
            claimValues.put("http://wso2.org/claims/languagespoken", (String)person.getLanguagesSpoken().get(0));
        }
        if (person.getLookingFor() != null && person.getLookingFor().get(0) != null && ((Enum)person.getLookingFor().get(0)).name() != null) {
            claimValues.put("http://wso2.org/claims/lookingfor", ((Enum)person.getLookingFor().get(0)).name());
        }
        if (person.getMovies() != null && person.getMovies().get(0) != null) {
            claimValues.put("http://wso2.org/claims/movies", (String)person.getMovies().get(0));
        }
        if (person.getMusic() != null && person.getMusic().get(0) != null) {
            claimValues.put("http://wso2.org/claims/music", (String)person.getMusic().get(0));
        }
        if (person.getQuotes() != null && person.getQuotes().get(0) != null) {
            claimValues.put("http://wso2.org/claims/quotes", (String)person.getQuotes().get(0));
        }
        if (person.getHappiestWhen() != null) {
            claimValues.put("http://wso2.org/claims/happiestwhen", person.getHappiestWhen());
        }
        return claimValues;
    }

    private Person getPersonWithClaims(Map<String, String> claimValues, String userId) {
        String displayName = claimValues.get("http://wso2.org/claims/displayname");
        NameImpl userName = new NameImpl();
        userName.setGivenName(claimValues.get("http://wso2.org/claims/givenname"));
        userName.setFamilyName(claimValues.get("http://wso2.org/claims/lastname"));
        PersonImpl person = new PersonImpl(userId, displayName, userName);
        String value = claimValues.get("http://wso2.org/claims/nickname");
        if (value != null) {
            person.setNickname(value);
        }
        OrganizationImpl org = new OrganizationImpl();
        value = claimValues.get("http://wso2.org/claims/organization");
        if (value != null) {
            org.setName(value);
        }
        ArrayList<OrganizationImpl> orgsList = new ArrayList<OrganizationImpl>();
        orgsList.add(org);
        person.setOrganizations(orgsList);
        AddressImpl address = new AddressImpl();
        value = claimValues.get("http://wso2.org/claims/streetaddress");
        if (value != null) {
            address.setStreetAddress(value);
        }
        if ((value = claimValues.get("http://wso2.org/claims/region")) != null) {
            address.setRegion(value);
        }
        if ((value = claimValues.get("http://wso2.org/claims/country")) != null) {
            address.setCountry(value);
        }
        if ((value = claimValues.get("http://wso2.org/claims/latitude")) != null) {
            address.setLatitude(Float.valueOf(value));
        }
        if ((value = claimValues.get("http://wso2.org/claims/longitude")) != null) {
            address.setLongitude(Float.valueOf(value));
        }
        if ((value = claimValues.get("http://wso2.org/claims/postalcode")) != null) {
            address.setPostalCode(value);
        }
        ArrayList<AddressImpl> addressList = new ArrayList<AddressImpl>();
        addressList.add(address);
        person.setAddresses(addressList);
        ArrayList<ListFieldImpl> emailList = new ArrayList<ListFieldImpl>();
        ListFieldImpl email = new ListFieldImpl();
        value = claimValues.get("http://wso2.org/claims/emailaddress");
        if (value != null) {
            email.setValue(value);
        }
        emailList.add(email);
        person.setEmails(emailList);
        ArrayList<ListFieldImpl> phoneNumberList = new ArrayList<ListFieldImpl>();
        ListFieldImpl phoneNumber = new ListFieldImpl();
        value = claimValues.get("http://wso2.org/claims/telephone");
        if (value != null) {
            phoneNumber.setValue(value);
        }
        phoneNumberList.add(phoneNumber);
        person.setPhoneNumbers(phoneNumberList);
        ArrayList<ListFieldImpl> imList = new ArrayList<ListFieldImpl>();
        ListFieldImpl im = new ListFieldImpl();
        value = claimValues.get("http://wso2.org/claims/im");
        if (value != null) {
            im.setValue(value);
        }
        imList.add(im);
        person.setIms(imList);
        ArrayList<UrlImpl> urlList = new ArrayList<UrlImpl>();
        UrlImpl url = new UrlImpl();
        value = claimValues.get("http://wso2.org/claims/url");
        if (value != null) {
            url.setValue(value);
        }
        urlList.add(url);
        person.setUrls(urlList);
        value = claimValues.get("http://wso2.org/claims/aboutme");
        if (value != null) {
            person.setAboutMe(value);
        }
        Date birthday = new Date();
        value = claimValues.get("http://wso2.org/claims/birthday");
        if (value != null) {
            birthday.setTime(Long.valueOf(value));
        }
        person.setBirthday(birthday);
        value = claimValues.get("http://wso2.org/claims/relationshipstatus");
        if (value != null) {
            person.setRelationshipStatus(value);
        }
        if ((value = claimValues.get("http://wso2.org/claims/religion")) != null) {
            person.setReligion(value);
        }
        if ((value = claimValues.get("http://wso2.org/claims/ethnicity")) != null) {
            person.setEthnicity(value);
        }
        if ((value = claimValues.get("http://wso2.org/claims/gender")) != null) {
            person.setGender(Person.Gender.valueOf((String)value));
        }
        if ((value = claimValues.get("http://wso2.org/claims/politicalviews")) != null) {
            person.setPoliticalViews(value);
        }
        ArrayList<String> interest = new ArrayList<String>();
        value = claimValues.get("http://wso2.org/claims/interests");
        if (value != null) {
            interest.add(value);
        }
        person.setInterests(interest);
        ArrayList<String> books = new ArrayList<String>();
        value = claimValues.get("http://wso2.org/claims/books");
        if (value != null) {
            books.add(value);
        }
        person.setBooks(books);
        person.setJobInterests(claimValues.get("http://wso2.org/claims/jobInterests"));
        ArrayList<String> languageSpoken = new ArrayList<String>();
        value = claimValues.get("http://wso2.org/claims/languagespoken");
        if (value != null) {
            languageSpoken.add(value);
        }
        person.setLanguagesSpoken(languageSpoken);
        ArrayList<String> movieList = new ArrayList<String>();
        value = claimValues.get("http://wso2.org/claims/movies");
        if (value != null) {
            movieList.add(value);
        }
        person.setMovies(movieList);
        ArrayList<String> musicList = new ArrayList<String>();
        value = claimValues.get("http://wso2.org/claims/music");
        if (value != null) {
            musicList.add(value);
        }
        person.setMusic(musicList);
        ArrayList<String> quotesList = new ArrayList<String>();
        value = claimValues.get("http://wso2.org/claims/quotes");
        if (value != null) {
            quotesList.add(value);
        }
        person.setQuotes(quotesList);
        person.setHappiestWhen(claimValues.get("http://wso2.org/claims/happiestwhen"));
        ArrayList<LookingFor> lookingFor = new ArrayList<LookingFor>();
        value = claimValues.get("http://wso2.org/claims/lookingfor");
        if (value != null) {
            lookingFor.add(LookingFor.valueOf((String)value));
        }
        person.setLookingFor(lookingFor);
        return person;
    }

    private String[] getPersonSocialFields(String[] fields) {
        ArrayList<String> socialFields = new ArrayList<String>();
        for (String field : fields) {
            if ("DISPLAY_NAME".equalsIgnoreCase(field = field.trim())) {
                socialFields.add("http://wso2.org/claims/displayname");
            } else if ("NAME".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/givenname");
                socialFields.add("http://wso2.org/claims/lastname");
            } else if ("NICKNAME".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/nickname");
            } else if ("ADDRESSES".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/streetaddress");
                socialFields.add("http://wso2.org/claims/region");
                socialFields.add("http://wso2.org/claims/country");
                socialFields.add("http://wso2.org/claims/longitude");
                socialFields.add("http://wso2.org/claims/latitude");
                socialFields.add("http://wso2.org/claims/postalcode");
            } else if ("ABOUT_ME".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/aboutme");
            } else if ("BIRTHDAY".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/birthday");
            } else if ("EMAILS".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/emailaddress");
            } else if ("ETHNICITY".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/ethnicity");
            } else if ("HAPPIEST_WHEN".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/happiestwhen");
            } else if ("IM".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/im");
            } else if ("INTERESTS".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/interests");
            } else if ("JOB_INTERESTS".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/jobInterests");
            } else if ("LANGUAGE_SPOKEN".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/languagespoken");
            } else if ("LOOKING_FOR".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/lookingfor");
            } else if ("MUSIC".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/music");
            } else if ("MOVIES".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/movies");
            } else if ("QUOTES".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/quotes");
            } else if ("POLITICAL_VIEW".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/politicalviews");
            } else if ("GENDER".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/gender");
            } else if ("RELATIONSHIP_STATUS".equalsIgnoreCase(field)) {
                socialFields.add("http://wso2.org/claims/relationshipstatus");
            } else if ("RELIGION".equals(field)) {
                socialFields.add("http://wso2.org/claims/religion");
            } else if ("PHONE_NUMBERS".equals(field)) {
                socialFields.add("http://wso2.org/claims/telephone");
            } else if ("BOOKS".equals(field)) {
                socialFields.add("http://wso2.org/claims/books");
            }
            socialFields.add("http://wso2.org/claims/displayname");
        }
        return socialFields.toArray(new String[socialFields.size()]);
    }

    public Claim[] getOrderedUserClaimInfo() throws SocialDataException {
        Claim[] userClaims;
        try {
            this.claimManager = this.getClaimManager();
            userClaims = (Claim[])this.claimManager.getAllSupportClaimsByDefault();
            Arrays.sort(userClaims, new UserClaimComparator());
            String[][] claimInfo = new String[2][userClaims.length];
            int index = 0;
            for (Claim claim : userClaims) {
                claimInfo[0][index] = claim.getClaimUri();
                claimInfo[1][index++] = claim.getDisplayTag();
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving claims", (Throwable)e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving claims", (Throwable)e);
        }
        return userClaims;
    }

    public String getDisplayName(String userId) throws SocialDataException {
        if (userId == null || userId.trim().equals("")) {
            return null;
        }
        Person person = this.getPerson(userId);
        return person.getDisplayName();
    }

    public String[][] getUserList(String filter, int maxItemLimit) throws SocialDataException {
        String[][] userList = new String[0][0];
        try {
            this.userStoreManager = this.getUserStoreManager();
            String[] userIdList = this.userStoreManager.listUsers(filter, maxItemLimit);
            if (userIdList != null) {
                userList = new String[2][userIdList.length];
                int index = 0;
                String[] arr$ = userIdList;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String userId;
                    userList[0][index] = userId = arr$[i$];
                    userList[1][index++] = this.getDisplayName(userId) != null ? this.getDisplayName(userId) : userId;
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving user-list", (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving user-list", (Throwable)e);
        }
        return userList;
    }

    static class UserClaimComparator
    implements Comparator<Claim>,
    Serializable {
        UserClaimComparator() {
        }

        @Override
        public int compare(Claim claim1, Claim claim2) {
            if (claim1.getDisplayOrder() == 0) {
                claim1.setDisplayOrder(Integer.MAX_VALUE);
            }
            if (claim2.getDisplayOrder() == 0) {
                claim2.setDisplayOrder(Integer.MAX_VALUE);
            }
            if (claim1.getDisplayOrder() < claim2.getDisplayOrder()) {
                return -1;
            }
            if (claim1.getDisplayOrder() == claim2.getDisplayOrder()) {
                return 0;
            }
            if (claim1.getDisplayOrder() > claim2.getDisplayOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

