/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.social.api.SocialMessageException;
import org.wso2.carbon.registry.social.api.message.Message;
import org.wso2.carbon.registry.social.api.message.MessageCollection;
import org.wso2.carbon.registry.social.api.message.MessageManager;
import org.wso2.carbon.registry.social.api.people.userprofile.model.Url;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.impl.internal.SocialDSComponent;
import org.wso2.carbon.registry.social.impl.message.MessageCollectionImpl;
import org.wso2.carbon.registry.social.impl.message.MessageImpl;
import org.wso2.carbon.registry.social.impl.people.userprofile.model.impl.UrlImpl;

public class MessageManagerImpl
implements MessageManager {
    private Registry registry = null;
    private static Log log = LogFactory.getLog(MessageManagerImpl.class);

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public Registry getRegistry() throws RegistryException {
        if (this.registry != null) {
            return this.registry;
        }
        return SocialDSComponent.getRegistry();
    }

    public MessageCollection[] getMessageCollections(String userId, Set<String> fields, FilterOptions options) throws SocialMessageException {
        Object resultArray;
        block4: {
            resultArray = new MessageCollectionImpl[]{};
            String messageCollectionPath = "/users/" + userId + "/messages";
            try {
                this.registry = this.getRegistry();
                if (this.registry.resourceExists(messageCollectionPath)) {
                    Collection messageCollections = options != null && options.getMax() > 0 ? this.registry.get(messageCollectionPath, options.getFirst(), options.getMax()) : this.registry.get(messageCollectionPath, 0, 20);
                    String[] childResourcePath = messageCollections.getChildren();
                    ArrayList<MessageCollection> resultList = new ArrayList<MessageCollection>();
                    for (String path : childResourcePath) {
                        if (!this.registry.resourceExists(path)) continue;
                        resultList.add(this.getPropertiesAddedMessageCollectionObj(this.registry.get(path), fields));
                    }
                    resultArray = resultList.size() > 0 ? (MessageCollection[])resultList.toArray((T[])resultArray) : null;
                    break block4;
                }
                throw new SocialMessageException("No MessageCollection exists for user " + userId);
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialMessageException("Error while retrieving message collections for user " + userId, (Throwable)e);
            }
        }
        return resultArray;
    }

    public void createMessageCollection(String userId, MessageCollection msgCollection, String messageCollectionId) throws SocialMessageException {
        if (messageCollectionId == null || userId == null || msgCollection == null) {
            throw new SocialMessageException("Invalid parameters to create a message collection");
        }
        try {
            this.saveMessageCollection(userId, messageCollectionId, msgCollection, false);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while creating message collection with id " + messageCollectionId + " for user " + userId, (Throwable)e);
        }
    }

    public void deleteMessageCollection(String userId, String messageCollectionId) throws SocialMessageException {
        try {
            this.registry = this.getRegistry();
            String msgCollectionPath = "/users/" + userId + "/messages" + "/" + messageCollectionId;
            if (!this.registry.resourceExists(msgCollectionPath)) {
                throw new SocialMessageException("Message Collection doesn't exist with id " + messageCollectionId);
            }
            this.registry.delete(msgCollectionPath);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while deleting message collection with id " + messageCollectionId + " for user " + userId, (Throwable)e);
        }
    }

    public void modifyMessageCollection(String userId, MessageCollection msgCollection, String messageCollectionId) throws SocialMessageException {
        try {
            this.saveMessageCollection(userId, messageCollectionId, msgCollection, true);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while modifying message collection with id " + messageCollectionId + " for user " + userId, (Throwable)e);
        }
    }

    public Message[] getMessages(String userId, String msgCollectionId, Set<String> fields, List<String> msgIds, FilterOptions options) throws SocialMessageException {
        Message[] messages;
        if (userId == null || msgCollectionId == null || msgIds == null) {
            throw new SocialMessageException("Invalid input parameters to retrieve message");
        }
        ArrayList<Message> messagesList = new ArrayList<Message>();
        try {
            this.registry = this.getRegistry();
            for (String id : msgIds) {
                String messageResourcePath = "/users/" + userId + "/messages" + "/" + msgCollectionId + "/" + id;
                if (this.registry.resourceExists(messageResourcePath)) {
                    Resource messageResource = this.registry.get(messageResourcePath);
                    messagesList.add(this.getPropertiesAddedMessageOjb(messageResource, fields));
                    continue;
                }
                log.error((Object)("Message with specified messageId " + id + " is not found"));
            }
            if (messagesList.size() <= 0) {
                log.error((Object)("No messages found for the user " + userId));
                return null;
            }
            messages = new Message[messagesList.size()];
            messages = messagesList.toArray(messages);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while retrieving messages for user " + userId, (Throwable)e);
        }
        return messages;
    }

    public void createMessage(String userId, String msgCollectionId, Message message) throws SocialMessageException {
        if (msgCollectionId == null || userId == null || message == null) {
            throw new SocialMessageException("Invalid parameters to create a message");
        }
        try {
            this.saveMessage(userId, null, msgCollectionId, message.getId(), message, false);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while creating message from message collection with id " + msgCollectionId + " for user " + userId, (Throwable)e);
        }
    }

    public void createMessage(String userId, String appId, String msgCollectionId, Message message) throws SocialMessageException {
        if (msgCollectionId == null || userId == null || message == null) {
            throw new SocialMessageException("Invalid parameters to create a message");
        }
        try {
            this.saveMessage(userId, appId, msgCollectionId, message.getId(), message, false);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while creating message from message collection with id " + msgCollectionId + " for user " + userId, (Throwable)e);
        }
    }

    public void deleteMessages(String userId, String msgCollectionId, List<String> messageIds) throws SocialMessageException {
        String messagePath = "/users/" + userId + "/messages" + "/" + msgCollectionId;
        try {
            this.registry = this.getRegistry();
            for (String id : messageIds) {
                String fullMessagePath = messagePath + "/" + id;
                if (this.registry.resourceExists(fullMessagePath)) {
                    this.registry.delete(fullMessagePath);
                    continue;
                }
                throw new SocialMessageException("No message found with specified messageId " + id);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while deleting message from message collection with id " + msgCollectionId + " for user " + userId, (Throwable)e);
        }
    }

    public void modifyMessage(String userId, String msgCollId, String messageId, Message message) throws SocialMessageException {
        try {
            this.saveMessage(userId, null, msgCollId, message.getId(), message, true);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialMessageException("Error while modifying message with id " + messageId + " for user " + userId, (Throwable)e);
        }
    }

    private void saveMessageCollection(String userId, String collectionId, MessageCollection messageCollection, boolean isUpdate) throws RegistryException {
        String msgCollectionResourcePath = "/users/" + userId + "/messages" + "/" + collectionId;
        this.registry = this.getRegistry();
        Object msgCollectionResource = this.registry.resourceExists(msgCollectionResourcePath) ? this.registry.get(msgCollectionResourcePath) : this.registry.newCollection();
        msgCollectionResource = this.getPropertyAddedMessageCollectionResource(messageCollection, (Resource)msgCollectionResource, isUpdate);
        this.registry.put(msgCollectionResourcePath, (Resource)msgCollectionResource);
    }

    private Resource getPropertyAddedMessageCollectionResource(MessageCollection msgCollection, Resource msgCollectionResource, boolean isUpdate) {
        String oldValue;
        String value = msgCollection.getId();
        if (value != null) {
            if (isUpdate) {
                oldValue = msgCollectionResource.getProperty("id");
                msgCollectionResource.editPropertyValue("id", oldValue, value);
            } else {
                msgCollectionResource.setProperty("id", value);
            }
        }
        if ((value = msgCollection.getTitle()) != null) {
            if (isUpdate) {
                oldValue = msgCollectionResource.getProperty("title");
                msgCollectionResource.editPropertyValue("title", oldValue, value);
            } else {
                msgCollectionResource.setProperty("title", value);
            }
        }
        if (msgCollection.getUpdated() != null) {
            if (isUpdate) {
                oldValue = msgCollectionResource.getProperty("updated");
                msgCollectionResource.editPropertyValue("updated", oldValue, msgCollection.getUpdated().getTime() + "");
            } else {
                msgCollectionResource.setProperty("updated", msgCollection.getUpdated().getTime() + "");
            }
        }
        if (msgCollection.getTotal() != null) {
            if (isUpdate) {
                oldValue = msgCollectionResource.getProperty("total");
                msgCollectionResource.editPropertyValue("total", oldValue, msgCollection.getTotal().toString());
            } else {
                msgCollectionResource.setProperty("total", msgCollection.getTotal().toString());
            }
        }
        if (msgCollection.getUnread() != null) {
            if (isUpdate) {
                oldValue = msgCollectionResource.getProperty("unread");
                msgCollectionResource.editPropertyValue("unread", oldValue, msgCollection.getUnread().toString());
            } else {
                msgCollectionResource.setProperty("unread", msgCollection.getUnread().toString());
            }
        }
        if (msgCollection.getUrls() != null) {
            ArrayList<String> newPropertyValues = new ArrayList<String>();
            for (Url url : msgCollection.getUrls()) {
                if (url == null) continue;
                if (isUpdate) {
                    newPropertyValues.add(url.getLinkText());
                    continue;
                }
                msgCollectionResource.setProperty("urls", url.getLinkText());
            }
            if (isUpdate) {
                msgCollectionResource.setProperty("urls", newPropertyValues);
            }
        }
        return msgCollectionResource;
    }

    private MessageCollection getPropertiesAddedMessageCollectionObj(Resource collectionResource, Set<String> fields) {
        MessageCollectionImpl collectionObj = new MessageCollectionImpl();
        for (String field : fields) {
            if ("id".equalsIgnoreCase(field.trim())) {
                collectionObj.setId(collectionResource.getProperty("id"));
                continue;
            }
            if ("title".equalsIgnoreCase(field.trim())) {
                collectionObj.setTitle(collectionResource.getProperty("title"));
                continue;
            }
            if ("total".equalsIgnoreCase(field.trim())) {
                collectionObj.setTotal(Integer.valueOf(collectionResource.getProperty("total")));
                continue;
            }
            if ("unread".equalsIgnoreCase(field.trim())) {
                collectionObj.setUnread(Integer.valueOf(collectionResource.getProperty("unread")));
                continue;
            }
            if ("updated".equalsIgnoreCase(field.trim())) {
                collectionObj.setUpdated(new Date(Long.valueOf(collectionResource.getProperty("updated"))));
                continue;
            }
            if (!"urls".equalsIgnoreCase(field.trim())) continue;
            ArrayList<UrlImpl> collectionUrls = new ArrayList<UrlImpl>();
            List propertyValues = collectionResource.getPropertyValues("urls");
            for (String urlString : propertyValues) {
                UrlImpl url = new UrlImpl();
                url.setLinkText(urlString);
                collectionUrls.add(url);
            }
            collectionObj.setUrls(collectionUrls);
        }
        return collectionObj;
    }

    private void saveMessage(String userId, String appId, String msgCollectionId, String messageId, Message message, boolean isUpdate) throws RegistryException {
        String messagePath = appId != null ? "/users/" + userId + "/messages" + "/" + appId + "/" + msgCollectionId + "/" + messageId : "/users/" + userId + "/messages" + "/" + msgCollectionId + "/" + messageId;
        this.registry = this.getRegistry();
        Object messageResource = this.registry.resourceExists(messagePath) ? this.registry.get(messagePath) : this.registry.newCollection();
        messageResource = this.getPropertiesAddedMessageResource(message, (Resource)messageResource, isUpdate);
        this.registry.put(messagePath, (Resource)messageResource);
    }

    private Resource getPropertiesAddedMessageResource(Message message, Resource messageResource, boolean isUpdate) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (message.getAppUrl() != null) {
            properties.put("appUrl", message.getAppUrl());
        }
        if (message.getBody() != null) {
            properties.put("body", message.getBody());
        }
        if (message.getBodyId() != null) {
            properties.put("bodyId", message.getBodyId());
        }
        if (message.getId() != null) {
            properties.put("id", message.getId());
        }
        if (message.getInReplyTo() != null) {
            properties.put("inReplyTo", message.getInReplyTo());
        }
        if (message.getSenderId() != null) {
            properties.put("senderId", message.getSenderId());
        }
        if (message.getStatus() != null) {
            properties.put("status", message.getStatus().toString());
        }
        if (message.getTimeSent() != null) {
            properties.put("timeSent", message.getTimeSent().getTime() + "");
        }
        if (message.getTitle() != null) {
            properties.put("title", message.getTitle());
        }
        if (message.getTitleId() != null) {
            properties.put("titleId", message.getTitleId());
        }
        if (message.getType() != null) {
            properties.put("type", message.getType().toString());
        }
        if (message.getUpdated() != null) {
            properties.put("updated", message.getUpdated().getTime() + "");
        }
        this.attachPropertyToResource(messageResource, properties, isUpdate);
        ArrayList<String> propertyValues = message.getCollectionIds();
        if (propertyValues != null) {
            messageResource.setProperty("id", (List)propertyValues);
        }
        if ((propertyValues = message.getRecipients()) != null) {
            messageResource.setProperty("recipients", (List)propertyValues);
        }
        if ((propertyValues = message.getReplies()) != null) {
            messageResource.setProperty("replies", (List)propertyValues);
        }
        List urls = message.getUrls();
        propertyValues = new ArrayList<String>();
        if (urls != null) {
            for (Url url : urls) {
                propertyValues.add(url.getLinkText());
            }
            messageResource.setProperty("urls", propertyValues);
        }
        return messageResource;
    }

    private void attachPropertyToResource(Resource msgResource, Map<String, String> properties, boolean isUpdate) {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (e.getValue() == null) continue;
            if (isUpdate) {
                String oldValue = msgResource.getProperty(e.getKey());
                msgResource.editPropertyValue(e.getKey(), oldValue, e.getValue());
                continue;
            }
            msgResource.addProperty(e.getKey(), e.getValue());
        }
    }

    private Message getPropertiesAddedMessageOjb(Resource msgResource, Set<String> fields) {
        MessageImpl messageObj = new MessageImpl();
        for (String field : fields) {
            if ("appUrl".equalsIgnoreCase(field.trim())) {
                messageObj.setAppUrl(msgResource.getProperty("appUrl"));
                continue;
            }
            if ("body".equalsIgnoreCase(field.trim())) {
                messageObj.setBody(msgResource.getProperty("body"));
                continue;
            }
            if ("bodyId".equalsIgnoreCase(field.trim())) {
                messageObj.setBodyId(msgResource.getProperty("bodyId"));
                continue;
            }
            if ("id".equalsIgnoreCase(field.trim())) {
                messageObj.setId(msgResource.getProperty("id"));
                continue;
            }
            if ("inReplyTo".equalsIgnoreCase(field.trim())) {
                messageObj.setInReplyTo(msgResource.getProperty("inReplyTo"));
                continue;
            }
            if ("senderId".equalsIgnoreCase(field.trim())) {
                messageObj.setSenderId(msgResource.getProperty("senderId"));
                continue;
            }
            if ("status".equalsIgnoreCase(field.trim())) {
                messageObj.setStatus(Message.Status.valueOf((String)msgResource.getProperty("status")));
                continue;
            }
            if ("timeSent".equalsIgnoreCase(field.trim())) {
                messageObj.setTimeSent(new Date(Long.valueOf(msgResource.getProperty("timeSent"))));
                continue;
            }
            if ("title".equalsIgnoreCase(field.trim())) {
                messageObj.setTitle(msgResource.getProperty("title"));
                continue;
            }
            if ("titleId".equalsIgnoreCase(field.trim())) {
                messageObj.setTitleId(msgResource.getProperty("titleId"));
                continue;
            }
            if ("type".equalsIgnoreCase(field.trim())) {
                messageObj.setType(Message.Type.valueOf((String)msgResource.getProperty("type")));
                continue;
            }
            if (!"updated".equalsIgnoreCase(field.trim())) continue;
            messageObj.setUpdated(new Date(Long.valueOf(msgResource.getProperty("updated"))));
        }
        return messageObj;
    }
}

