/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.social.impl.activity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.activity.Activity;
import org.wso2.carbon.registry.social.api.activity.ActivityManager;
import org.wso2.carbon.registry.social.api.activity.MediaItem;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.impl.activity.ActivityImpl;
import org.wso2.carbon.registry.social.impl.activity.MediaItemImpl;
import org.wso2.carbon.registry.social.impl.internal.SocialDSComponent;
import org.wso2.carbon.registry.social.impl.people.relationship.RelationshipManagerImpl;
import org.wso2.carbon.registry.social.impl.utils.FilterOptionsImpl;

public class ActivityManagerImpl
implements ActivityManager {
    private static Log log = LogFactory.getLog(ActivityManagerImpl.class);
    private Registry registry = null;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public Registry getRegistry() throws RegistryException {
        if (this.registry != null) {
            return this.registry;
        }
        return SocialDSComponent.getRegistry();
    }

    public void saveActivity(String userId, Activity userActivity) throws SocialDataException {
        try {
            this.saveActivity(userId, userActivity, false);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while saving activity for person " + userId + " with activityId " + userActivity.getId(), (Throwable)e);
        }
    }

    public void deleteActivity(String userId, String activityId, String appId) throws SocialDataException {
        String activityResourcePath = "/users/" + userId + "/activities/" + appId + "/" + activityId;
        try {
            this.registry = this.getRegistry();
            if (!this.registry.resourceExists(activityResourcePath)) {
                throw new SocialDataException("Activity with specified activityId " + activityId + " doesn't exist");
            }
            this.registry.delete(activityResourcePath);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while deleting activity for person " + userId + " for activityId " + activityId, (Throwable)e);
        }
    }

    public void updateActivity(String userId, Activity userActivity) throws SocialDataException {
        try {
            this.saveActivity(userId, userActivity, true);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException((Throwable)e);
        }
    }

    public Activity[] getActivities(String[] userIds, String groupId, String appId, Set<String> fields, FilterOptions options) throws SocialDataException {
        RelationshipManagerImpl relationshipManager = new RelationshipManagerImpl();
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        ArrayList<String> userIdsToFetch = new ArrayList<String>();
        String[] userIdArray = null;
        if (groupId.equals("self")) {
            userIdArray = userIds;
        } else if (groupId.equals("friends")) {
            for (String id : userIds) {
                if (relationshipManager.getRelationshipList(id) == null) continue;
                for (String friend : relationshipManager.getRelationshipList(id)) {
                    userIdsToFetch.add(friend);
                }
            }
            userIdArray = new String[userIdsToFetch.size()];
            userIdArray = userIdsToFetch.toArray(userIdArray);
        } else {
            return new ActivityImpl[0];
        }
        for (String userId : userIdArray) {
            try {
                String[] activityResourcePaths;
                this.registry = this.getRegistry();
                String resourcePath = "/users/" + userId + "/activities/" + appId;
                if (options == null) {
                    options = new FilterOptionsImpl();
                    options.setMax(0);
                    options.setFirst(0);
                }
                if (!this.registry.resourceExists(resourcePath)) continue;
                int max = options.getMax() == 0 ? 20 : options.getMax();
                Collection activityCollection = this.registry.get(resourcePath, options.getFirst(), max);
                for (String path : activityResourcePaths = activityCollection.getChildren()) {
                    String activityId = path.substring(path.lastIndexOf("/") + 1);
                    if (activityId.equalsIgnoreCase("nextActivityId") || this.getUserActivity(userId, appId, activityId) == null) continue;
                    activityList.add(this.getUserActivity(userId, appId, activityId));
                }
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SocialDataException("Error while retrieving activities for user " + userId, (Throwable)e);
            }
        }
        ActivityImpl[] activities = new ActivityImpl[activityList.size()];
        return activityList.toArray(activities);
    }

    public Activity[] getSortedActivities(String[] userIds, String groupId, String appId, Set<String> fields, FilterOptions options) throws SocialDataException {
        Activity[] activities = this.getActivities(userIds, groupId, appId, fields, options);
        Arrays.sort(activities, new ActivityComparator());
        return activities;
    }

    public Activity[] getActivities(String userId, String groupId, String appId, Set<String> fields, FilterOptions options, String[] activityIds) throws SocialDataException {
        if (activityIds == null) {
            throw new SocialDataException("Invalid activity ids");
        }
        if (activityIds.length <= 0) {
            this.getActivities(new String[]{userId}, groupId, appId, fields, options);
        }
        Activity[] activities = new ActivityImpl[activityIds.length];
        for (int index = 0; index < activityIds.length; ++index) {
            if (activityIds[index] == null) continue;
            activities[index] = this.getActivity(userId, groupId, appId, fields, activityIds[index]);
        }
        return activities;
    }

    public Activity[] getSortedActivities(String userId, String groupId, String appId, Set<String> fields, FilterOptions options, String[] activityIds) throws SocialDataException {
        Activity[] activities = this.getActivities(userId, groupId, appId, fields, options, activityIds);
        Arrays.sort(activities, new ActivityComparator());
        return activities;
    }

    public Activity getActivity(String userId, String groupId, String appId, Set<String> fields, String activityId) throws SocialDataException {
        Activity userActivity = null;
        if (userId == null || userId.trim().equals("") || appId == null || appId.trim().equals("") || activityId == null || activityId.trim().equals("")) {
            throw new SocialDataException("Invalid parameters provided. One or more of the parameter is either null or empty");
        }
        try {
            this.registry = this.getRegistry();
            if (groupId == null || groupId.equals("self")) {
                userActivity = this.getUserActivity(userId, appId, activityId);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SocialDataException("Error while retrieving activity of user " + userId + " with activityId " + activityId, (Throwable)e);
        }
        return userActivity;
    }

    public void deleteActivities(String userId, String groupId, String appId, Set<String> activityIds) throws SocialDataException {
        for (String activityId : activityIds) {
            this.deleteActivity(userId, activityId, appId);
        }
    }

    public void createActivity(String userId, String groupId, String appId, Set<String> fields, Activity activity) throws SocialDataException {
        if (activity == null) {
            String errorMsg = "Cannot create activity. Passed Activity argument is null";
            log.error((Object)errorMsg);
            throw new SocialDataException(errorMsg);
        }
        if (activity.getPostedTime() == null || activity.getPostedTime() == 0L) {
            activity.setPostedTime(Long.valueOf(System.currentTimeMillis()));
        }
        activity.setAppId(appId);
        activity.setUserId(userId);
        this.saveActivity(userId, activity);
    }

    private Resource getPropertiesAddedActivityResourceObj(Activity userActivity, Resource activityResource, boolean isUpdate) {
        if (userActivity == null || activityResource == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (userActivity.getAppId() != null) {
            properties.put("appId", userActivity.getAppId());
        }
        if (userActivity.getBody() != null) {
            properties.put("body", userActivity.getBody());
        }
        if (userActivity.getBodyId() != null) {
            properties.put("bodyId", userActivity.getBodyId());
        }
        if (userActivity.getExternalId() != null) {
            properties.put("externalId", userActivity.getExternalId());
        }
        if (userActivity.getId() != null) {
            properties.put("id", userActivity.getId());
        }
        if (userActivity.getPostedTime() != null) {
            properties.put("postedTime", userActivity.getPostedTime().toString());
        }
        if (userActivity.getPriority() != null) {
            properties.put("priority", userActivity.getPriority().toString());
        }
        if (userActivity.getStreamFaviconUrl() != null) {
            properties.put("streamFaviconUrl", userActivity.getStreamFaviconUrl());
        }
        if (userActivity.getStreamSourceUrl() != null) {
            properties.put("streamSourceUrl", userActivity.getStreamSourceUrl());
        }
        if (userActivity.getStreamTitle() != null) {
            properties.put("streamTitle", userActivity.getStreamTitle());
        }
        if (userActivity.getStreamUrl() != null) {
            properties.put("streamUrl", userActivity.getStreamUrl());
        }
        if (userActivity.getTitle() != null) {
            properties.put("title", userActivity.getTitle());
        }
        if (userActivity.getTitleId() != null) {
            properties.put("titleId", userActivity.getTitleId());
        }
        if (userActivity.getUpdated() != null) {
            properties.put("updated", userActivity.getUpdated().getTime() + "");
        }
        if (userActivity.getUrl() != null) {
            properties.put("url", userActivity.getUrl());
        }
        if (userActivity.getUserId() != null) {
            properties.put("userId", userActivity.getUserId());
        }
        this.attachPropertyToResource(activityResource, properties, isUpdate);
        return activityResource;
    }

    private void attachPropertyToResource(Resource activityResource, Map<String, String> properties, boolean isUpdate) {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (e.getValue() == null) continue;
            if (isUpdate) {
                String oldValue = activityResource.getProperty(e.getKey());
                activityResource.editPropertyValue(e.getKey(), oldValue, e.getValue());
                continue;
            }
            activityResource.addProperty(e.getKey(), e.getValue());
        }
    }

    private Resource getPropertyAddedMediaItemResourceObj(MediaItem activityMediaItem, Resource mediaItemResource, boolean isUpdate) {
        if (mediaItemResource == null || activityMediaItem == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (activityMediaItem.getMimeType() != null) {
            properties.put("mimeType", activityMediaItem.getMimeType());
        }
        if (activityMediaItem.getType() != null) {
            properties.put("type", activityMediaItem.getType().name());
        }
        if (activityMediaItem.getThumbnailUrl() != null) {
            properties.put("thumbnailUrl", activityMediaItem.getThumbnailUrl());
        }
        if (activityMediaItem.getUrl() != null) {
            properties.put("url", activityMediaItem.getUrl());
        }
        this.attachPropertyToResource(mediaItemResource, properties, isUpdate);
        return mediaItemResource;
    }

    private Activity getPropertyAddedActivityObj(Resource activityResource) {
        ActivityImpl activityObj = new ActivityImpl();
        String value = activityResource.getProperty("appId");
        if (value != null) {
            activityObj.setAppId(value);
        }
        if ((value = activityResource.getProperty("body")) != null) {
            activityObj.setBody(value);
        }
        if ((value = activityResource.getProperty("bodyId")) != null) {
            activityObj.setBodyId(value);
        }
        if ((value = activityResource.getProperty("externalId")) != null) {
            activityObj.setExternalId(value);
        }
        if ((value = activityResource.getProperty("id")) != null) {
            activityObj.setId(value);
        }
        if ((value = activityResource.getProperty("updated")) != null) {
            Date updatedDate = new Date(Long.valueOf(value));
            activityObj.setUpdated(updatedDate);
        }
        if ((value = activityResource.getProperty("postedTime")) != null) {
            activityObj.setPostedTime(Long.valueOf(value));
        }
        if ((value = activityResource.getProperty("priority")) != null) {
            activityObj.setPriority(Float.valueOf(value));
        }
        if ((value = activityResource.getProperty("streamFaviconUrl")) != null) {
            activityObj.setStreamFaviconUrl(value);
        }
        if ((value = activityResource.getProperty("streamSourceUrl")) != null) {
            activityObj.setStreamSourceUrl(value);
        }
        if ((value = activityResource.getProperty("streamTitle")) != null) {
            activityObj.setStreamTitle(value);
        }
        if ((value = activityResource.getProperty("streamUrl")) != null) {
            activityObj.setStreamUrl(value);
        }
        if ((value = activityResource.getProperty("title")) != null) {
            activityObj.setTitle(value);
        }
        if ((value = activityResource.getProperty("titleId")) != null) {
            activityObj.setTitleId(value);
        }
        if ((value = activityResource.getProperty("userId")) != null) {
            activityObj.setUserId(value);
        }
        if ((value = activityResource.getProperty("url")) != null) {
            activityObj.setUrl(value);
        }
        return activityObj;
    }

    private MediaItem getPropertiesAddedMediaItemObj(Resource itemResource) {
        MediaItemImpl item = new MediaItemImpl();
        String value = itemResource.getProperty("mimeType");
        if (value != null) {
            item.setMimeType(value);
        }
        if ((value = itemResource.getProperty("thumbnailUrl")) != null) {
            item.setThumbnailUrl(value);
        }
        if ((value = itemResource.getProperty("url")) != null) {
            item.setUrl(value);
        }
        if ((value = itemResource.getProperty("type")) != null) {
            item.setType(MediaItem.Type.valueOf((String)value));
        }
        return item;
    }

    private Activity getUserActivity(String userId, String appId, String activityId) throws RegistryException {
        Activity userActivity;
        this.registry = this.getRegistry();
        String selfActivityResourcePath = "/users/" + userId + "/activities/" + appId + "/" + activityId;
        if (this.registry.resourceExists(selfActivityResourcePath)) {
            String templateParamResourcePath;
            Resource selfActivityResource = this.registry.get(selfActivityResourcePath);
            userActivity = this.getPropertyAddedActivityObj(selfActivityResource);
            String mediaItemResourcePath = selfActivityResourcePath + "/mediaItem";
            if (this.registry.resourceExists(mediaItemResourcePath) && this.registry.get(mediaItemResourcePath).getProperty("noOfMediaItems") != null) {
                int noOfMediaItems = Integer.valueOf(this.registry.get(mediaItemResourcePath).getProperty("noOfMediaItems"));
                ArrayList<MediaItem> mediaItemList = new ArrayList<MediaItem>();
                for (int index = 0; index < noOfMediaItems; ++index) {
                    String itemResourcePath = mediaItemResourcePath + "/" + index;
                    if (!this.registry.resourceExists(itemResourcePath)) continue;
                    Resource mediaItemResource = this.registry.get(itemResourcePath);
                    mediaItemList.add(this.getPropertiesAddedMediaItemObj(mediaItemResource));
                }
                userActivity.setMediaItems(mediaItemList);
            }
            if (this.registry.resourceExists(templateParamResourcePath = selfActivityResourcePath + "/templateParams")) {
                Resource templateParamResource = this.registry.get(templateParamResourcePath);
                Properties props = templateParamResource.getProperties();
                userActivity.setTemplateParams(new HashMap<Object, Object>(props));
            }
        } else {
            log.error((Object)("No activity found with id " + activityId));
            return null;
        }
        return userActivity;
    }

    private void saveActivity(String userId, Activity userActivity, boolean isUpdate) throws RegistryException {
        int nextActivityId;
        Resource nextActivityIdResource;
        this.registry = this.getRegistry();
        String nextActivityPath = "/users/" + userId + "/activities/" + userActivity.getAppId() + "/nextActivityId";
        if (userActivity.getId() == null) {
            if (this.registry.resourceExists(nextActivityPath)) {
                nextActivityIdResource = this.registry.get(nextActivityPath);
                nextActivityId = nextActivityIdResource.getProperty("nextActivityId") != null ? Integer.valueOf(nextActivityIdResource.getProperty("nextActivityId")) : 0;
            } else {
                nextActivityId = 0;
                nextActivityIdResource = this.registry.newCollection();
            }
            nextActivityIdResource.setProperty("nextActivityId", nextActivityId + 1 + "");
            this.registry.put(nextActivityPath, nextActivityIdResource);
            userActivity.setId(nextActivityId + "");
        } else {
            nextActivityIdResource = null;
            nextActivityId = -1;
            if (this.registry.resourceExists(nextActivityPath) && (nextActivityIdResource = this.registry.get(nextActivityPath)).getProperty("nextActivityId") != null) {
                nextActivityId = Integer.valueOf(nextActivityIdResource.getProperty("nextActivityId"));
            }
            String userActivityId = userActivity.getId();
            boolean isIntegerId = false;
            int userActivityIdInteger = 0;
            try {
                userActivityIdInteger = Integer.parseInt(userActivityId);
                isIntegerId = true;
            }
            catch (NumberFormatException e) {
                isIntegerId = false;
            }
            if (nextActivityId > 0 && isIntegerId && nextActivityIdResource != null && nextActivityId == userActivityIdInteger) {
                userActivity.setId(nextActivityId + "");
                nextActivityIdResource.setProperty("nextActivityId", nextActivityId + 1 + "");
                this.registry.put(nextActivityPath, nextActivityIdResource);
            }
        }
        String newActivityPath = "/users/" + userId + "/activities/" + userActivity.getAppId() + "/" + userActivity.getId();
        Object newActivityResource = this.registry.resourceExists(newActivityPath) ? this.registry.get(newActivityPath) : this.registry.newCollection();
        newActivityResource = this.getPropertiesAddedActivityResourceObj(userActivity, (Resource)newActivityResource, isUpdate);
        this.registry.put(newActivityPath, (Resource)newActivityResource);
        if (userActivity.getMediaItems() != null) {
            String resourcePath = newActivityPath + "/mediaItem";
            Object mediaResource = this.registry.resourceExists(resourcePath) ? this.registry.get(resourcePath) : this.registry.newCollection();
            mediaResource.addProperty("noOfMediaItems", userActivity.getMediaItems().size() + "");
            this.registry.put(resourcePath, (Resource)mediaResource);
            int index = 0;
            for (MediaItem item : userActivity.getMediaItems()) {
                String itemResourcePath = resourcePath + "/" + index;
                Object mediaItemResource = this.registry.resourceExists(itemResourcePath) ? this.registry.get(itemResourcePath) : this.registry.newCollection();
                mediaItemResource = this.getPropertyAddedMediaItemResourceObj(item, (Resource)mediaItemResource, isUpdate);
                this.registry.put(itemResourcePath, (Resource)mediaItemResource);
                ++index;
            }
        }
        if (userActivity.getTemplateParams() != null) {
            String templateParamResourcePath = newActivityPath + "/templateParams";
            Object templateParamResource = this.registry.resourceExists(templateParamResourcePath) ? this.registry.get(templateParamResourcePath) : this.registry.newCollection();
            for (String param : userActivity.getTemplateParams().keySet()) {
                if (isUpdate) {
                    String oldValue = templateParamResource.getProperty(param);
                    templateParamResource.editPropertyValue(param, oldValue, (String)userActivity.getTemplateParams().get(param));
                    continue;
                }
                templateParamResource.addProperty(param, (String)userActivity.getTemplateParams().get(param));
            }
            this.registry.put(templateParamResourcePath, (Resource)templateParamResource);
        }
    }

    static class ActivityComparator
    implements Comparator<Activity>,
    Serializable {
        ActivityComparator() {
        }

        @Override
        public int compare(Activity activity1, Activity activity2) {
            if (activity1.getPostedTime() == null) {
                activity1.setPostedTime(Long.valueOf(System.currentTimeMillis()));
            }
            if (activity2.getPostedTime() == null) {
                activity2.setPostedTime(Long.valueOf(System.currentTimeMillis()));
            }
            if (activity1.getPostedTime() < activity2.getPostedTime()) {
                return 1;
            }
            if (activity1.getPostedTime() > activity2.getPostedTime()) {
                return -1;
            }
            return 0;
        }
    }
}

