/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.services;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.wso2.carbon.dashboard.social.common.utils.SocialUtils;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.activity.ActivityManager;
import org.wso2.carbon.registry.social.api.activity.MediaItem;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.impl.activity.ActivityImpl;
import org.wso2.carbon.registry.social.impl.activity.ActivityManagerImpl;

public class GSActivityService
implements ActivityService {
    private ActivityManager manager = new ActivityManagerImpl();
    private final String MEDIA_ITEM_TYPE_AUDIO = "audio";
    private final String MEDIA_ITEM_TYPE_IMAGE = "image";
    private final String MEDIA_ITEM_TYPE_VIDEO = "video";

    public Future<RestfulCollection<Activity>> getActivities(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions collectionOptions, SecurityToken securityToken) throws ProtocolException {
        org.wso2.carbon.registry.social.api.activity.Activity[] activitiesArray;
        ArrayList<Activity> activitiesList = new ArrayList<Activity>();
        FilterOptions options = SocialUtils.convertCollectionOptionsToFilterOptions(collectionOptions);
        String[] userIdArray = new String[userIds.size()];
        int index = 0;
        for (UserId id : userIds) {
            if (id == null) continue;
            if (id.getUserId(securityToken).equals("null")) {
                throw new ProtocolException(500, "No userId specified");
            }
            userIdArray[index++] = id.getUserId(securityToken);
        }
        String groupIdString = groupId.getType().name();
        try {
            activitiesArray = this.manager.getActivities(userIdArray, groupIdString, appId, fields, options);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        if (activitiesArray != null) {
            for (org.wso2.carbon.registry.social.api.activity.Activity item : activitiesArray) {
                if (item == null) continue;
                activitiesList.add(this.convertToShindigActivity(item));
            }
        }
        return ImmediateFuture.newInstance((Object)new RestfulCollection(activitiesList));
    }

    public Future<RestfulCollection<Activity>> getActivities(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions collectionOptions, Set<String> activityIds, SecurityToken securityToken) throws ProtocolException {
        org.wso2.carbon.registry.social.api.activity.Activity[] activitiesArray;
        FilterOptions filterOptions = SocialUtils.convertCollectionOptionsToFilterOptions(collectionOptions);
        String groupIdString = groupId.getType().name();
        String userIdString = userId.getUserId(securityToken);
        if (userIdString.equals("null")) {
            throw new ProtocolException(500, "No userId specified");
        }
        String[] activityIdsArray = new String[activityIds.size()];
        ArrayList<String> list = new ArrayList<String>(activityIds);
        activityIdsArray = list.toArray(activityIdsArray);
        ArrayList<Activity> activitiesList = new ArrayList<Activity>();
        try {
            activitiesArray = this.manager.getActivities(userIdString, groupIdString, appId, fields, filterOptions, activityIdsArray);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        if (activitiesArray != null) {
            for (org.wso2.carbon.registry.social.api.activity.Activity item : activitiesArray) {
                if (item == null) continue;
                activitiesList.add(this.convertToShindigActivity(item));
            }
        }
        return ImmediateFuture.newInstance((Object)new RestfulCollection(activitiesList));
    }

    public Future<Activity> getActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken securityToken) throws ProtocolException {
        org.wso2.carbon.registry.social.api.activity.Activity activityObj;
        String userIdString = userId.getUserId(securityToken);
        if (userIdString.equals("null")) {
            throw new ProtocolException(500, "No userId specified");
        }
        String groupIdString = groupId.getType().name();
        try {
            activityObj = this.manager.getActivity(userIdString, groupIdString, appId, fields, activityId);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance((Object)this.convertToShindigActivity(activityObj));
    }

    public Future<Void> deleteActivities(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken securityToken) throws ProtocolException {
        String userIdString = userId.getUserId(securityToken);
        String groupIdString = groupId.getType().name();
        try {
            this.manager.deleteActivities(userIdString, groupIdString, appId, activityIds);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    public Future<Void> createActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, Activity activity, SecurityToken securityToken) throws ProtocolException {
        String userIdString = userId.getUserId(securityToken);
        String groupIdString = groupId.getType().name();
        try {
            this.manager.createActivity(userIdString, groupIdString, appId, fields, this.convertToSocialActivity(activity));
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        return ImmediateFuture.newInstance(null);
    }

    private Activity convertToShindigActivity(org.wso2.carbon.registry.social.api.activity.Activity activityObj) {
        org.apache.shindig.social.core.model.ActivityImpl resultObj = new org.apache.shindig.social.core.model.ActivityImpl();
        if (activityObj.getAppId() != null) {
            resultObj.setAppId(activityObj.getAppId());
        }
        if (activityObj.getBody() != null) {
            resultObj.setBody(activityObj.getBody());
        }
        if (activityObj.getBodyId() != null) {
            resultObj.setBodyId(activityObj.getBodyId());
        }
        if (activityObj.getExternalId() != null) {
            resultObj.setExternalId(activityObj.getExternalId());
        }
        if (activityObj.getId() != null) {
            resultObj.setId(activityObj.getId());
        }
        if (activityObj.getPostedTime() != null) {
            resultObj.setPostedTime(activityObj.getPostedTime());
        }
        if (activityObj.getPriority() != null) {
            resultObj.setPriority(activityObj.getPriority());
        }
        if (activityObj.getStreamFaviconUrl() != null) {
            resultObj.setStreamFaviconUrl(activityObj.getStreamFaviconUrl());
        }
        if (activityObj.getStreamSourceUrl() != null) {
            resultObj.setStreamSourceUrl(activityObj.getStreamSourceUrl());
        }
        if (activityObj.getStreamTitle() != null) {
            resultObj.setStreamTitle(activityObj.getStreamTitle());
        }
        if (activityObj.getStreamUrl() != null) {
            resultObj.setStreamUrl(activityObj.getStreamUrl());
        }
        if (activityObj.getTemplateParams() != null) {
            resultObj.setTemplateParams(activityObj.getTemplateParams());
        }
        if (activityObj.getTitle() != null) {
            resultObj.setTitle(activityObj.getTitle());
        }
        if (activityObj.getTitleId() != null) {
            resultObj.setTitleId(activityObj.getTitleId());
        }
        if (activityObj.getUpdated() != null) {
            resultObj.setUpdated(activityObj.getUpdated());
        }
        if (activityObj.getUrl() != null) {
            resultObj.setUrl(activityObj.getUrl());
        }
        if (activityObj.getUserId() != null) {
            resultObj.setUserId(activityObj.getUserId());
        }
        ArrayList<MediaItemImpl> mediaItemList = new ArrayList<MediaItemImpl>();
        if (activityObj.getMediaItems() != null) {
            for (MediaItem item : activityObj.getMediaItems()) {
                MediaItemImpl itemObj = new MediaItemImpl();
                if (item == null) continue;
                if (item.getMimeType() != null) {
                    itemObj.setMimeType(item.getMimeType());
                }
                if (item.getThumbnailUrl() != null) {
                    itemObj.setThumbnailUrl(item.getThumbnailUrl());
                }
                if (item.getType() != null) {
                    MediaItem.Type itemType = item.getType();
                    if (itemType.name().equals("audio")) {
                        itemObj.setType(MediaItem.Type.AUDIO);
                    }
                    if (itemType.name().equals("image")) {
                        itemObj.setType(MediaItem.Type.IMAGE);
                    }
                    if (itemType.name().equals("video")) {
                        itemObj.setType(MediaItem.Type.VIDEO);
                    }
                }
                if (item.getUrl() != null) {
                    itemObj.setUrl(item.getUrl());
                }
                mediaItemList.add(itemObj);
            }
            resultObj.setMediaItems(mediaItemList);
        }
        return resultObj;
    }

    private org.wso2.carbon.registry.social.api.activity.Activity convertToSocialActivity(Activity activityObj) {
        ActivityImpl resultObj = new ActivityImpl();
        if (activityObj.getAppId() != null) {
            resultObj.setAppId(activityObj.getAppId());
        }
        if (activityObj.getBody() != null) {
            resultObj.setBody(activityObj.getBody());
        }
        if (activityObj.getBodyId() != null) {
            resultObj.setBodyId(activityObj.getBodyId());
        }
        if (activityObj.getExternalId() != null) {
            resultObj.setExternalId(activityObj.getExternalId());
        }
        if (activityObj.getId() != null) {
            resultObj.setId(activityObj.getId());
        }
        if (activityObj.getPostedTime() != null) {
            resultObj.setPostedTime(activityObj.getPostedTime());
        }
        if (activityObj.getPriority() != null) {
            resultObj.setPriority(activityObj.getPriority());
        }
        if (activityObj.getStreamFaviconUrl() != null) {
            resultObj.setStreamFaviconUrl(activityObj.getStreamFaviconUrl());
        }
        if (activityObj.getStreamSourceUrl() != null) {
            resultObj.setStreamSourceUrl(activityObj.getStreamSourceUrl());
        }
        if (activityObj.getStreamTitle() != null) {
            resultObj.setStreamTitle(activityObj.getStreamTitle());
        }
        if (activityObj.getStreamUrl() != null) {
            resultObj.setStreamUrl(activityObj.getStreamUrl());
        }
        if (activityObj.getTemplateParams() != null) {
            resultObj.setTemplateParams(activityObj.getTemplateParams());
        }
        if (activityObj.getTitle() != null) {
            resultObj.setTitle(activityObj.getTitle());
        }
        if (activityObj.getTitleId() != null) {
            resultObj.setTitleId(activityObj.getTitleId());
        }
        if (activityObj.getUpdated() != null) {
            resultObj.setUpdated(activityObj.getUpdated());
        }
        if (activityObj.getUrl() != null) {
            resultObj.setUrl(activityObj.getUrl());
        }
        if (activityObj.getUserId() != null) {
            resultObj.setUserId(activityObj.getUserId());
        }
        ArrayList<org.wso2.carbon.registry.social.impl.activity.MediaItemImpl> mediaItemList = new ArrayList<org.wso2.carbon.registry.social.impl.activity.MediaItemImpl>();
        if (activityObj.getMediaItems() != null) {
            for (org.apache.shindig.social.opensocial.model.MediaItem item : activityObj.getMediaItems()) {
                org.wso2.carbon.registry.social.impl.activity.MediaItemImpl itemObj = new org.wso2.carbon.registry.social.impl.activity.MediaItemImpl();
                if (item == null) continue;
                if (item.getMimeType() != null) {
                    itemObj.setMimeType(item.getMimeType());
                }
                if (item.getThumbnailUrl() != null) {
                    itemObj.setThumbnailUrl(item.getThumbnailUrl());
                }
                if (item.getType() != null) {
                    MediaItem.Type itemType = item.getType();
                    if (itemType.name().equals("audio")) {
                        itemObj.setType(MediaItem.Type.AUDIO);
                    }
                    if (itemType.name().equals("image")) {
                        itemObj.setType(MediaItem.Type.IMAGE);
                    }
                    if (itemType.name().equals("video")) {
                        itemObj.setType(MediaItem.Type.VIDEO);
                    }
                }
                if (item.getUrl() != null) {
                    itemObj.setUrl(item.getUrl());
                }
                mediaItemList.add(itemObj);
            }
            resultObj.setMediaItems(mediaItemList);
        }
        return resultObj;
    }
}

