/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.handlers;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.UserId;

@Service(name="appdata", path="/{userId}+/{groupId}/{appId}")
public class GSAppDataHandler {
    private final AppDataService service;

    @Inject
    public GSAppDataHandler(AppDataService service) {
        this.service = service;
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        return this.service.deletePersonData((UserId)userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="data")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        return this.create(request);
    }

    @Operation(httpMethods={"POST"}, bodyParam="data")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        Map values = (Map)request.getTypedParameter("data", Map.class);
        for (String key : values.keySet()) {
            if (GSAppDataHandler.isValidKey(key)) continue;
            throw new ProtocolException(400, "One or more of the app data keys are invalid: " + key);
        }
        return this.service.updatePersonData((UserId)userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), values, request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        return this.service.getPersonData(userIds, request.getGroup(), request.getAppId(), request.getFields(), request.getToken());
    }

    public static boolean isValidKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }
}

