/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class ImageScalerUtil {
    private int thubmnailArraySize = 0;

    public InputStream scaleImage(InputStream input, int height, int width, int quality) throws Exception {
        BufferedImage image = ImageIO.read(new BufferedInputStream(input));
        if (image == null) {
            throw new Exception("Unable to change/upload profile Image");
        }
        int thumbHeight = height;
        int thumbWidth = width;
        double thumbRatio = (double)width / (double)height;
        double imageRatio = (double)((Image)image).getWidth(null) / (double)((Image)image).getHeight(null);
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        BufferedImage thumb = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumb.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JPEGTranscoder transcoder = new JPEGTranscoder();
        transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float((float)Math.max(0, Math.min(quality, 100)) / 100.0f));
        transcoder.writeImage(thumb, new TranscoderOutput((OutputStream)output));
        this.thubmnailArraySize = output.size();
        return new ByteArrayInputStream(output.toByteArray());
    }

    public int getThubmnailArraySize() {
        return this.thubmnailArraySize;
    }
}

