/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.handlers;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.UserId;

@Service(name="messages", path="/{userId}+/{msgCollId}/{messageIds}+")
public class GSMessageHandler {
    private final MessageService service;

    @Inject
    public GSMessageHandler(MessageService service) {
        this.service = service;
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List messageIds = request.getListParameter("messageIds");
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        if (msgCollId == null) {
            throw new ProtocolException(400, "A message collection is required");
        }
        HandlerPreconditions.requireNotEmpty((Collection)messageIds, (String)"No message IDs specified");
        UserId user = (UserId)request.getUsers().iterator().next();
        return this.service.deleteMessages(user, msgCollId, messageIds, request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List messageIds = request.getListParameter("messageIds");
        CollectionOptions options = new CollectionOptions((RequestItem)request);
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        UserId user = (UserId)request.getUsers().iterator().next();
        if (msgCollId == null) {
            Set fields = request.getFields(MessageCollection.Field.ALL_FIELDS);
            return this.service.getMessageCollections(user, fields, options, request.getToken());
        }
        Set fields = request.getFields(Message.Field.ALL_FIELDS);
        return this.service.getMessages(user, msgCollId, fields, messageIds, options, request.getToken());
    }

    @Operation(httpMethods={"POST"}, bodyParam="entity")
    public Future<?> modify(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List messageIds = request.getListParameter("messageIds");
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        UserId user = (UserId)request.getUsers().iterator().next();
        if (msgCollId == null) {
            MessageCollection msgCollection = (MessageCollection)request.getTypedParameter("entity", MessageCollection.class);
            return this.service.createMessageCollection(user, msgCollection, request.getToken());
        }
        HandlerPreconditions.requireEmpty((Collection)messageIds, (String)"Message IDs not allowed here, use PUT instead");
        Message message = (Message)request.getTypedParameter("entity", Message.class);
        HandlerPreconditions.requireNotEmpty((Collection)message.getRecipients(), (String)"No recipients specified");
        return this.service.createMessage((UserId)userIds.iterator().next(), request.getAppId(), msgCollId, message, request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="entity")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        String msgCollId = request.getParameter("msgCollId");
        List messageIds = request.getListParameter("messageIds");
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        UserId user = (UserId)request.getUsers().iterator().next();
        if (msgCollId == null) {
            throw new ProtocolException(400, "A message collection is required");
        }
        if (messageIds.isEmpty()) {
            MessageCollection msgCollection = (MessageCollection)request.getTypedParameter("entity", MessageCollection.class);
            if (msgCollection == null) {
                throw new ProtocolException(400, "cannot parse message collection");
            }
            return this.service.modifyMessageCollection(user, msgCollection, request.getToken());
        }
        HandlerPreconditions.requireSingular((Collection)messageIds, (String)"Only one messageId at a time");
        Message message = (Message)request.getTypedParameter("entity", Message.class);
        if (message == null || message.getId() == null) {
            throw new ProtocolException(400, "cannot parse message or missing ID");
        }
        return this.service.modifyMessage(user, msgCollId, (String)messageIds.get(0), message, request.getToken());
    }
}

