/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.AccountImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.OrganizationImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.wso2.carbon.dashboard.social.common.utils.SocialUtils;
import org.wso2.carbon.registry.social.api.SocialDataException;
import org.wso2.carbon.registry.social.api.people.PersonManager;
import org.wso2.carbon.registry.social.api.people.userprofile.model.Account;
import org.wso2.carbon.registry.social.api.people.userprofile.model.ListField;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.impl.people.userprofile.PersonManagerImpl;

public class GSPersonService
implements PersonService {
    private PersonManager personManager = new PersonManagerImpl();
    private static final Comparator<Person> NAME_COMPARATOR = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person1) {
            String name = person.getName().getFormatted();
            String name1 = person1.getName().getFormatted();
            return name.compareTo(name1);
        }
    };

    public Future<RestfulCollection<Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions collectionOptions, Set<String> fields, SecurityToken securityToken) throws ProtocolException {
        org.wso2.carbon.registry.social.api.people.userprofile.Person[] resultPersonArray;
        String[] userFieldsArray;
        List<Object> resultList = new ArrayList<Person>();
        String[] userIdArray = new String[userIds.size()];
        int index = 0;
        for (UserId id : userIds) {
            if (id == null) continue;
            userIdArray[index++] = id.getUserId(securityToken);
        }
        String groupIdString = groupId.getType().name();
        FilterOptions filterOptions = SocialUtils.convertCollectionOptionsToFilterOptions(collectionOptions);
        if (fields != null) {
            userFieldsArray = new String[fields.size()];
            ArrayList<String> userFieldsList = new ArrayList<String>(fields);
            userFieldsArray = userFieldsList.toArray(userFieldsArray);
        } else {
            userFieldsArray = null;
        }
        try {
            resultPersonArray = this.personManager.getPeople(userIdArray, groupIdString, filterOptions, userFieldsArray);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        if (resultPersonArray != null) {
            for (org.wso2.carbon.registry.social.api.people.userprofile.Person person : resultPersonArray) {
                if (person == null) continue;
                resultList.add(this.convertToShindigPersonModel(person));
            }
        }
        if (GroupId.Type.self == groupId.getType() && resultList.isEmpty()) {
            throw new ProtocolException(400, "Person not found");
        }
        if (collectionOptions.getSortBy().equals(Person.Field.NAME.toString())) {
            Collections.sort(resultList, NAME_COMPARATOR);
        }
        if (collectionOptions.getSortOrder() == SortOrder.descending) {
            Collections.reverse(resultList);
        }
        int totalSize = resultList.size();
        int last = collectionOptions.getFirst() + collectionOptions.getMax();
        resultList = resultList.subList(collectionOptions.getFirst(), Math.min(last, totalSize));
        return ImmediateFuture.newInstance((Object)new RestfulCollection(resultList, collectionOptions.getFirst(), totalSize, collectionOptions.getMax()));
    }

    public Future<Person> getPerson(UserId userId, Set<String> fields, SecurityToken securityToken) throws ProtocolException {
        org.wso2.carbon.registry.social.api.people.userprofile.Person person;
        String[] userFieldsArray;
        String userIdString = userId.getUserId(securityToken);
        if (userIdString.equals("null")) {
            throw new ProtocolException(500, "No userId specified");
        }
        Person resultPersonObj = null;
        if (fields != null) {
            userFieldsArray = new String[fields.size()];
            ArrayList<String> userFieldsList = new ArrayList<String>(fields);
            userFieldsArray = userFieldsList.toArray(userFieldsArray);
        } else {
            userFieldsArray = null;
        }
        try {
            person = this.personManager.getPerson(userIdString, userFieldsArray);
        }
        catch (SocialDataException e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
        if (person != null) {
            resultPersonObj = this.convertToShindigPersonModel(person);
        }
        return ImmediateFuture.newInstance(resultPersonObj);
    }

    private Person convertToShindigPersonModel(org.wso2.carbon.registry.social.api.people.userprofile.Person personObj) {
        PersonImpl resultObj = new PersonImpl();
        if (personObj.getAboutMe() != null) {
            resultObj.setAboutMe(personObj.getAboutMe());
        }
        if (personObj.getAccounts() != null) {
            ArrayList<AccountImpl> accounts = new ArrayList<AccountImpl>();
            for (Account account : personObj.getAccounts()) {
                if (account == null) continue;
                AccountImpl accountObj = new AccountImpl();
                if (account.getDomain() != null) {
                    accountObj.setDomain(account.getDomain());
                }
                if (account.getUserId() != null) {
                    accountObj.setUserId(account.getUserId());
                }
                if (account.getUsername() != null) {
                    accountObj.setUsername(account.getUsername());
                }
                accounts.add(accountObj);
            }
            resultObj.setAccounts(accounts);
        }
        if (personObj.getActivities() != null) {
            resultObj.setActivities(personObj.getActivities());
        }
        if (personObj.getAddresses() != null) {
            ArrayList<Address> addressList = new ArrayList<Address>();
            for (org.wso2.carbon.registry.social.api.people.userprofile.model.Address address : personObj.getAddresses()) {
                if (address == null) continue;
                addressList.add(this.convertToShindigAddressModel(address));
            }
            resultObj.setAddresses(addressList);
        }
        if (personObj.getAge() != null) {
            resultObj.setAge(personObj.getAge());
        }
        if (personObj.getAppData() != null) {
            resultObj.setAppData(personObj.getAppData());
        }
        if (personObj.getBirthday() != null) {
            resultObj.setBirthday(personObj.getBirthday());
        }
        if (personObj.getBooks() != null) {
            resultObj.setBooks(personObj.getBooks());
        }
        if (personObj.getCars() != null) {
            resultObj.setCars(personObj.getCars());
        }
        if (personObj.getChildren() != null) {
            resultObj.setChildren(personObj.getChildren());
        }
        if (personObj.getCurrentLocation() != null) {
            resultObj.setCurrentLocation(this.convertToShindigAddressModel(personObj.getCurrentLocation()));
        }
        if (personObj.getName() != null) {
            NameImpl nameObj = new NameImpl();
            org.wso2.carbon.registry.social.api.people.userprofile.model.Name name = personObj.getName();
            if (name.getGivenName() != null) {
                nameObj.setGivenName(name.getGivenName());
            }
            if (name.getFamilyName() != null) {
                nameObj.setFamilyName(name.getFamilyName());
            }
            if (name.getAdditionalName() != null) {
                nameObj.setAdditionalName(name.getAdditionalName());
            }
            if (name.getFormatted() != null) {
                nameObj.setFormatted(name.getFormatted());
            }
            if (name.getHonorificPrefix() != null) {
                nameObj.setHonorificPrefix(name.getHonorificPrefix());
            }
            if (name.getHonorificSuffix() != null) {
                nameObj.setHonorificSuffix(name.getHonorificSuffix());
            }
            resultObj.setName((Name)nameObj);
        }
        if (personObj.getDisplayName() != null) {
            resultObj.setDisplayName(personObj.getDisplayName());
        }
        if (personObj.getEmails() != null) {
            ArrayList<org.apache.shindig.social.opensocial.model.ListField> emailsList = new ArrayList<org.apache.shindig.social.opensocial.model.ListField>();
            for (ListField entry : personObj.getEmails()) {
                if (entry == null) continue;
                emailsList.add(this.convertToShindigListFieldModel(entry));
            }
            resultObj.setEmails(emailsList);
        }
        if (personObj.getIms() != null) {
            ArrayList<org.apache.shindig.social.opensocial.model.ListField> imsList = new ArrayList<org.apache.shindig.social.opensocial.model.ListField>();
            for (ListField entry : personObj.getIms()) {
                if (entry == null) continue;
                imsList.add(this.convertToShindigListFieldModel(entry));
            }
            resultObj.setIms(imsList);
        }
        if (personObj.getEthnicity() != null) {
            resultObj.setEthnicity(personObj.getEthnicity());
        }
        if (personObj.getFashion() != null) {
            resultObj.setFashion(personObj.getFashion());
        }
        if (personObj.getFood() != null) {
            resultObj.setFood(personObj.getFood());
        }
        if (personObj.getGender() != null) {
            if ("female".equals(personObj.getGender().name())) {
                resultObj.setGender(Person.Gender.female);
            } else if ("male".equals(personObj.getGender().name())) {
                resultObj.setGender(Person.Gender.male);
            }
        }
        if (personObj.getOrganizations() != null) {
            ArrayList<Organization> orgsList = new ArrayList<Organization>();
            for (org.wso2.carbon.registry.social.api.people.userprofile.model.Organization org : personObj.getOrganizations()) {
                if (org == null) continue;
                orgsList.add(this.convertToShindigOrganizationModel(org));
            }
            resultObj.setOrganizations(orgsList);
        }
        if (personObj.getHappiestWhen() != null) {
            resultObj.setHappiestWhen(personObj.getHappiestWhen());
        }
        if (personObj.getHeroes() != null) {
            resultObj.setHeroes(personObj.getHeroes());
        }
        if (personObj.getHumor() != null) {
            resultObj.setHumor(personObj.getHumor());
        }
        if (personObj.getId() != null) {
            resultObj.setId(personObj.getId());
        }
        if (personObj.getInterests() != null) {
            resultObj.setInterests(personObj.getInterests());
        }
        if (personObj.getJobInterests() != null) {
            resultObj.setJobInterests(personObj.getJobInterests());
        }
        if (personObj.getLanguagesSpoken() != null) {
            resultObj.setLanguagesSpoken(personObj.getLanguagesSpoken());
        }
        if (personObj.getLivingArrangement() != null) {
            resultObj.setLivingArrangement(personObj.getLivingArrangement());
        }
        if (personObj.getMovies() != null) {
            resultObj.setMovies(personObj.getMovies());
        }
        if (personObj.getMusic() != null) {
            resultObj.setMusic(personObj.getMusic());
        }
        if (personObj.getNickname() != null) {
            resultObj.setNickname(personObj.getNickname());
        }
        if (personObj.getPets() != null) {
            resultObj.setPets(personObj.getPets());
        }
        if (personObj.getPhoneNumbers() != null) {
            ArrayList<org.apache.shindig.social.opensocial.model.ListField> phoneNoList = new ArrayList<org.apache.shindig.social.opensocial.model.ListField>();
            for (ListField entry : personObj.getPhoneNumbers()) {
                if (entry == null) continue;
                phoneNoList.add(this.convertToShindigListFieldModel(entry));
            }
            resultObj.setIms(phoneNoList);
        }
        if (personObj.getPoliticalViews() != null) {
            resultObj.setPoliticalViews(personObj.getPoliticalViews());
        }
        if (personObj.getUpdated() != null) {
            resultObj.setUpdated(personObj.getUpdated());
        }
        if (personObj.getThumbnailUrl() != null) {
            resultObj.setThumbnailUrl(personObj.getThumbnailUrl());
        }
        if (personObj.getStatus() != null) {
            resultObj.setStatus(personObj.getStatus());
        }
        if (personObj.getReligion() != null) {
            resultObj.setReligion(personObj.getReligion());
        }
        if (personObj.getRelationshipStatus() != null) {
            resultObj.setRelationshipStatus(personObj.getRelationshipStatus());
        }
        if (personObj.getQuotes() != null) {
            resultObj.setQuotes(personObj.getQuotes());
        }
        if (personObj.getProfileUrl() != null) {
            resultObj.setProfileUrl(personObj.getProfileUrl());
        }
        if (personObj.getPreferredUsername() != null) {
            resultObj.setPreferredUsername(personObj.getPreferredUsername());
        }
        return resultObj;
    }

    private Address convertToShindigAddressModel(org.wso2.carbon.registry.social.api.people.userprofile.model.Address address) {
        AddressImpl resultObj = new AddressImpl();
        if (address.getCountry() != null) {
            resultObj.setCountry(address.getCountry());
        }
        if (address.getFormatted() != null) {
            resultObj.setFormatted(address.getFormatted());
        }
        if (address.getLatitude() != null) {
            resultObj.setLatitude(address.getLatitude());
        }
        if (address.getLocality() != null) {
            resultObj.setLocality(address.getLocality());
        }
        if (address.getLongitude() != null) {
            resultObj.setLongitude(address.getLongitude());
        }
        if (address.getPostalCode() != null) {
            resultObj.setPostalCode(address.getPostalCode());
        }
        if (address.getRegion() != null) {
            resultObj.setRegion(address.getRegion());
        }
        if (address.getStreetAddress() != null) {
            resultObj.setStreetAddress(address.getStreetAddress());
        }
        if (address.getType() != null) {
            resultObj.setType(address.getType());
        }
        resultObj.setPrimary(address.getPrimary());
        return resultObj;
    }

    private Organization convertToShindigOrganizationModel(org.wso2.carbon.registry.social.api.people.userprofile.model.Organization org) {
        OrganizationImpl orgObj = new OrganizationImpl();
        if (org.getName() != null) {
            orgObj.setName(org.getName());
        }
        if (org.getDescription() != null) {
            orgObj.setDescription(org.getDescription());
        }
        if (org.getField() != null) {
            orgObj.setField(org.getField());
        }
        if (org.getTitle() != null) {
            orgObj.setTitle(org.getTitle());
        }
        orgObj.setPrimary(org.getPrimary());
        if (org.getAddress() != null) {
            orgObj.setAddress(this.convertToShindigAddressModel(org.getAddress()));
        }
        if (org.getEndDate() != null) {
            orgObj.setEndDate(org.getEndDate());
        }
        if (org.getSalary() != null) {
            orgObj.setSalary(org.getSalary());
        }
        if (org.getStartDate() != null) {
            orgObj.setStartDate(org.getStartDate());
        }
        if (org.getSubField() != null) {
            orgObj.setSubField(org.getSubField());
        }
        if (org.getType() != null) {
            orgObj.setType(org.getType());
        }
        if (org.getWebpage() != null) {
            orgObj.setWebpage(org.getWebpage());
        }
        return orgObj;
    }

    private org.apache.shindig.social.opensocial.model.ListField convertToShindigListFieldModel(ListField field) {
        ListFieldImpl resultObj = new ListFieldImpl();
        if (field.getType() != null) {
            resultObj.setType(field.getType());
        }
        if (field.getValue() != null) {
            resultObj.setValue(field.getValue());
        }
        resultObj.setPrimary(field.getPrimary());
        return resultObj;
    }
}

