/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;
import org.wso2.carbon.dashboard.social.GadgetServerSocialDataMgtServiceContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.ui.CarbonUIUtil;

public class GSOAuthDataStore
implements OAuthDataStore {
    private final int CALLBACK_TOKEN_LENGTH = 6;
    private final int CALLBACK_TOKEN_ATTEMPTS = 5;
    private final OAuthServiceProvider SERVICE_PROVIDER;
    private static ConcurrentMap<String, OAuthEntry> oauthEntries = new MapMaker().makeMap();

    @Inject
    public GSOAuthDataStore(@Named(value="shindig.oauth.base-url") String baseUrl) {
        this.SERVICE_PROVIDER = new OAuthServiceProvider(baseUrl + "requestToken", baseUrl + "authorize", baseUrl + "accessToken");
    }

    public OAuthEntry getEntry(String oauthToken) {
        Preconditions.checkNotNull((Object)oauthToken);
        return (OAuthEntry)oauthEntries.get(oauthToken);
    }

    public OAuthConsumer getConsumer(String consumerKey) {
        try {
            Registry registry = GadgetServerSocialDataMgtServiceContext.getRegistry();
            String resourcePath = "/repository/gadget-server/oauth";
            String consumerSecret = null;
            if (registry.resourceExists(resourcePath)) {
                Resource oauthResource = registry.get(resourcePath);
                consumerSecret = oauthResource.getProperty("consumer_secret");
            }
            if (consumerSecret == null) {
                return null;
            }
            OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, consumerSecret, this.SERVICE_PROVIDER);
            return consumer;
        }
        catch (Exception e) {
            return null;
        }
    }

    public OAuthEntry generateRequestToken(String consumerKey, String oauthVersion, String signedCallbackUrl) {
        OAuthEntry entry = new OAuthEntry();
        entry.appId = consumerKey;
        entry.consumerKey = consumerKey;
        entry.domain = CarbonUIUtil.getAdminConsoleURL((String)"/");
        entry.container = "default";
        entry.token = UUID.randomUUID().toString();
        entry.tokenSecret = UUID.randomUUID().toString();
        entry.type = OAuthEntry.Type.REQUEST;
        entry.issueTime = new Date();
        entry.oauthVersion = oauthVersion;
        if (signedCallbackUrl != null) {
            entry.callbackUrlSigned = true;
            entry.callbackUrl = signedCallbackUrl;
        }
        oauthEntries.put(entry.token, entry);
        return entry;
    }

    public OAuthEntry convertToAccessToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        Preconditions.checkState((entry.type == OAuthEntry.Type.REQUEST ? 1 : 0) != 0, (Object)"Token must be a request token");
        OAuthEntry accessEntry = new OAuthEntry(entry);
        accessEntry.token = UUID.randomUUID().toString();
        accessEntry.tokenSecret = UUID.randomUUID().toString();
        accessEntry.type = OAuthEntry.Type.ACCESS;
        accessEntry.issueTime = new Date();
        oauthEntries.remove(entry.token);
        oauthEntries.put(accessEntry.token, accessEntry);
        return accessEntry;
    }

    public void authorizeToken(OAuthEntry entry, String userId) {
        Preconditions.checkNotNull((Object)entry);
        entry.authorized = true;
        entry.userId = (String)Preconditions.checkNotNull((Object)userId);
        if (entry.callbackUrlSigned) {
            entry.callbackToken = Crypto.getRandomDigits((int)6);
        }
    }

    public void disableToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        ++entry.callbackTokenAttempts;
        if (!entry.callbackUrlSigned || entry.callbackTokenAttempts >= 5) {
            entry.type = OAuthEntry.Type.DISABLED;
        }
        oauthEntries.put(entry.token, entry);
    }

    public void removeToken(OAuthEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        oauthEntries.remove(entry.token);
    }

    public SecurityToken getSecurityTokenForConsumerRequest(String consumerKey, String userId) {
        String domain = CarbonUIUtil.getAdminConsoleURL((String)"/");
        String container = "default";
        return new OAuthSecurityToken(userId, null, consumerKey, domain, container, AuthenticationMode.OAUTH_CONSUMER_REQUEST.name());
    }
}

