/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.social.common.utils;

import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.wso2.carbon.registry.social.api.utils.FilterOperation;
import org.wso2.carbon.registry.social.api.utils.FilterOptions;
import org.wso2.carbon.registry.social.api.utils.SortOrder;
import org.wso2.carbon.registry.social.impl.utils.FilterOptionsImpl;

public class SocialUtils {
    public static String USER_DASHBOARD_REGISTRY_ROOT = "/users/";
    public static final String USER_LIST_FILTER_STRING = "*";
    public static final int USER_LIST_SIZE = -1;
    public static final String DEFAULT_PROFILE = "default";
    public static final String USER_ROOT = "/users/";
    public static final String PROFILE_IMAGE_NAME = "profileimage.jpg";
    public static final String PROFILE_IMAGE_PATH = "/gadget-server/profiles/default/profileimage";
    public static final int DEFAULT_PROFILE_FIELDS_COUNT = 2;
    public static final String USER_PROFILE_DASHBOARD_REGISTRY_ROOT = "/gadget-server/profiles/";
    public static final String USER_PROFILE_FIELD_VISIBILITY = "visibility";
    public static final String VISIBILITY_NONE = "none";
    public static final String VISIBILITY_EVERYONE = "every-one";
    public static final String VISIBILITY_ONLYFRIENDS = "only-to-friends";
    public static final String RELATIONSHIP_STATUS_FRIEND = "friend";
    public static final String RELATIONSHIP_STATUS_SELF = "self";
    public static final String USER_PROFILE_IMAGE = "/profileimage/profileimage.jpg";
    public static final String USER_PROFILE_REGISTRY_ROOT = "/registry/resourceContent?path=/_system/config/users/";

    private SocialUtils() {
    }

    public static boolean isViewable(String relationshipStatus, String privacyOption) {
        boolean result = false;
        if (RELATIONSHIP_STATUS_SELF.equals(relationshipStatus)) {
            return true;
        }
        String visibility = SocialUtils.getVisibility(relationshipStatus);
        if (privacyOption.equals(VISIBILITY_NONE)) {
            result = false;
        } else if (privacyOption.equals(VISIBILITY_EVERYONE)) {
            result = true;
        } else if (privacyOption.equals(visibility)) {
            result = true;
        } else if (visibility.equals(VISIBILITY_ONLYFRIENDS) && privacyOption.equals(VISIBILITY_EVERYONE)) {
            result = true;
        }
        return result;
    }

    private static String getVisibility(String relationshipStatus) {
        String visibility = "";
        visibility = relationshipStatus.equals(RELATIONSHIP_STATUS_FRIEND) ? VISIBILITY_ONLYFRIENDS : VISIBILITY_NONE;
        return visibility;
    }

    public static FilterOptions convertCollectionOptionsToFilterOptions(CollectionOptions collectionOptions) {
        FilterOptionsImpl filterOptions = new FilterOptionsImpl();
        FilterOptionsImpl options = new FilterOptionsImpl();
        if (collectionOptions != null) {
            if (collectionOptions.getFilter() != null) {
                options.setFilter(collectionOptions.getFilter());
            }
            if (collectionOptions.getFilterValue() != null) {
                options.setFilterValue(collectionOptions.getFilterValue());
            }
            if (collectionOptions.getFilterOperation() != null && collectionOptions.getFilterOperation().name() != null) {
                options.setFilterOperation(FilterOperation.valueOf((String)collectionOptions.getFilterOperation().name()));
            }
            options.setFirst(collectionOptions.getFirst());
            options.setMax(collectionOptions.getMax());
            if (collectionOptions.getSortBy() != null) {
                options.setSortBy(collectionOptions.getSortBy());
            }
            if (collectionOptions.getUpdatedSince() != null) {
                options.setUpdatedSince(collectionOptions.getUpdatedSince());
            }
            if (collectionOptions.getSortOrder() != null && collectionOptions.getSortOrder().name() != null) {
                options.setSortOrder(SortOrder.valueOf((String)collectionOptions.getSortOrder().name()));
            }
            return filterOptions;
        }
        return null;
    }
}

