/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.users;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.mgt.users.GadgetServerUserManagementContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;

public class GadgetServerUserManagementService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(GadgetServerUserManagementService.class);

    public Boolean setUserSelfRegistration(boolean flag) {
        return this.setSelfRegistration(flag);
    }

    public Boolean setUserExternalGadgetAddition(boolean flag) {
        return this.setExternalGadgetAddition(flag);
    }

    private int getTenantId() {
        return SuperTenantCarbonContext.getCurrentContext().getTenantId();
    }

    public Boolean setSelfRegistration(boolean flag) {
        Boolean response = false;
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(this.getTenantId());
            Resource regAdminDataResource = registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) ? registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) : registry.newResource();
            regAdminDataResource.setProperty(DashboardConstants.USER_SELF_REG_PROPERTY_ID, String.valueOf(flag));
            registry.put(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH, regAdminDataResource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }

    public Boolean isSelfRegistration(String tDomain) {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = GadgetServerUserManagementContext.getRegistry(this.getTenantId());
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_SELF_REG_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean isExternalGadgetAddition() {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_EXTERNAL_GADGET_ADD_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean setExternalGadgetAddition(boolean flag) {
        Boolean response = false;
        try {
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            Resource regAdminDataResource = registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) ? registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) : registry.newResource();
            regAdminDataResource.setProperty(DashboardConstants.USER_EXTERNAL_GADGET_ADD_PROPERTY_ID, String.valueOf(flag));
            registry.put(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH, regAdminDataResource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }

    public Boolean isPortalPermissionsSet() {
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(this.getTenantId());
            return registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean isAnonModeActive(String tDomain) {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = GadgetServerUserManagementContext.getRegistry(this.getTenantId());
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.ANON_MODE_ACT)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean setAnonModeState(boolean flag) {
        Boolean response = false;
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(this.getTenantId());
            Resource regAdminDataResource = registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) ? registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) : registry.newResource();
            regAdminDataResource.setProperty(DashboardConstants.ANON_MODE_ACT, String.valueOf(flag));
            registry.put(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH, regAdminDataResource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }

    public Boolean isSessionValid() {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        return !httpSession.isNew();
    }
}

