/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.users;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.mgt.users.GadgetServerUserManagementException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.ConfigurationContextService;

public class GadgetServerUserManagementContext {
    private static Log log = LogFactory.getLog(GadgetServerUserManagementContext.class);
    private static RegistryService registryService = null;
    private static UserRealm userRealm = null;
    private static ConfigurationContextService configCtx;

    public static UserRealm getUserRealm() throws GadgetServerUserManagementException {
        if (userRealm == null) {
            throw new GadgetServerUserManagementException("UserRealm is null");
        }
        return userRealm;
    }

    public static void setUserRealm(UserRealm userRealm) {
        GadgetServerUserManagementContext.userRealm = userRealm;
    }

    public static void setRegistryService(RegistryService registryService) {
        GadgetServerUserManagementContext.registryService = registryService;
    }

    public static Registry getRegistry(int tenantId) throws GadgetServerUserManagementException {
        if (registryService == null) {
            throw new GadgetServerUserManagementException("Registry is null");
        }
        try {
            return registryService.getConfigSystemRegistry(tenantId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new GadgetServerUserManagementException(e);
        }
    }

    public static boolean setPortalAdminData(int tenantId) {
        try {
            if (!GadgetServerUserManagementContext.isPortalPermissionsSet(tenantId).booleanValue()) {
                GadgetServerUserManagementContext.setSelfRegistration(false, tenantId);
                GadgetServerUserManagementContext.setExternalGadgetAddition(true, tenantId);
                GadgetServerUserManagementContext.setAnonModeState(false, tenantId);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    public static Boolean isPortalPermissionsSet(int tenantId) {
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            return registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Boolean setSelfRegistration(boolean flag, int tenantId) {
        Boolean response = false;
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            Resource regAdminDataResource = registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) ? registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) : registry.newResource();
            regAdminDataResource.setProperty(DashboardConstants.USER_SELF_REG_PROPERTY_ID, String.valueOf(flag));
            registry.put(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH, regAdminDataResource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }

    public static Boolean setExternalGadgetAddition(boolean flag, int tenantId) {
        Boolean response = false;
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            Resource regAdminDataResource = registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) ? registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) : registry.newResource();
            regAdminDataResource.setProperty(DashboardConstants.USER_EXTERNAL_GADGET_ADD_PROPERTY_ID, String.valueOf(flag));
            registry.put(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH, regAdminDataResource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }

    public static Boolean setAnonModeState(boolean flag, int tenantId) {
        Boolean response = false;
        try {
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            Resource regAdminDataResource = registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) ? registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) : registry.newResource();
            regAdminDataResource.setProperty(DashboardConstants.ANON_MODE_ACT, String.valueOf(flag));
            registry.put(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH, regAdminDataResource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }

    public static Boolean isAnonModeActive(int tenantId) {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = GadgetServerUserManagementContext.getRegistry(tenantId);
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.ANON_MODE_ACT)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public static void setConfigContextService(ConfigurationContextService configCtx) {
        GadgetServerUserManagementContext.configCtx = configCtx;
    }

    public static ConfigurationContextService getConfigCtx() {
        return configCtx;
    }

    public static ConfigurationContext getConfigContext() throws GadgetServerUserManagementException {
        if (configCtx == null) {
            throw new GadgetServerUserManagementException("ConfigurationContextService is null");
        }
        try {
            return configCtx.getServerConfigContext();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new GadgetServerUserManagementException(e);
        }
    }
}

