/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.theme.ui.processors;

import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ContentDownloadBean;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;

public class ResourceContentProcessor {
    private static final Log log = LogFactory.getLog(ResourceContentProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getContent(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws Exception {
        block13: {
            try {
                ResourceServiceClient client = new ResourceServiceClient(config, request.getSession());
                String uri = request.getRequestURI();
                int idx = uri.indexOf("resource");
                String path = uri.split("resource")[1];
                if (!path.contains("gadget-server/themes")) {
                    String msg = "Illegal path on request";
                    log.error((Object)msg);
                    response.setStatus(401);
                    return;
                }
                if (path == null) {
                    String msg = "Could not get the resource content. Path is not specified.";
                    log.error((Object)msg);
                    response.setStatus(400);
                    return;
                }
                ContentDownloadBean bean = client.getContentDownloadBean(path);
                InputStream contentStream = null;
                if (bean.getContent() == null) {
                    String msg = "The resource content was empty.";
                    log.error((Object)msg);
                    response.setStatus(204);
                    return;
                }
                contentStream = bean.getContent().getInputStream();
                response.setDateHeader("Last-Modified", bean.getLastUpdatedTime().getTime().getTime());
                if (bean.getMediatype() != null && bean.getMediatype().length() > 0) {
                    response.setContentType(bean.getMediatype());
                } else {
                    response.setContentType("application/download");
                }
                if (bean.getResourceName() != null) {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + bean.getResourceName() + "\"");
                }
                if (contentStream == null) break block13;
                ServletOutputStream servletOutputStream = null;
                try {
                    int byteCount;
                    servletOutputStream = response.getOutputStream();
                    byte[] contentChunk = new byte[1024];
                    while ((byteCount = contentStream.read(contentChunk)) != -1) {
                        servletOutputStream.write(contentChunk, 0, byteCount);
                    }
                    response.flushBuffer();
                    servletOutputStream.flush();
                }
                finally {
                    contentStream.close();
                    if (servletOutputStream != null) {
                        servletOutputStream.close();
                    }
                }
            }
            catch (RegistryException e) {
                String msg = "Failed to get resource content. " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                response.setStatus(500);
                return;
            }
        }
    }
}

