/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.theme.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.mgt.theme.stub.GSThemeMgtServiceException;
import org.wso2.carbon.dashboard.mgt.theme.stub.GSThemeMgtServiceStub;
import org.wso2.carbon.dashboard.mgt.theme.stub.types.carbon.Theme;

public class GSThemeMgtClient {
    private static final Log log = LogFactory.getLog(GSThemeMgtClient.class);
    public GSThemeMgtServiceStub stub;

    public GSThemeMgtClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "GSThemeMgtService";
        this.stub = new GSThemeMgtServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public Theme[] getThemes(String user) throws Exception {
        return this.stub.getThemes(user);
    }

    public boolean setThemeForUser(String themePath, String user) throws Exception {
        return this.stub.setThemeForUser(themePath, user);
    }

    public String getDefaultThemeForUser(String user) throws Exception {
        return this.stub.getDefaultThemeForUser(user);
    }

    public void addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation) throws Exception {
        try {
            Options options = this.stub._getServiceClient().getOptions();
            options.setProperty("enableMTOM", (Object)"true");
            options.setTimeOutInMilliSeconds(300000L);
            this.stub.addResource(path, mediaType, description, content, symlinkLocation);
        }
        catch (Exception e) {
            String msg = "Failed to add resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void getRollbackToDefTheme(String user) {
        try {
            this.stub.rollbackToDefaultGSTheme(user);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (GSThemeMgtServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

