/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.theme.ui.processors;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.dashboard.mgt.theme.ui.GSThemeMgtClient;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerData;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class ThemeUploadProcessors
extends AbstractFileUploadExecutor {
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        HttpSession session = request.getSession();
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. Content is not set properly.";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp");
            return false;
        }
        String errorRedirect = null;
        try {
            GSThemeMgtClient client = new GSThemeMgtClient(cookie, serverURL, this.configurationContext, request.getLocale());
            String parentPath = null;
            Map formFieldsMap = this.getFormFieldsMap();
            if (formFieldsMap.get("path") != null) {
                parentPath = (String)((ArrayList)formFieldsMap.get("path")).get(0);
            }
            String resourceName = null;
            if (formFieldsMap.get("filename") != null) {
                resourceName = (String)((ArrayList)formFieldsMap.get("filename")).get(0);
            }
            String mediaType = null;
            if (formFieldsMap.get("mediaType") != null) {
                mediaType = (String)((ArrayList)formFieldsMap.get("mediaType")).get(0);
            }
            String description = null;
            if (formFieldsMap.get("description") != null) {
                description = (String)((ArrayList)formFieldsMap.get("description")).get(0);
            }
            String redirect = null;
            if (formFieldsMap.get("redirect") != null) {
                redirect = (String)((ArrayList)formFieldsMap.get("redirect")).get(0);
            }
            if (formFieldsMap.get("errorRedirect") != null) {
                errorRedirect = (String)((ArrayList)formFieldsMap.get("errorRedirect")).get(0);
            }
            String symlinkLocation = null;
            if (formFieldsMap.get("symlinkLocation") != null) {
                symlinkLocation = (String)((ArrayList)formFieldsMap.get("symlinkLocation")).get(0);
            }
            IServerAdmin adminClient = (IServerAdmin)CarbonUIUtil.getServerProxy((Object)new ServerAdminClient(this.configurationContext, serverURL, cookie, session), IServerAdmin.class, (HttpSession)session);
            ServerData data = adminClient.getServerData();
            String chroot = "";
            if (data.getRegistryType() != null && data.getRegistryType().equals("remote") && data.getRemoteRegistryChroot() != null && !data.getRemoteRegistryChroot().equals("/")) {
                chroot = data.getRemoteRegistryChroot();
                if (!chroot.startsWith("/")) {
                    chroot = "/" + chroot;
                }
                if (chroot.endsWith("/")) {
                    chroot = chroot.substring(0, chroot.length() - "/".length());
                }
            }
            if (symlinkLocation != null) {
                symlinkLocation = chroot + symlinkLocation;
            }
            FileItemData fileItemData = (FileItemData)((ArrayList)fileItemsMap.get("upload")).get(0);
            if ("".equals(resourceName) || resourceName == null) {
                resourceName = this.getFileName(fileItemData.getFileItem().getName());
            }
            if (fileItemData == null || fileItemData.getFileItem().getSize() == 0L) {
                String msg = "Failed add resource. Resource content is empty.";
                log.error((Object)msg);
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
                if (errorRedirect == null) {
                    response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp");
                } else {
                    response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
                }
                return false;
            }
            DataHandler dataHandler = fileItemData.getDataHandler();
            client.addResource(ThemeUploadProcessors.calcualtePath(parentPath, resourceName), mediaType, description, dataHandler, symlinkLocation);
            response.setContentType("text/html; charset=utf-8");
            String msg = "Successfully uploaded content.";
            if (redirect == null) {
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request);
                try {
                    parentPath = parentPath.replace("&", "%26");
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if ("/".equals(parentPath)) {
                    parentPath = parentPath + "&viewType=std";
                }
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/resources/resource.jsp?path=" + parentPath);
            } else {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + redirect);
            }
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
            if (errorRedirect == null) {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp");
            } else {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
            }
            return false;
        }
    }

    private static String calcualtePath(String parentPath, String resourceName) {
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        String resourcePath = parentPath.endsWith("/") ? parentPath + resourceName : parentPath + "/" + resourceName;
        return resourcePath;
    }
}

