/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.theme.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.mgt.theme.Utils.ThemeMgtContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserStoreException;

public class ThemeUploadHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ThemeUploadHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
        UserRegistry sysRegistry = ThemeMgtContext.getRegistryService().getConfigSystemRegistry();
        try {
            if (!CurrentSession.getUserRealm().getAuthorizationManager().isUserAuthorized(CurrentSession.getUser(), "/_system/config" + DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + CurrentSession.getUser() + "/gadget-server/themes", "http://www.wso2.org/projects/registry/actions/get")) {
                CurrentSession.getUserRealm().getAuthorizationManager().authorizeUser(CurrentSession.getUser(), "/_system/config" + DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + CurrentSession.getUser() + "/gadget-server/themes", "http://www.wso2.org/projects/registry/actions/get");
            }
        }
        catch (UserStoreException use) {
            log.error((Object)"Exception when providing permission : ", (Throwable)use);
        }
        ZipInputStream zis = new ZipInputStream(requestContext.getResource().getContentStream());
        ZipEntry zipentry = null;
        byte[] buff = new byte[1024];
        try {
            zipentry = zis.getNextEntry();
            if (zipentry == null) {
                throw new RegistryException("Theme bundle should be a zip file");
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        sysRegistry.beginTransaction();
        while (zipentry != null) {
            String entryName = zipentry.getName();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            if (zipentry.isDirectory()) {
                Collection col = sysRegistry.newCollection();
                sysRegistry.put(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + CurrentSession.getUser() + "/gadget-server/themes" + "/" + entryName, (Resource)col);
            } else {
                if (entryName.indexOf("/") <= 0) {
                    sysRegistry.rollbackTransaction();
                    throw new RegistryException("Theme bundle is not in the correct format : {<Theme-Name>/style.css}");
                }
                Resource res = sysRegistry.newResource();
                try {
                    int i;
                    while ((i = zis.read(buff, 0, buff.length)) > 0) {
                        byteOut.write(buff, 0, i);
                    }
                }
                catch (IOException ioe) {
                    sysRegistry.rollbackTransaction();
                    log.error((Object)ioe);
                }
                if (zipentry.getName().contains("theme-conf.xml")) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(byteOut.toByteArray());
                    InputStreamReader isr = new InputStreamReader(bis);
                    sysRegistry.restore(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + CurrentSession.getUser() + "/gadget-server/themes" + "/" + entryName, (Reader)isr);
                } else {
                    res.setContent((Object)byteOut.toByteArray());
                    sysRegistry.put(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + CurrentSession.getUser() + "/gadget-server/themes" + "/" + entryName, res);
                }
            }
            try {
                zipentry = zis.getNextEntry();
            }
            catch (IOException e) {
                sysRegistry.rollbackTransaction();
                log.error((Object)e);
            }
        }
        sysRegistry.commitTransaction();
        requestContext.setProcessingComplete(true);
    }
}

