/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.theme;

import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.mgt.theme.common.Theme;
import org.wso2.carbon.dashboard.mgt.theme.constants.ThemeConstants;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GSThemeMgtAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(GSThemeMgtAdminService.class);

    public Theme[] getThemes(String user) throws Exception {
        if (!this.isUserAuthorized(user, "getThemes")) {
            log.error((Object)(user + " : is not properly authenticated"));
            return new Theme[0];
        }
        Registry themeRegistry = this.getConfigSystemRegistry();
        try {
            String thumbPath;
            String cssPath;
            Resource themeConf;
            Theme theme;
            int i;
            Collection themeCol = this.getDefaultThemes();
            Collection userThemeCol = this.getUserThemes(user);
            if (themeCol == null && userThemeCol == null) {
                return new Theme[0];
            }
            Theme[] gsThemes = new Theme[]{};
            Theme[] userThemes = new Theme[]{};
            if (themeCol != null) {
                gsThemes = new Theme[themeCol.getChildCount()];
                for (i = 0; i < themeCol.getChildCount(); ++i) {
                    theme = new Theme();
                    if (themeRegistry.resourceExists(themeCol.getChildren()[i]) && themeRegistry.resourceExists(themeCol.getChildren()[i] + ThemeConstants.THEME_CONF_PATH)) {
                        themeConf = themeRegistry.get(themeCol.getChildren()[i] + ThemeConstants.THEME_CONF_PATH);
                        if (themeRegistry.resourceExists(themeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_CSS))) {
                            cssPath = themeRegistry.get(themeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_CSS)).getPath();
                            theme.setCssUrl(cssPath);
                        }
                        if (themeRegistry.resourceExists(themeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_THUMB))) {
                            thumbPath = themeRegistry.get(themeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_THUMB)).getPath();
                            theme.setThumbUrl(thumbPath);
                        }
                        theme.setThemeName(themeConf.getProperty(ThemeConstants.PROP_NAME));
                        theme.setThemeAuthor(themeConf.getProperty(ThemeConstants.PROP_AUTHOR));
                        theme.setThemeDesc(themeConf.getProperty(ThemeConstants.PROP_DESC));
                    }
                    gsThemes[i] = theme;
                }
            }
            if (userThemeCol != null) {
                userThemes = new Theme[userThemeCol.getChildCount()];
                for (i = 0; i < userThemeCol.getChildCount(); ++i) {
                    theme = new Theme();
                    if (themeRegistry.resourceExists(userThemeCol.getChildren()[i]) && themeRegistry.resourceExists(userThemeCol.getChildren()[i] + ThemeConstants.THEME_CONF_PATH)) {
                        themeConf = themeRegistry.get(userThemeCol.getChildren()[i] + ThemeConstants.THEME_CONF_PATH);
                        if (themeRegistry.resourceExists(userThemeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_CSS))) {
                            cssPath = themeRegistry.get(userThemeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_CSS)).getPath();
                            theme.setCssUrl(cssPath);
                        }
                        if (themeRegistry.resourceExists(userThemeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_THUMB))) {
                            thumbPath = themeRegistry.get(userThemeCol.getChildren()[i] + "/" + themeConf.getProperty(ThemeConstants.PROP_THUMB)).getPath();
                            theme.setThumbUrl(thumbPath);
                        }
                        theme.setThemeName(themeConf.getProperty(ThemeConstants.PROP_NAME));
                        theme.setThemeAuthor(themeConf.getProperty(ThemeConstants.PROP_AUTHOR));
                        theme.setThemeDesc(themeConf.getProperty(ThemeConstants.PROP_DESC));
                    }
                    userThemes[i] = theme;
                }
            }
            Theme[] allThemes = new Theme[gsThemes.length + userThemes.length];
            System.arraycopy(gsThemes, 0, allThemes, 0, gsThemes.length);
            System.arraycopy(userThemes, 0, allThemes, gsThemes.length, userThemes.length);
            return allThemes;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Collection getDefaultThemes() {
        Registry themeRegistry = this.getConfigSystemRegistry();
        Collection defThemeCol = null;
        try {
            if (!themeRegistry.resourceExists("/repository/gadget-server/themes")) {
                log.debug((Object)"The theme directory is not created");
                return null;
            }
            defThemeCol = (Collection)themeRegistry.get("/repository/gadget-server/themes");
            if (defThemeCol.getChildCount() < 1) {
                log.error((Object)"There are no themes installed in the theme directory");
                return null;
            }
        }
        catch (RegistryException re) {
            log.error((Object)re);
        }
        return defThemeCol;
    }

    private Collection getUserThemes(String user) {
        Registry themeRegistry = this.getConfigSystemRegistry();
        Collection userThemeCol = null;
        try {
            if (!themeRegistry.resourceExists(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + "/gadget-server/themes")) {
                log.debug((Object)"The theme directory is not created");
                return null;
            }
            userThemeCol = (Collection)themeRegistry.get(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + "/gadget-server/themes");
            if (userThemeCol.getChildCount() < 1) {
                log.error((Object)"There are no themes installed in the theme directory");
                return null;
            }
        }
        catch (RegistryException re) {
            log.error((Object)re);
        }
        return userThemeCol;
    }

    public boolean setThemeForUser(String themePath, String user) throws Exception {
        Registry userThemeRegistry = this.getConfigSystemRegistry();
        try {
            if (!userThemeRegistry.resourceExists(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH)) {
                Resource defaultTheme = userThemeRegistry.newResource();
                defaultTheme.setProperty("theme.location", themePath);
                userThemeRegistry.put(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH, defaultTheme);
            } else {
                Resource defaultTheme = userThemeRegistry.get(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH);
                defaultTheme.setProperty("theme.location", themePath);
                userThemeRegistry.put(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH, defaultTheme);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String getDefaultThemeForUser(String user) throws Exception {
        Registry userThemeRegistry = this.getConfigSystemRegistry();
        String themePath = null;
        try {
            if (userThemeRegistry.resourceExists(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH)) {
                Resource defTheme = userThemeRegistry.get(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH);
                themePath = defTheme.getProperty("theme.location");
            }
            return themePath;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private boolean isUserAuthorized(String username, String operation) {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            if (!username.equals(userName)) {
                log.warn((Object)("Unauthorised action by user '" + username + "' to access " + operation + " denied."));
                return false;
            }
            return true;
        }
        log.warn((Object)("Unauthorised action by user '" + username + "' to access " + operation + " denied."));
        return false;
    }

    public void addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation) throws Exception {
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        this.addResourceToRegistry(path, mediaType, description, content, symlinkLocation, (Registry)registry);
    }

    private void addResourceToRegistry(String path, String mediaType, String description, DataHandler content, String symlinkLocation, Registry registry) throws Exception {
        try {
            ResourceImpl resourceImpl = (ResourceImpl)registry.newResource();
            resourceImpl.setMediaType(mediaType);
            resourceImpl.setDescription(description);
            resourceImpl.setContentStream(content.getInputStream());
            if (symlinkLocation != null) {
                if (!symlinkLocation.endsWith("/")) {
                    symlinkLocation = symlinkLocation + "/";
                }
                resourceImpl.setProperty("SymlinkPropertyName", symlinkLocation);
            }
            registry.put(path, (Resource)resourceImpl);
            resourceImpl.discard();
        }
        catch (Exception e) {
            String msg = "Failed to add resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void rollbackToDefaultGSTheme(String user) throws Exception {
        Registry userThemeRegistry = this.getConfigSystemRegistry();
        if (userThemeRegistry.resourceExists(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH)) {
            userThemeRegistry.delete(DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + user + DashboardConstants.GS_DEFAULT_THEME_PATH);
        }
    }
}

