/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.oauth.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dashboard.mgt.oauth.stub.OAuthMgtServiceStub;
import org.wso2.carbon.dashboard.mgt.oauth.stub.types.carbon.ConsumerEntry;

public class OAuthMgtServiceClient {
    private static final Log log = LogFactory.getLog(OAuthMgtServiceClient.class);
    public OAuthMgtServiceStub stub;

    public OAuthMgtServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "OAuthMgtService";
        this.stub = new OAuthMgtServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public ConsumerEntry[] getConsumerEntries() {
        ConsumerEntry[] entries = new ConsumerEntry[]{};
        try {
            entries = this.stub.getConsumerEntries();
            if (entries == null) {
                return new ConsumerEntry[0];
            }
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return entries;
    }

    public ConsumerEntry[] getConsumerPagedEntries(int pageNum) {
        ConsumerEntry[] entries = new ConsumerEntry[]{};
        try {
            entries = this.stub.getConsumerPagedEntries(pageNum);
            if (entries == null) {
                return new ConsumerEntry[0];
            }
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return entries;
    }

    public boolean addConsumerEntry(ConsumerEntry entry, String mode) {
        try {
            boolean ret = this.stub.addConsumerEntry(entry, mode);
            return ret;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public ConsumerEntry getConsumerEntry(String consumerServiceName) {
        try {
            return this.stub.getConsumerEntry(consumerServiceName);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getNumberOfPages() {
        try {
            return this.stub.getNumberOfPages();
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public boolean deleteConsumerEntry(String consumerServiceName) {
        try {
            this.stub.deleteConsumerEntry(consumerServiceName);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

