/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.oauth;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dashboard.common.OAuthUtils;
import org.wso2.carbon.dashboard.common.oauth.RegistryBasedOAuthStore;
import org.wso2.carbon.dashboard.mgt.oauth.bean.ConsumerEntry;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class OAuthMgtService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(OAuthMgtService.class);
    private static final int NUMBER_OF_ENTRIES_PER_PAGE = 5;

    public ConsumerEntry[] getConsumerEntries() throws AxisFault {
        ConsumerEntry[] entries;
        block4: {
            Registry reg = this.getConfigSystemRegistry();
            try {
                if (reg.resourceExists("/repository/gadget-server/oauth")) {
                    Collection oauthKeyCollection = (Collection)reg.get("/repository/gadget-server/oauth");
                    entries = new ConsumerEntry[oauthKeyCollection.getChildCount()];
                    for (int i = 0; i < oauthKeyCollection.getChildCount(); ++i) {
                        Resource res = reg.get(oauthKeyCollection.getChildren()[i]);
                        ConsumerEntry entry = new ConsumerEntry();
                        entry.setConsumerKey(res.getProperty("consumer_key"));
                        entry.setConsumerSecret(res.getProperty("consumer_secret"));
                        entry.setKeyType(res.getProperty("key_type"));
                        entry.setService(res.getProperty("consumer_service"));
                        entries[i] = entry;
                    }
                    break block4;
                }
                return new ConsumerEntry[0];
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        return entries;
    }

    public ConsumerEntry[] getConsumerPagedEntries(int pageNum) throws AxisFault {
        ConsumerEntry[] entries;
        block4: {
            Registry reg = this.getConfigSystemRegistry();
            int startEntry = pageNum * 5;
            try {
                if (reg.resourceExists("/repository/gadget-server/oauth")) {
                    Collection oauthKeyCollection = (Collection)reg.get("/repository/gadget-server/oauth");
                    int childCount = oauthKeyCollection.getChildCount();
                    entries = childCount <= 5 ? new ConsumerEntry[childCount] : (childCount < startEntry + 5 ? new ConsumerEntry[childCount - startEntry] : new ConsumerEntry[5]);
                    for (int i = 0; i < childCount && i < 5 && i + startEntry < childCount; ++i) {
                        Resource res = reg.get(oauthKeyCollection.getChildren()[i + startEntry]);
                        ConsumerEntry entry = new ConsumerEntry();
                        entry.setConsumerKey(res.getProperty("consumer_key"));
                        entry.setConsumerSecret(res.getProperty("consumer_secret"));
                        entry.setKeyType(res.getProperty("key_type"));
                        entry.setService(res.getProperty("consumer_service"));
                        entries[i] = entry;
                    }
                    break block4;
                }
                return new ConsumerEntry[0];
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        return entries;
    }

    public boolean addConsumerEntry(ConsumerEntry entry, String mode) throws AxisFault {
        Registry reg = this.getConfigSystemRegistry();
        if (entry == null) {
            throw new AxisFault("OAuth Entry is null", (Throwable)new IllegalArgumentException());
        }
        try {
            if (reg.resourceExists("/repository/gadget-server/oauth/" + entry.getService()) && "new".equals(mode)) {
                throw new AxisFault("Consumer already exists", (Throwable)new IllegalArgumentException());
            }
            Resource res = reg.newResource();
            if ("update".equals(mode)) {
                res = reg.get("/repository/gadget-server/oauth/" + entry.getService());
            }
            res.setProperty("consumer_key", entry.getConsumerKey());
            res.setProperty("consumer_secret", entry.getConsumerSecret());
            res.setProperty("key_type", entry.getKeyType());
            res.setProperty("consumer_service", entry.getService());
            reg.put("/repository/gadget-server/oauth/" + entry.getService(), res);
            int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
            RegistryBasedOAuthStore store = (RegistryBasedOAuthStore)OAuthUtils.getOauthStoreProvider().getStore(tenantId);
            try {
                store.initFromConfigString(reg, (Collection)reg.get("/repository/gadget-server/oauth"));
                log.debug((Object)("RegistryBasedOAuthStore initialized FromConfigString for tenant ID = " + tenantId));
            }
            catch (GadgetException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public ConsumerEntry getConsumerEntry(String consumerServiceName) throws AxisFault {
        ConsumerEntry entry = new ConsumerEntry();
        Registry reg = this.getConfigSystemRegistry();
        try {
            if (reg.resourceExists("/repository/gadget-server/oauth/" + consumerServiceName)) {
                Resource res = reg.get("/repository/gadget-server/oauth/" + consumerServiceName);
                entry.setConsumerKey(res.getProperty("consumer_key"));
                entry.setConsumerSecret(res.getProperty("consumer_secret"));
                entry.setKeyType(res.getProperty("key_type"));
                entry.setService(res.getProperty("consumer_service"));
                return entry;
            }
            return null;
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public boolean deleteConsumerEntry(String consumerServiceName) throws AxisFault {
        ConsumerEntry entry = new ConsumerEntry();
        Registry reg = this.getConfigSystemRegistry();
        try {
            if (reg.resourceExists("/repository/gadget-server/oauth/" + consumerServiceName)) {
                reg.delete("/repository/gadget-server/oauth/" + consumerServiceName);
                return true;
            }
            throw new AxisFault("No such consumer to remove", (Throwable)new IllegalArgumentException());
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public int getNumberOfPages() {
        int intVal = this.getNumberOfEntries() / 5;
        int rem = this.getNumberOfEntries() % 5;
        if (intVal > 0 && rem > 0) {
            return intVal + 1;
        }
        if (intVal == 0 && rem > 0) {
            return 1;
        }
        if (intVal > 0 && rem == 0) {
            return intVal;
        }
        return 1;
    }

    private int getNumberOfEntries() {
        Registry reg = this.getConfigSystemRegistry();
        try {
            if (reg.resourceExists("/repository/gadget-server/oauth")) {
                Collection oauthKeyCollection = (Collection)reg.get("/repository/gadget-server/oauth");
                return oauthKeyCollection.getChildCount();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }
}

