/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.gadgetrepo.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.GadgetRepoContext;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.GadgetRepoService;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.handlers.GadgetZipUploadHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.MediaTypeMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;

public class GadgetRepoServiceComponent {
    private static final Log log = LogFactory.getLog(GadgetRepoServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            log.debug((Object)"Gadget Repository Backend Component bundle is activated");
            GadgetRepoContext.getRegistryService().getConfigSystemRegistry().getRegistryContext().getHandlerManager().addHandler(null, (Filter)new MediaTypeMatcher("application/vnd.wso2.gs.gadget"), (Handler)new GadgetZipUploadHandler());
            context.getBundleContext().registerService(GadgetRepoService.class.getName(), (Object)new GadgetRepoService(), null);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to activate Dashboard Backend Component bundle ");
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Dashboard Backend Component bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        GadgetRepoContext.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        GadgetRepoContext.setRegistryService(null);
    }

    protected void setUserRealm(UserRealm userRealm) {
        GadgetRepoContext.setUserRealm(userRealm);
    }

    protected void unsetUserRealm(UserRealm usrRealm) {
        GadgetRepoContext.setUserRealm(null);
    }
}

