/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.gadgetrepo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dashboard.DashboardService;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.common.bean.Comment;
import org.wso2.carbon.dashboard.common.bean.Gadget;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.GadgetRepoException;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.common.CommentSortById;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.social.api.activity.Activity;
import org.wso2.carbon.registry.social.impl.activity.ActivityImpl;
import org.wso2.carbon.registry.social.impl.activity.ActivityManagerImpl;
import org.wso2.carbon.user.core.UserStoreException;

public class GadgetRepoService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(GadgetRepoService.class);

    public Gadget[] getGadgetData() {
        List<Resource> rsList = this.getGadgetResList();
        if (rsList == null) {
            return null;
        }
        Gadget[] gadgetList = new Gadget[rsList.size()];
        try {
            Registry registry = this.getConfigSystemRegistry();
            for (int i = 0; i < rsList.size(); ++i) {
                Resource tempRes = rsList.get(i);
                if (tempRes.getProperty(DashboardConstants.GADGET_NAME) == null || tempRes.getProperty(DashboardConstants.GADGET_URL) == null) continue;
                Gadget tempGadget = new Gadget();
                tempGadget.setGadgetName(tempRes.getProperty(DashboardConstants.GADGET_NAME));
                tempGadget.setGadgetUrl(tempRes.getProperty(DashboardConstants.GADGET_URL));
                if (tempRes.getProperty(DashboardConstants.GADGET_DESC) != null) {
                    tempGadget.setGadgetDesc(tempRes.getProperty(DashboardConstants.GADGET_DESC));
                } else {
                    tempGadget.setGadgetDesc("");
                }
                if (tempRes.getProperty(DashboardConstants.USER_CONTER) != null) {
                    tempGadget.setUserCount(tempRes.getProperty(DashboardConstants.USER_CONTER));
                }
                if (tempRes.getProperty(DashboardConstants.DEFAULT_GADGET) != null) {
                    tempGadget.setDefaultGadget(tempRes.getProperty(DashboardConstants.DEFAULT_GADGET));
                }
                if (tempRes.getProperty(DashboardConstants.UNSIGNED_USER_GADGET) != null) {
                    tempGadget.setUnsignedUserGadget(tempRes.getProperty(DashboardConstants.UNSIGNED_USER_GADGET));
                }
                if (tempRes.getProperty("thumbUrl") != null) {
                    tempGadget.setThumbUrl(tempRes.getProperty("thumbUrl"));
                }
                tempGadget.setGadgetPath(tempRes.getPath());
                tempGadget.setRating(Float.valueOf(registry.getAverageRating(tempRes.getPath())));
                gadgetList[i] = tempGadget;
            }
            return gadgetList;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not return the gadget list:", (Throwable)e);
            return null;
        }
    }

    private List<Resource> getGadgetResList() {
        ArrayList<Resource> resList = new ArrayList<Resource>();
        String gadgetRootPath = DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT;
        String gadgetRepoPath = gadgetRootPath + DashboardConstants.GADGETS_COL;
        String nextGadgetIdPath = gadgetRootPath + DashboardConstants.GADGETS_COL + DashboardConstants.NEXT_GADGET_ID_PATH;
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(nextGadgetIdPath)) {
                Collection gadgets = (Collection)registry.get(gadgetRepoPath);
                int gadgetCount = gadgets.getChildCount();
                String[] gadgetPaths = gadgets.getChildren();
                for (int i = 0; i < gadgetCount; ++i) {
                    if (!registry.resourceExists(gadgetPaths[i])) continue;
                    Resource tempRes = registry.get(gadgetPaths[i]);
                    resList.add(tempRes);
                }
                return resList;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not retrive gadget meta data or repository is not yet created", (Throwable)e);
            return null;
        }
    }

    public Boolean addGadgetToRepo(String gName, String gUrl, String gDesc, String gScreen, String screenMediaType) {
        Registry registry = null;
        try {
            Resource nextGadgetIdRes;
            if (this.gadgetUrlExists(gUrl).booleanValue()) {
                return false;
            }
            registry = this.getConfigSystemRegistry();
            String gadgetRootPath = DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT;
            String gadgetRepoPath = gadgetRootPath + DashboardConstants.GADGETS_COL;
            String nextGadgetIdPath = gadgetRootPath + DashboardConstants.GADGETS_COL + DashboardConstants.NEXT_GADGET_ID_PATH;
            registry.beginTransaction();
            if (!registry.resourceExists(gadgetRootPath)) {
                Collection gadgetCol = registry.newCollection();
                registry.put(gadgetRepoPath, (Resource)gadgetCol);
            }
            if (!registry.resourceExists(nextGadgetIdPath)) {
                nextGadgetIdRes = registry.newResource();
                nextGadgetIdRes.setProperty(DashboardConstants.NEXT_GADGET_ID, "0");
                registry.put(nextGadgetIdPath, nextGadgetIdRes);
            }
            nextGadgetIdRes = registry.get(nextGadgetIdPath);
            String gadgetIdStr = nextGadgetIdRes.getProperty(DashboardConstants.NEXT_GADGET_ID);
            int gadgetId = Integer.parseInt(gadgetIdStr);
            Resource gadget = registry.newResource();
            gadget.setProperty(DashboardConstants.GADGET_NAME, gName);
            gadget.setProperty(DashboardConstants.GADGET_URL, gUrl);
            gadget.setProperty(DashboardConstants.GADGET_DESC, gDesc);
            gadget.setProperty(DashboardConstants.DEFAULT_GADGET, "false");
            byte[] imgData = Base64.decode((String)gScreen);
            gadget.setContent((Object)imgData);
            gadget.setMediaType(screenMediaType);
            registry.put(gadgetRepoPath + DashboardConstants.GADGET_PREFIX + gadgetIdStr, gadget);
            int nextId = gadgetId + 1;
            nextGadgetIdRes.setProperty(DashboardConstants.NEXT_GADGET_ID, Integer.toString(nextId));
            registry.put(nextGadgetIdPath, nextGadgetIdRes);
            registry.commitTransaction();
            if (this.getConfigUserRegistry() instanceof UserRegistry) {
                String userId = ((UserRegistry)this.getConfigUserRegistry()).getUserName();
                ActivityManagerImpl manager = new ActivityManagerImpl();
                ActivityImpl activity = new ActivityImpl();
                activity.setTitle("added " + gName + "gadget to the gadget repository");
                activity.setUrl(gUrl);
                activity.setBody(gScreen);
                manager.createActivity(userId, "self", "gs", null, (Activity)activity);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to save the new gadget : " + e));
            if (registry != null) {
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
            return null;
        }
    }

    private boolean isGadgetAutharized(String user, String gadgetUrl) throws UserStoreException {
        if (!gadgetUrl.startsWith("/registry")) {
            return true;
        }
        gadgetUrl = gadgetUrl.split("path=")[1];
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        return registry.getUserRealm().getAuthorizationManager().isUserAuthorized(user, gadgetUrl, "http://www.wso2.org/projects/registry/actions/get");
    }

    public Boolean addGadget(String userId, String tabId, String url, String dashboardName, String gadgetGroup, String gadgetPath) {
        Boolean response;
        block5: {
            response = false;
            Object registry = null;
            try {
                DashboardService dashboardService = new DashboardService();
                response = dashboardService.addGadgetToUser(userId, tabId, url, dashboardName, gadgetGroup);
                if (response.booleanValue()) {
                    ActivityManagerImpl manager = new ActivityManagerImpl();
                    ActivityImpl activity = new ActivityImpl();
                    activity.setTitle("added new Gadget to the Dashboard ");
                    String gadgetViewUrl = "../gadgetrepo/gadget-page.jsp?gadgetPath=" + gadgetPath + "&tab=" + tabId + "&grp=" + gadgetGroup.substring(0, gadgetGroup.indexOf("#"));
                    activity.setUrl(gadgetViewUrl);
                    manager.createActivity(userId, "self", "gs", null, (Activity)activity);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                if (registry == null) break block5;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
        }
        return response;
    }

    public Boolean isReadOnlyMode(String userId) {
        if (userId == null || "null".equals(userId)) {
            return true;
        }
        Boolean resp = true;
        try {
            String[] userRoles = this.getUserRealm().getUserStoreManager().getRoleListOfUser(userId);
            for (int x = 0; x < userRoles.length; ++x) {
                if (!"admin".equals(userRoles[x])) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return resp;
    }

    public Boolean deleteGadget(String gadgetPath) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(gadgetPath)) {
                registry.delete(gadgetPath);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not delete the resource from the registry", (Throwable)e);
            return false;
        }
    }

    public Gadget getGadget(String gadgetPath) {
        Gadget gadget = null;
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(gadgetPath)) {
                Resource temp = registry.get(gadgetPath);
                gadget = new Gadget();
                if (temp.getProperty(DashboardConstants.GADGET_NAME) != null) {
                    gadget.setGadgetName(temp.getProperty(DashboardConstants.GADGET_NAME));
                }
                if (temp.getProperty(DashboardConstants.GADGET_URL) != null) {
                    gadget.setGadgetUrl(temp.getProperty(DashboardConstants.GADGET_URL));
                }
                if (temp.getProperty(DashboardConstants.GADGET_DESC) != null) {
                    gadget.setGadgetDesc(temp.getProperty(DashboardConstants.GADGET_DESC));
                } else {
                    gadget.setGadgetDesc("");
                }
                if (temp.getProperty(DashboardConstants.USER_CONTER) != null) {
                    gadget.setUserCount(temp.getProperty(DashboardConstants.USER_CONTER));
                }
                if (temp.getProperty(DashboardConstants.DEFAULT_GADGET) != null) {
                    gadget.setDefaultGadget(temp.getProperty(DashboardConstants.DEFAULT_GADGET));
                }
                if (temp.getProperty(DashboardConstants.UNSIGNED_USER_GADGET) != null) {
                    gadget.setUnsignedUserGadget(temp.getProperty(DashboardConstants.UNSIGNED_USER_GADGET));
                }
                if (temp.getProperty("thumbUrl") != null) {
                    gadget.setThumbUrl(temp.getProperty("thumbUrl"));
                }
                gadget.setGadgetPath(temp.getPath());
                gadget.setRating(Float.valueOf(registry.getAverageRating(temp.getPath())));
            }
            return gadget;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not retrive the gadget", (Throwable)e);
            return null;
        }
    }

    public Boolean modifyGadget(String gadegtPath, String gName, String gUrl, String gDesc, String gScreen, String screenMediaType) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(gadegtPath)) {
                Resource gadget = registry.get(gadegtPath);
                if (!gadget.getProperty(DashboardConstants.GADGET_URL).equals(gUrl) && this.gadgetUrlExists(gUrl).booleanValue()) {
                    return false;
                }
                gadget.setProperty(DashboardConstants.GADGET_NAME, gName);
                gadget.setProperty(DashboardConstants.GADGET_URL, gUrl);
                gadget.setProperty(DashboardConstants.GADGET_DESC, gDesc);
                if (gScreen != null && !gScreen.equals("")) {
                    byte[] imgData = Base64.decode((String)gScreen);
                    gadget.setContent((Object)imgData);
                    gadget.setMediaType(screenMediaType);
                } else {
                    gadget.setContent(gadget.getContent());
                }
                registry.put(gadegtPath, gadget);
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not modify gadget", (Throwable)e);
            return null;
        }
        return false;
    }

    public Boolean addCommentForGadget(String gadgetPath, Comment comment) {
        try {
            Registry registry = this.getConfigUserRegistry();
            org.wso2.carbon.registry.core.Comment gadgetComment = new org.wso2.carbon.registry.core.Comment();
            gadgetComment.setAuthorUserName(comment.getAuthorUserName());
            gadgetComment.setText(comment.getCommentText());
            gadgetComment.setCreatedTime(new Date());
            registry.addComment(gadgetPath, gadgetComment);
            ActivityManagerImpl manager = new ActivityManagerImpl();
            ActivityImpl activity = new ActivityImpl();
            activity.setTitle("commented on Gadget");
            activity.setUrl("../" + comment.getCommentPath());
            activity.setBody(comment.getCommentText());
            manager.createActivity(comment.getAuthorUserName(), "self", "gs", null, (Activity)activity);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not make the comment", (Throwable)e);
            return false;
        }
    }

    public Boolean addRatingForGadget(String gadgetPath, int rating, String tabId, String gadgetGroup) {
        try {
            Registry registry = this.getConfigUserRegistry();
            registry.rateResource(gadgetPath, rating);
            if (registry instanceof UserRegistry) {
                String userId = ((UserRegistry)registry).getUserName();
                ActivityManagerImpl manager = new ActivityManagerImpl();
                ActivityImpl activity = new ActivityImpl();
                activity.setTitle("rated gadget with rating: " + rating);
                String gadgetViewUrl = "../gadgetrepo/gadget-page.jsp?gadgetPath=" + gadgetPath + "&tab=" + tabId + "&grp=" + gadgetGroup;
                activity.setUrl(gadgetViewUrl);
                activity.setBody(rating + "");
                manager.createActivity(userId, "self", "gs", null, (Activity)activity);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not rate the resource", (Throwable)e);
            return false;
        }
    }

    public Boolean deleteComment(String path) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            registry.delete(path);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not delete the comment", (Throwable)e);
            return false;
        }
    }

    public Boolean isAdmin(String userId) {
        try {
            String[] roles;
            for (String role : roles = this.getUserRealm().getUserStoreManager().getRoleListOfUser(userId)) {
                if (!"admin".equals(role)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not retrive the user realm", (Throwable)e);
            return false;
        }
    }

    public Boolean userHasGadget(String gadgetPath) {
        String userName = (String)this.getHttpSession().getAttribute("wso2carbon.admin.logged.in");
        try {
            String[] gadgets;
            Registry registry = this.getConfigSystemRegistry();
            Resource addedGadget = registry.get(gadgetPath);
            String gadgetUrl = addedGadget.getProperty("gadgetUrl");
            String pathToUserGadgets = DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userName + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH;
            Collection gadgetCol = (Collection)registry.get(pathToUserGadgets);
            for (String gPath : gadgets = gadgetCol.getChildren()) {
                Resource gadget = registry.get(gPath);
                if (!gadgetUrl.equals(gadget.getProperty("gadgetUrl"))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean incrementUserCount(String gadgetPath) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (gadgetPath == null || "null".equals(gadgetPath) || this.userHasGadget(gadgetPath).booleanValue()) {
                return false;
            }
            if (registry.resourceExists(gadgetPath)) {
                Integer userCount;
                Resource gadget = registry.get(gadgetPath);
                String userCountStr = gadget.getProperty(DashboardConstants.USER_CONTER);
                if (userCountStr == null) {
                    userCount = 1;
                } else {
                    Integer n = userCount = Integer.valueOf(Integer.parseInt(userCountStr));
                    Integer n2 = userCount = Integer.valueOf(userCount + 1);
                }
                gadget.setProperty(DashboardConstants.USER_CONTER, userCount.toString());
                registry.put(gadgetPath, gadget);
                return true;
            }
            log.error((Object)"Backend server error : Gadget Path does not exist");
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not increment the user counter", (Throwable)e);
            return false;
        }
    }

    public String getUserRating(String gadgetPath, String userId) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (gadgetPath == null || "null".equals(gadgetPath)) {
                return null;
            }
            if (registry.resourceExists(gadgetPath)) {
                int ratVal = registry.getRating(gadgetPath, userId);
                return Integer.toString(ratVal);
            }
            log.error((Object)"Backend server error : Gadget Path does not exist");
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not get rating for the user", (Throwable)e);
            return null;
        }
    }

    public Boolean isExternalGadgetAdditionEnabled() {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_EXTERNAL_GADGET_ADD_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Integer getCollectionSize() {
        String gadgetRootPath = DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT;
        String gadgetRepoPath = gadgetRootPath + DashboardConstants.GADGETS_COL;
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(gadgetRepoPath)) {
                Collection gadgetCol = (Collection)registry.get(gadgetRepoPath);
                return gadgetCol.getChildCount();
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Gadget[] getGadgetDataPag(int upper, int lower) {
        List<Resource> rsList = this.getGadgetResList(upper, lower);
        if (rsList == null) {
            return null;
        }
        Gadget[] gadgetList = new Gadget[rsList.size()];
        try {
            Registry registry = this.getConfigSystemRegistry();
            for (int i = 0; i < rsList.size(); ++i) {
                Resource tempRes = rsList.get(i);
                if (tempRes.getProperty(DashboardConstants.GADGET_NAME) == null || tempRes.getProperty(DashboardConstants.GADGET_URL) == null) continue;
                Gadget tempGadget = new Gadget();
                tempGadget.setGadgetName(tempRes.getProperty(DashboardConstants.GADGET_NAME));
                tempGadget.setGadgetUrl(tempRes.getProperty(DashboardConstants.GADGET_URL));
                if (tempRes.getProperty(DashboardConstants.GADGET_DESC) != null) {
                    tempGadget.setGadgetDesc(tempRes.getProperty(DashboardConstants.GADGET_DESC));
                } else {
                    tempGadget.setGadgetDesc("");
                }
                if (tempRes.getProperty(DashboardConstants.USER_CONTER) != null) {
                    tempGadget.setUserCount(tempRes.getProperty(DashboardConstants.USER_CONTER));
                }
                if (tempRes.getProperty(DashboardConstants.DEFAULT_GADGET) != null) {
                    tempGadget.setDefaultGadget(tempRes.getProperty(DashboardConstants.DEFAULT_GADGET));
                }
                if (tempRes.getProperty(DashboardConstants.UNSIGNED_USER_GADGET) != null) {
                    tempGadget.setUnsignedUserGadget(tempRes.getProperty(DashboardConstants.UNSIGNED_USER_GADGET));
                }
                if (tempRes.getProperty("thumbUrl") != null) {
                    tempGadget.setThumbUrl(tempRes.getProperty("thumbUrl"));
                }
                tempGadget.setGadgetPath(tempRes.getPath());
                tempGadget.setRating(Float.valueOf(registry.getAverageRating(tempRes.getPath())));
                gadgetList[i] = tempGadget;
            }
            return gadgetList;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not return the gadget list : ", (Throwable)e);
            return null;
        }
    }

    private List<Resource> getGadgetResList(int upper, int lower) {
        ArrayList<Resource> resList = new ArrayList<Resource>();
        String gadgetRootPath = DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT;
        String gadgetRepoPath = gadgetRootPath + DashboardConstants.GADGETS_COL;
        String nextGadgetIdPath = gadgetRootPath + DashboardConstants.GADGETS_COL + DashboardConstants.NEXT_GADGET_ID_PATH;
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(nextGadgetIdPath)) {
                Collection gadgets = (Collection)registry.get(gadgetRepoPath);
                int gadgetCount = gadgets.getChildCount();
                String[] gadgetPaths = gadgets.getChildren();
                for (int i = 0; i < gadgetCount; ++i) {
                    Resource tempRes;
                    if (!registry.resourceExists(gadgetPaths[i]) || (tempRes = registry.get(gadgetPaths[i])).getId().equals(nextGadgetIdPath)) continue;
                    resList.add(tempRes);
                }
                Comparator<Resource> creationTimeComparator = new Comparator<Resource>(){

                    @Override
                    public int compare(Resource r1, Resource r2) {
                        Date createdTime2;
                        Date createdTime1 = r1.getCreatedTime();
                        if (createdTime1.compareTo(createdTime2 = r2.getCreatedTime()) > 0) {
                            return -1;
                        }
                        if (createdTime1.compareTo(createdTime2) < 0) {
                            return 1;
                        }
                        return 0;
                    }
                };
                Collections.sort(resList, creationTimeComparator);
                int lowerBound = lower + upper;
                if (lowerBound > gadgetCount) {
                    lowerBound = gadgetCount - 1;
                }
                ArrayList<Resource> subResList = new ArrayList<Resource>();
                for (int i = upper; i < lowerBound; ++i) {
                    if (resList.size() <= i) continue;
                    subResList.add((Resource)resList.get(i));
                }
                return subResList;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - pagination method : Could not retrive gadget meta data or repository is not yet created", (Throwable)e);
            return null;
        }
    }

    public Integer getCommentsCount(String resPath) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            return registry.getComments(resPath).length;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the comment count", (Throwable)e);
            return null;
        }
    }

    public Comment[] getCommentSet(String resPath, int start, int size) {
        try {
            int end;
            Registry registry = this.getConfigSystemRegistry();
            org.wso2.carbon.registry.core.Comment[] commentsInFull = registry.getComments(resPath);
            if (start < 0) {
                start = 0;
            }
            if ((end = start + size) > commentsInFull.length) {
                end = start + (commentsInFull.length - start);
            }
            Arrays.sort(commentsInFull, new CommentSortById());
            List<org.wso2.carbon.registry.core.Comment> commentList = Arrays.asList(commentsInFull).subList(start, end);
            if (commentList == null && commentList.size() == 0) {
                log.error((Object)"Backend server error - Comment set is empty");
                return null;
            }
            Comment[] gadgetComments = new Comment[commentList.size()];
            for (int p = 0; p < commentList.size(); ++p) {
                Comment tempCom = new Comment();
                tempCom.setCommentPath(commentList.get(p).getCommentPath());
                tempCom.setAuthorUserName(commentList.get(p).getAuthorUserName());
                tempCom.setCommentText(commentList.get(p).getText());
                tempCom.setCreateTime(commentList.get(p).getCreatedTime());
                gadgetComments[p] = tempCom;
            }
            return gadgetComments;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the comment set", (Throwable)e);
            return null;
        }
    }

    public Boolean makeGadgetDefault(String gadgetPath, Boolean isMakeDefault) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(gadgetPath)) {
                Resource res = registry.get(gadgetPath);
                if (isMakeDefault.booleanValue()) {
                    res.setProperty(DashboardConstants.DEFAULT_GADGET, "true");
                } else {
                    res.setProperty(DashboardConstants.DEFAULT_GADGET, "false");
                }
                registry.put(gadgetPath, res);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String[] getDefaultGadgetUrlSet() {
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='" + DashboardConstants.DEFAULT_GADGET + "' AND " + "P.REG_VALUE='true' AND " + "P.REG_ID=RP.REG_PROPERTY_ID AND " + "PA.REG_PATH_ID=R.REG_PATH_ID";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("query", sql);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query3", map);
            String[] qPaths = (String[])qResults.getContent();
            String[] urls = new String[qPaths.length];
            for (int i = 0; i < qPaths.length; ++i) {
                if (!registry.resourceExists(qPaths[i])) continue;
                urls[i] = registry.get(qPaths[i]).getProperty(DashboardConstants.GADGET_URL);
            }
            return urls;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the comment set", (Throwable)e);
            return null;
        }
    }

    public Boolean makeUnsignedUserGadget(String gadgetPath, Boolean isMakeDefault) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(gadgetPath)) {
                Resource res = registry.get(gadgetPath);
                if (isMakeDefault.booleanValue()) {
                    res.setProperty(DashboardConstants.UNSIGNED_USER_GADGET, "true");
                } else {
                    res.setProperty(DashboardConstants.UNSIGNED_USER_GADGET, "false");
                }
                registry.put(gadgetPath, res);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Boolean gadgetUrlExists(String newUrl) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String gadgetMetaDataPath = "/_system/config" + DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT + DashboardConstants.GADGETS_COL;
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='gadgetUrl' AND P.REG_VALUE LIKE ? AND P.REG_ID=RP.REG_PROPERTY_ID AND PA.REG_PATH_ID=R.REG_PATH_ID AND PA.REG_PATH_VALUE='" + gadgetMetaDataPath + "'";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("1", newUrl.trim());
            params.put("query", sql);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query4", params);
            String[] qPaths = (String[])qResults.getContent();
            return qPaths.length != 0;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could validate the url for duplicates", (Throwable)e);
            return false;
        }
    }

    public Boolean deleteGadgetImage(String path) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(path)) {
                Resource tempRes = registry.get(path);
                if (tempRes.getProperty("thumbUrl") != null) {
                    tempRes.removeProperty("thumbUrl");
                }
                registry.put(path, tempRes);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String addGadgetToRegistryFromFile(DataHandler gadgetContent, String gName) throws GadgetRepoException {
        Registry registry = null;
        try {
            registry = this.getConfigSystemRegistry();
            String regGadgetPath = DashboardConstants.GS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH + gName + "/" + gName;
            Resource gadget = registry.newResource();
            gadget.setContentStream(gadgetContent.getInputStream());
            gadget.setMediaType("application/vnd.wso2-gadget+xml");
            if (!registry.resourceExists(regGadgetPath)) {
                registry.put(regGadgetPath, gadget);
            }
            String gadgetPath = "/registry/resource/_system/config" + regGadgetPath;
            return gadgetPath;
        }
        catch (Exception e) {
            throw new GadgetRepoException(e);
        }
    }

    private String[] addGadgetToRegistryFromZip(DataHandler gadgetContent, String gName) throws GadgetRepoException {
        String[] returnArray = new String[2];
        String configRegistryPath = "/registry/resource/_system/config";
        String regGadgetPath = DashboardConstants.GS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH + gName + "/";
        String gadgetPath = configRegistryPath + regGadgetPath;
        String thumbPath = configRegistryPath + regGadgetPath;
        ZipInputStream zipInputStream = null;
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource gadget = registry.newResource();
            gadget.setContentStream(gadgetContent.getInputStream());
            gadget.setMediaType("application/vnd.wso2.gs.gadget");
            gadget.setProperty(DashboardConstants.GADGET_NAME, gName);
            if (!registry.resourceExists(regGadgetPath)) {
                registry.put(regGadgetPath, gadget);
            }
            zipInputStream = new ZipInputStream(gadget.getContentStream());
            ZipEntry zipentry = null;
            try {
                zipentry = zipInputStream.getNextEntry();
                if (zipentry == null) {
                    throw new GadgetRepoException("Gadget bundle should be a zip file");
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            while (zipentry != null) {
                String entryName = zipentry.getName();
                if (!zipentry.isDirectory()) {
                    if (entryName.contains(".xml")) {
                        gadgetPath = gadgetPath + entryName;
                    }
                    if (entryName.contains("thumb")) {
                        thumbPath = thumbPath + entryName;
                    }
                }
                try {
                    zipentry = zipInputStream.getNextEntry();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add gadget to registry from Zip file.");
            throw new GadgetRepoException(e);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        returnArray[0] = !(configRegistryPath + regGadgetPath).equals(gadgetPath.toString()) ? gadgetPath.toString() : null;
        returnArray[1] = !(configRegistryPath + regGadgetPath).equals(thumbPath.toString()) ? thumbPath.toString() : null;
        return returnArray;
    }

    private String addGadgetToRegistryFromRegistry(String regPath) throws GadgetRepoException {
        Registry registry = null;
        try {
            registry = this.getConfigSystemRegistry();
            Resource gadget = registry.get(regPath);
            gadget.setMediaType("application/vnd.wso2-gadget+xml");
            String gadgetPath = "/registry/resource/_system/config" + regPath;
            return gadgetPath;
        }
        catch (Exception e) {
            throw new GadgetRepoException(e);
        }
    }

    public Boolean addGadgetEntryToRepo(String gName, String gUrl, String gDesc, DataHandler gScreen, String screenMediaType, DataHandler gadgetContent) {
        Registry registry = null;
        String thumbRegistryPath = null;
        try {
            Resource nextGadgetIdRes;
            if (gUrl != null && !"".equals(gUrl) && "conf:".equals(gUrl.substring(0, 5))) {
                gUrl = this.addGadgetToRegistryFromRegistry(gUrl.substring(5, gUrl.length()));
            }
            if (gadgetContent != null) {
                if ("application/vnd.wso2.gs.gadget".equals(screenMediaType)) {
                    String[] gadgetData = this.addGadgetToRegistryFromZip(gadgetContent, gName.replace(" ", ""));
                    gUrl = gadgetData[0];
                    thumbRegistryPath = gadgetData[1];
                    if (gUrl == null) {
                        log.error((Object)"Backend server error : Gadget xml can not be found in zip file");
                        return false;
                    }
                } else {
                    gUrl = this.addGadgetToRegistryFromFile(gadgetContent, gName.replace(" ", ""));
                }
            }
            if (this.gadgetUrlExists(gUrl).booleanValue()) {
                log.error((Object)"Backend server error : Gadget Url already exist");
                return false;
            }
            registry = this.getConfigSystemRegistry();
            String gadgetRootPath = DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT;
            String gadgetRepoPath = gadgetRootPath + DashboardConstants.GADGETS_COL;
            String nextGadgetIdPath = gadgetRootPath + DashboardConstants.GADGETS_COL + DashboardConstants.NEXT_GADGET_ID_PATH;
            registry.beginTransaction();
            if (!registry.resourceExists(gadgetRootPath)) {
                Collection gadgetCol = registry.newCollection();
                registry.put(gadgetRepoPath, (Resource)gadgetCol);
            }
            if (!registry.resourceExists(nextGadgetIdPath)) {
                nextGadgetIdRes = registry.newResource();
                nextGadgetIdRes.setProperty(DashboardConstants.NEXT_GADGET_ID, "0");
                registry.put(nextGadgetIdPath, nextGadgetIdRes);
            }
            nextGadgetIdRes = registry.get(nextGadgetIdPath);
            String gadgetIdStr = nextGadgetIdRes.getProperty(DashboardConstants.NEXT_GADGET_ID);
            int gadgetId = Integer.parseInt(gadgetIdStr);
            Resource gadget = registry.newResource();
            gadget.setProperty(DashboardConstants.GADGET_NAME, gName);
            gadget.setProperty(DashboardConstants.GADGET_URL, gUrl);
            gadget.setProperty(DashboardConstants.GADGET_DESC, gDesc);
            gadget.setProperty(DashboardConstants.DEFAULT_GADGET, "false");
            if (gScreen != null) {
                thumbRegistryPath = this.addGadgetThumbToRegistry(gScreen, screenMediaType, gName.replace(" ", ""));
            }
            if (thumbRegistryPath != null) {
                gadget.setProperty("thumbUrl", thumbRegistryPath);
            }
            registry.put(gadgetRepoPath + DashboardConstants.GADGET_PREFIX + gadgetIdStr, gadget);
            int nextId = gadgetId + 1;
            nextGadgetIdRes.setProperty(DashboardConstants.NEXT_GADGET_ID, Integer.toString(nextId));
            registry.put(nextGadgetIdPath, nextGadgetIdRes);
            registry.commitTransaction();
            if (this.getConfigUserRegistry() instanceof UserRegistry) {
                String userId = ((UserRegistry)this.getConfigUserRegistry()).getUserName();
                ActivityManagerImpl manager = new ActivityManagerImpl();
                ActivityImpl activity = new ActivityImpl();
                activity.setTitle("added " + gName + "gadget to the gadget repository");
                activity.setUrl(gUrl);
                manager.createActivity(userId, "self", "gs", null, (Activity)activity);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to save the new gadget : " + e));
            if (registry != null) {
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
            return null;
        }
    }

    public Boolean modifyGadgetEntry(String gadegtPath, String gName, String gUrl, String gDesc, DataHandler gScreen, String screenMediaType, DataHandler gadgetContent) {
        try {
            Registry registry;
            if (gUrl != null && !"".equals(gUrl) && gUrl.length() >= 5 && "conf:".equals(gUrl.substring(0, 5))) {
                gUrl = this.addGadgetToRegistryFromRegistry(gUrl.substring(5, gUrl.length()));
            }
            if (gadgetContent != null) {
                gUrl = this.addGadgetToRegistryFromFile(gadgetContent, gName.replace(" ", ""));
            }
            if ((registry = this.getConfigSystemRegistry()).resourceExists(gadegtPath)) {
                Resource gadget = registry.get(gadegtPath);
                gadget.setProperty(DashboardConstants.GADGET_NAME, gName);
                gadget.setProperty(DashboardConstants.GADGET_URL, gUrl);
                gadget.setProperty(DashboardConstants.GADGET_DESC, gDesc);
                if (gScreen != null) {
                    String thumbRegistryPath = this.addGadgetThumbToRegistry(gScreen, screenMediaType, gName.replace(" ", ""));
                    gadget.setProperty("thumbUrl", thumbRegistryPath);
                }
                registry.put(gadegtPath, gadget);
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not modify gadget", (Throwable)e);
            return null;
        }
        return false;
    }

    public Boolean isSessionValid() {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        return !httpSession.isNew();
    }

    public Gadget[] getGadgetByName(String name) {
        List<Resource> rsList = this.getGadgetResList();
        if (rsList == null) {
            return null;
        }
        Gadget[] gadgetList = new Gadget[rsList.size()];
        int j = 0;
        try {
            Registry registry = this.getConfigSystemRegistry();
            for (int i = 0; i < rsList.size(); ++i) {
                Resource tempRes = rsList.get(i);
                String gadgetName = tempRes.getProperty(DashboardConstants.GADGET_NAME);
                if (gadgetName == null || !gadgetName.matches("(?i).*" + name + ".*")) continue;
                Gadget tempGadget = new Gadget();
                if (tempRes.getProperty(DashboardConstants.GADGET_URL) == null) continue;
                tempGadget.setGadgetName(tempRes.getProperty(DashboardConstants.GADGET_NAME));
                tempGadget.setGadgetUrl(tempRes.getProperty(DashboardConstants.GADGET_URL));
                if (tempRes.getProperty(DashboardConstants.GADGET_DESC) != null) {
                    tempGadget.setGadgetDesc(tempRes.getProperty(DashboardConstants.GADGET_DESC));
                } else {
                    tempGadget.setGadgetDesc("");
                }
                if (tempRes.getProperty(DashboardConstants.USER_CONTER) != null) {
                    tempGadget.setUserCount(tempRes.getProperty(DashboardConstants.USER_CONTER));
                }
                if (tempRes.getProperty(DashboardConstants.DEFAULT_GADGET) != null) {
                    tempGadget.setDefaultGadget(tempRes.getProperty(DashboardConstants.DEFAULT_GADGET));
                }
                if (tempRes.getProperty(DashboardConstants.UNSIGNED_USER_GADGET) != null) {
                    tempGadget.setUnsignedUserGadget(tempRes.getProperty(DashboardConstants.UNSIGNED_USER_GADGET));
                }
                if (tempRes.getProperty("thumbUrl") != null) {
                    tempGadget.setThumbUrl(tempRes.getProperty("thumbUrl"));
                }
                tempGadget.setGadgetPath(tempRes.getPath());
                tempGadget.setRating(Float.valueOf(registry.getAverageRating(tempRes.getPath())));
                gadgetList[j] = tempGadget;
                ++j;
            }
            return gadgetList;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not return the gadget list : ", (Throwable)e);
            return null;
        }
    }

    private String addGadgetThumbToRegistry(DataHandler gadgetThumb, String thumbMediaType, String gadgetName) throws GadgetRepoException {
        try {
            Registry registry = this.getConfigSystemRegistry();
            String regGadgetThumbPath = DashboardConstants.GS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH + gadgetName + "/thumb/" + gadgetName + "-thumb";
            Resource thumb = registry.newResource();
            thumb.setContentStream(gadgetThumb.getInputStream());
            thumb.setMediaType(thumbMediaType);
            registry.put(regGadgetThumbPath, thumb);
            String thumbPath = "/registry/resource/_system/config" + regGadgetThumbPath;
            return thumbPath;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error : Could not add gadget thumbnail to registry : ", (Throwable)e);
            return null;
        }
    }
}

