/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.mgt.gadgetrepo.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.mgt.gadgetrepo.GadgetRepoContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class GadgetZipUploadHandler
extends Handler {
    private static final Log log = LogFactory.getLog(GadgetZipUploadHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        UserRegistry sysRegistry = GadgetRepoContext.getRegistryService().getConfigSystemRegistry(tenantId);
        String gadgetName = requestContext.getResource().getProperty(DashboardConstants.GADGET_NAME);
        ZipInputStream zis = new ZipInputStream(requestContext.getResource().getContentStream());
        ZipEntry zipentry = null;
        byte[] buff = new byte[1024];
        try {
            zipentry = zis.getNextEntry();
            if (zipentry == null) {
                throw new RegistryException("Gadget bundle should be a zip file");
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        sysRegistry.beginTransaction();
        while (zipentry != null) {
            String entryName = zipentry.getName();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            if (zipentry.isDirectory()) {
                Collection col = sysRegistry.newCollection();
                sysRegistry.put(DashboardConstants.GS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH + gadgetName + "/" + entryName, (Resource)col);
            } else {
                Resource res = sysRegistry.newResource();
                try {
                    int i;
                    while ((i = zis.read(buff, 0, buff.length)) > 0) {
                        byteOut.write(buff, 0, i);
                    }
                }
                catch (IOException ioe) {
                    sysRegistry.rollbackTransaction();
                    log.error((Object)ioe);
                }
                res.setContent((Object)byteOut.toByteArray());
                if (entryName.contains(".xml")) {
                    res.setMediaType("application/vnd.wso2-gadget+xml");
                }
                sysRegistry.put(DashboardConstants.GS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH + gadgetName + "/" + entryName, res);
            }
            try {
                zipentry = zis.getNextEntry();
            }
            catch (IOException e) {
                sysRegistry.rollbackTransaction();
                log.error((Object)e);
            }
        }
        try {
            zis.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        sysRegistry.commitTransaction();
        requestContext.setProcessingComplete(true);
    }
}

